/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue.processing;

import com.google.protobuf.GeneratedMessageV3;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.context.ApplicationEventPublisher;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.dao.resource.TbResourceDataCache;
import org.thingsboard.server.dao.tenant.TbTenantProfileCache;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.util.AfterStartUp;
import org.thingsboard.server.service.apiusage.TbApiUsageStateService;
import org.thingsboard.server.service.cf.CalculatedFieldCache;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;
import org.thingsboard.server.service.queue.processing.AbstractConsumerService;
import org.thingsboard.server.service.security.auth.jwt.settings.JwtSettingsService;

public abstract class AbstractPartitionBasedConsumerService<N extends GeneratedMessageV3>
extends AbstractConsumerService<N> {
    private final Lock startupLock = new ReentrantLock();
    private volatile boolean started = false;
    private List<PartitionChangeEvent> pendingEvents = new ArrayList<PartitionChangeEvent>();

    public AbstractPartitionBasedConsumerService(ActorSystemContext actorContext, TbTenantProfileCache tenantProfileCache, TbDeviceProfileCache deviceProfileCache, TbAssetProfileCache assetProfileCache, TbResourceDataCache tbResourceDataCache, CalculatedFieldCache calculatedFieldCache, TbApiUsageStateService apiUsageStateService, PartitionService partitionService, ApplicationEventPublisher eventPublisher, JwtSettingsService jwtSettingsService) {
        super(actorContext, tenantProfileCache, deviceProfileCache, assetProfileCache, tbResourceDataCache, calculatedFieldCache, apiUsageStateService, partitionService, eventPublisher, jwtSettingsService);
    }

    @PostConstruct
    public void init() {
        super.init(this.getPrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AfterStartUp(order=11)
    public void afterStartUp() {
        super.afterStartUp();
        this.onStartUp();
        this.startupLock.lock();
        try {
            for (PartitionChangeEvent partitionChangeEvent : this.pendingEvents) {
                this.log.info("Handling partition change event: {}", (Object)partitionChangeEvent);
                try {
                    this.onPartitionChangeEvent(partitionChangeEvent);
                }
                catch (Throwable t) {
                    this.log.error("Failed to handle partition change event: {}", (Object)partitionChangeEvent, (Object)t);
                }
            }
            this.started = true;
            this.pendingEvents = null;
        }
        finally {
            this.startupLock.unlock();
        }
    }

    protected void onTbApplicationEvent(PartitionChangeEvent event) {
        this.log.debug("Received partition change event: {}", (Object)event);
        if (!this.started) {
            this.startupLock.lock();
            try {
                if (!this.started) {
                    this.log.debug("App not started yet, storing event for later: {}", (Object)event);
                    this.pendingEvents.add(event);
                    return;
                }
            }
            finally {
                this.startupLock.unlock();
            }
        }
        this.log.info("Handling partition change event: {}", (Object)event);
        this.onPartitionChangeEvent(event);
    }

    protected abstract void onStartUp();

    protected abstract void onPartitionChangeEvent(PartitionChangeEvent var1);

    protected abstract String getPrefix();
}

