/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TbTenantRuleEngineStats {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbTenantRuleEngineStats.class);
    private final UUID tenantId;
    private final AtomicInteger totalMsgCounter = new AtomicInteger(0);
    private final AtomicInteger successMsgCounter = new AtomicInteger(0);
    private final AtomicInteger tmpTimeoutMsgCounter = new AtomicInteger(0);
    private final AtomicInteger tmpFailedMsgCounter = new AtomicInteger(0);
    private final AtomicInteger timeoutMsgCounter = new AtomicInteger(0);
    private final AtomicInteger failedMsgCounter = new AtomicInteger(0);
    private final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();

    public TbTenantRuleEngineStats(UUID tenantId) {
        this.tenantId = tenantId;
        this.counters.put("totalMsgs", this.totalMsgCounter);
        this.counters.put("successfulMsgs", this.successMsgCounter);
        this.counters.put("timeoutMsgs", this.timeoutMsgCounter);
        this.counters.put("failedMsgs", this.failedMsgCounter);
        this.counters.put("tmpTimeout", this.tmpTimeoutMsgCounter);
        this.counters.put("tmpFailed", this.tmpFailedMsgCounter);
    }

    public void logSuccess() {
        this.totalMsgCounter.incrementAndGet();
        this.successMsgCounter.incrementAndGet();
    }

    public void logFailed() {
        this.totalMsgCounter.incrementAndGet();
        this.failedMsgCounter.incrementAndGet();
    }

    public void logTimeout() {
        this.totalMsgCounter.incrementAndGet();
        this.timeoutMsgCounter.incrementAndGet();
    }

    public void logTmpFailed() {
        this.totalMsgCounter.incrementAndGet();
        this.tmpFailedMsgCounter.incrementAndGet();
    }

    public void logTmpTimeout() {
        this.totalMsgCounter.incrementAndGet();
        this.tmpTimeoutMsgCounter.incrementAndGet();
    }

    public void printStats() {
        int total = this.totalMsgCounter.get();
        if (total > 0) {
            StringBuilder stats = new StringBuilder();
            this.counters.forEach((label, value) -> stats.append((String)label).append(" = [").append(value.get()).append("]"));
            log.info("[{}] Stats: {}", (Object)this.tenantId, (Object)stats);
        }
    }

    public void reset() {
        this.counters.values().forEach(counter -> counter.set(0));
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public AtomicInteger getTotalMsgCounter() {
        return this.totalMsgCounter;
    }

    @Generated
    public AtomicInteger getSuccessMsgCounter() {
        return this.successMsgCounter;
    }

    @Generated
    public AtomicInteger getTmpTimeoutMsgCounter() {
        return this.tmpTimeoutMsgCounter;
    }

    @Generated
    public AtomicInteger getTmpFailedMsgCounter() {
        return this.tmpFailedMsgCounter;
    }

    @Generated
    public AtomicInteger getTimeoutMsgCounter() {
        return this.timeoutMsgCounter;
    }

    @Generated
    public AtomicInteger getFailedMsgCounter() {
        return this.failedMsgCounter;
    }

    @Generated
    public Map<String, AtomicInteger> getCounters() {
        return this.counters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbTenantRuleEngineStats)) {
            return false;
        }
        TbTenantRuleEngineStats other = (TbTenantRuleEngineStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        AtomicInteger this$totalMsgCounter = this.getTotalMsgCounter();
        AtomicInteger other$totalMsgCounter = other.getTotalMsgCounter();
        if (this$totalMsgCounter == null ? other$totalMsgCounter != null : !this$totalMsgCounter.equals(other$totalMsgCounter)) {
            return false;
        }
        AtomicInteger this$successMsgCounter = this.getSuccessMsgCounter();
        AtomicInteger other$successMsgCounter = other.getSuccessMsgCounter();
        if (this$successMsgCounter == null ? other$successMsgCounter != null : !this$successMsgCounter.equals(other$successMsgCounter)) {
            return false;
        }
        AtomicInteger this$tmpTimeoutMsgCounter = this.getTmpTimeoutMsgCounter();
        AtomicInteger other$tmpTimeoutMsgCounter = other.getTmpTimeoutMsgCounter();
        if (this$tmpTimeoutMsgCounter == null ? other$tmpTimeoutMsgCounter != null : !this$tmpTimeoutMsgCounter.equals(other$tmpTimeoutMsgCounter)) {
            return false;
        }
        AtomicInteger this$tmpFailedMsgCounter = this.getTmpFailedMsgCounter();
        AtomicInteger other$tmpFailedMsgCounter = other.getTmpFailedMsgCounter();
        if (this$tmpFailedMsgCounter == null ? other$tmpFailedMsgCounter != null : !this$tmpFailedMsgCounter.equals(other$tmpFailedMsgCounter)) {
            return false;
        }
        AtomicInteger this$timeoutMsgCounter = this.getTimeoutMsgCounter();
        AtomicInteger other$timeoutMsgCounter = other.getTimeoutMsgCounter();
        if (this$timeoutMsgCounter == null ? other$timeoutMsgCounter != null : !this$timeoutMsgCounter.equals(other$timeoutMsgCounter)) {
            return false;
        }
        AtomicInteger this$failedMsgCounter = this.getFailedMsgCounter();
        AtomicInteger other$failedMsgCounter = other.getFailedMsgCounter();
        if (this$failedMsgCounter == null ? other$failedMsgCounter != null : !this$failedMsgCounter.equals(other$failedMsgCounter)) {
            return false;
        }
        Map<String, AtomicInteger> this$counters = this.getCounters();
        Map<String, AtomicInteger> other$counters = other.getCounters();
        return !(this$counters == null ? other$counters != null : !((Object)this$counters).equals(other$counters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TbTenantRuleEngineStats;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        AtomicInteger $totalMsgCounter = this.getTotalMsgCounter();
        result = result * 59 + ($totalMsgCounter == null ? 43 : $totalMsgCounter.hashCode());
        AtomicInteger $successMsgCounter = this.getSuccessMsgCounter();
        result = result * 59 + ($successMsgCounter == null ? 43 : $successMsgCounter.hashCode());
        AtomicInteger $tmpTimeoutMsgCounter = this.getTmpTimeoutMsgCounter();
        result = result * 59 + ($tmpTimeoutMsgCounter == null ? 43 : $tmpTimeoutMsgCounter.hashCode());
        AtomicInteger $tmpFailedMsgCounter = this.getTmpFailedMsgCounter();
        result = result * 59 + ($tmpFailedMsgCounter == null ? 43 : $tmpFailedMsgCounter.hashCode());
        AtomicInteger $timeoutMsgCounter = this.getTimeoutMsgCounter();
        result = result * 59 + ($timeoutMsgCounter == null ? 43 : $timeoutMsgCounter.hashCode());
        AtomicInteger $failedMsgCounter = this.getFailedMsgCounter();
        result = result * 59 + ($failedMsgCounter == null ? 43 : $failedMsgCounter.hashCode());
        Map<String, AtomicInteger> $counters = this.getCounters();
        result = result * 59 + ($counters == null ? 43 : ((Object)$counters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TbTenantRuleEngineStats(tenantId=" + String.valueOf(this.getTenantId()) + ", totalMsgCounter=" + String.valueOf(this.getTotalMsgCounter()) + ", successMsgCounter=" + String.valueOf(this.getSuccessMsgCounter()) + ", tmpTimeoutMsgCounter=" + String.valueOf(this.getTmpTimeoutMsgCounter()) + ", tmpFailedMsgCounter=" + String.valueOf(this.getTmpFailedMsgCounter()) + ", timeoutMsgCounter=" + String.valueOf(this.getTimeoutMsgCounter()) + ", failedMsgCounter=" + String.valueOf(this.getFailedMsgCounter()) + ", counters=" + String.valueOf(this.getCounters()) + ")";
    }
}

