/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.queue;

import com.google.protobuf.GeneratedMessageV3;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cache.TbCacheValueWrapper;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.HasRuleEngineProfile;
import org.thingsboard.server.common.data.ResourceType;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.DeviceProfileId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.QueueId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.plugin.ComponentLifecycleEvent;
import org.thingsboard.server.common.data.queue.Queue;
import org.thingsboard.server.common.data.rpc.RpcError;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.ToDeviceActorNotificationMsg;
import org.thingsboard.server.common.msg.edge.EdgeEventUpdateMsg;
import org.thingsboard.server.common.msg.edge.EdgeHighPriorityMsg;
import org.thingsboard.server.common.msg.edge.FromEdgeSyncResponse;
import org.thingsboard.server.common.msg.edge.ToEdgeSyncRequest;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponse;
import org.thingsboard.server.common.msg.rule.engine.DeviceEdgeUpdateMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceNameOrTypeUpdateMsg;
import org.thingsboard.server.common.util.ProtoUtils;
import org.thingsboard.server.dao.edge.EdgeService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.MultipleTbQueueCallbackWrapper;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.common.TbRuleEngineProducerService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.service.gateway_device.GatewayNotificationsService;
import org.thingsboard.server.service.ota.OtaPackageStateService;
import org.thingsboard.server.service.profile.TbAssetProfileCache;
import org.thingsboard.server.service.profile.TbDeviceProfileCache;

@Service
public class DefaultTbClusterService
implements TbClusterService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbClusterService.class);
    @Value(value="${cluster.stats.enabled:false}")
    private boolean statsEnabled;
    @Value(value="${edges.enabled:true}")
    protected boolean edgesEnabled;
    private final AtomicInteger toCoreMsgs = new AtomicInteger(0);
    private final AtomicInteger toCoreNfs = new AtomicInteger(0);
    private final AtomicInteger toRuleEngineMsgs = new AtomicInteger(0);
    private final AtomicInteger toRuleEngineNfs = new AtomicInteger(0);
    private final AtomicInteger toTransportNfs = new AtomicInteger(0);
    private final AtomicInteger toEdgeMsgs = new AtomicInteger(0);
    private final AtomicInteger toEdgeNfs = new AtomicInteger(0);
    @Autowired
    private PartitionService partitionService;
    @Autowired
    private TbQueueProducerProvider producerProvider;
    @Autowired
    private TbRuleEngineProducerService ruleEngineProducerService;
    @Autowired
    @Lazy
    private OtaPackageStateService otaPackageStateService;
    private final TopicService topicService;
    private final TbDeviceProfileCache deviceProfileCache;
    private final TbAssetProfileCache assetProfileCache;
    private final GatewayNotificationsService gatewayNotificationsService;
    private final EdgeService edgeService;
    private final TbTransactionalCache<EdgeId, String> edgeIdServiceIdCache;

    public void pushMsgToCore(TenantId tenantId, EntityId entityId, TransportProtos.ToCoreMsg msg, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, entityId);
        this.producerProvider.getTbCoreMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)msg), callback);
        this.toCoreMsgs.incrementAndGet();
    }

    public void pushMsgToCore(TopicPartitionInfo tpi, UUID msgId, TransportProtos.ToCoreMsg msg, TbQueueCallback callback) {
        this.producerProvider.getTbCoreMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(msgId, (GeneratedMessageV3)msg), callback);
        this.toCoreMsgs.incrementAndGet();
    }

    public void pushMsgToCore(ToDeviceActorNotificationMsg msg, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, msg.getTenantId(), (EntityId)msg.getDeviceId());
        log.trace("PUSHING msg: {} to:{}", (Object)msg, (Object)tpi);
        TransportProtos.ToCoreMsg toCoreMsg = TransportProtos.ToCoreMsg.newBuilder().setToDeviceActorNotification(ProtoUtils.toProto((ToDeviceActorNotificationMsg)msg)).build();
        this.producerProvider.getTbCoreMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(msg.getDeviceId().getId(), (GeneratedMessageV3)toCoreMsg), callback);
        this.toCoreMsgs.incrementAndGet();
    }

    public void broadcastToCore(TransportProtos.ToCoreNotificationMsg toCoreMsg) {
        UUID msgId = UUID.randomUUID();
        TbQueueProducer toCoreNfProducer = this.producerProvider.getTbCoreNotificationsMsgProducer();
        Set tbCoreServices = this.partitionService.getAllServiceIds(ServiceType.TB_CORE);
        for (String serviceId : tbCoreServices) {
            TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_CORE, serviceId);
            toCoreNfProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(msgId, (GeneratedMessageV3)toCoreMsg), null);
            this.toCoreNfs.incrementAndGet();
        }
    }

    public void broadcastToCalculatedFields(TransportProtos.ToCalculatedFieldNotificationMsg toCfMsg, TbQueueCallback callback) {
        UUID msgId = UUID.randomUUID();
        TbQueueProducer toCfProducer = this.producerProvider.getCalculatedFieldsNotificationsMsgProducer();
        Set tbReServices = this.partitionService.getAllServiceIds(ServiceType.TB_RULE_ENGINE);
        MultipleTbQueueCallbackWrapper callbackWrapper = new MultipleTbQueueCallbackWrapper(tbReServices.size(), callback);
        for (String serviceId : tbReServices) {
            TopicPartitionInfo tpi = this.topicService.getCalculatedFieldNotificationsTopic(serviceId);
            toCfProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(msgId, (GeneratedMessageV3)toCfMsg), (TbQueueCallback)callbackWrapper);
            this.toRuleEngineNfs.incrementAndGet();
        }
    }

    public void pushMsgToVersionControl(TenantId tenantId, TransportProtos.ToVersionControlServiceMsg msg, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_VC_EXECUTOR, TenantId.SYS_TENANT_ID, (EntityId)tenantId);
        log.trace("PUSHING msg: {} to:{}", (Object)msg, (Object)tpi);
        this.producerProvider.getTbVersionControlMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(tenantId.getId(), (GeneratedMessageV3)msg), callback);
        this.toCoreMsgs.incrementAndGet();
    }

    public void pushNotificationToCore(String serviceId, FromDeviceRpcResponse response, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_CORE, serviceId);
        log.trace("PUSHING msg: {} to:{}", (Object)response, (Object)tpi);
        TransportProtos.FromDeviceRPCResponseProto.Builder builder = TransportProtos.FromDeviceRPCResponseProto.newBuilder().setRequestIdMSB(response.getId().getMostSignificantBits()).setRequestIdLSB(response.getId().getLeastSignificantBits()).setError(response.getError().isPresent() ? ((RpcError)response.getError().get()).ordinal() : -1);
        response.getResponse().ifPresent(arg_0 -> ((TransportProtos.FromDeviceRPCResponseProto.Builder)builder).setResponse(arg_0));
        TransportProtos.ToCoreNotificationMsg msg = TransportProtos.ToCoreNotificationMsg.newBuilder().setFromDeviceRpcResponse(builder).build();
        this.producerProvider.getTbCoreNotificationsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(response.getId(), (GeneratedMessageV3)msg), callback);
        this.toCoreNfs.incrementAndGet();
    }

    public void pushNotificationToCore(String targetServiceId, TransportProtos.RestApiCallResponseMsgProto responseMsgProto, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_CORE, targetServiceId);
        TransportProtos.ToCoreNotificationMsg msg = TransportProtos.ToCoreNotificationMsg.newBuilder().setRestApiCallResponseMsg(responseMsgProto).build();
        this.producerProvider.getTbCoreNotificationsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)msg), callback);
        this.toCoreNfs.incrementAndGet();
    }

    public void pushMsgToRuleEngine(TopicPartitionInfo tpi, UUID msgId, TransportProtos.ToRuleEngineMsg msg, TbQueueCallback callback) {
        log.trace("PUSHING msg: {} to:{}", (Object)msg, (Object)tpi);
        this.producerProvider.getRuleEngineMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(msgId, (GeneratedMessageV3)msg), callback);
        this.toRuleEngineMsgs.incrementAndGet();
    }

    public void pushMsgToRuleEngine(TenantId tenantId, EntityId entityId, TbMsg tbMsg, TbQueueCallback callback) {
        this.pushMsgToRuleEngine(tenantId, entityId, tbMsg, false, callback);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void pushMsgToRuleEngine(TenantId tenantId, EntityId entityId, TbMsg tbMsg, boolean useQueueFromTbMsg, TbQueueCallback callback) {
        if (tenantId == null || tenantId.isNullUid()) {
            if (!entityId.getEntityType().equals((Object)EntityType.TENANT)) {
                log.warn("[{}][{}] Received invalid message: {}", new Object[]{tenantId, entityId, tbMsg});
                return;
            }
            tenantId = TenantId.fromUUID((UUID)entityId.getId());
        } else {
            HasRuleEngineProfile ruleEngineProfile = this.getRuleEngineProfileForEntityOrElseNull(tenantId, entityId, tbMsg);
            tbMsg = this.transformMsg(tbMsg, ruleEngineProfile, useQueueFromTbMsg);
        }
        this.ruleEngineProducerService.sendToRuleEngine(this.producerProvider.getRuleEngineMsgProducer(), tenantId, tbMsg, callback);
        this.toRuleEngineMsgs.incrementAndGet();
    }

    HasRuleEngineProfile getRuleEngineProfileForEntityOrElseNull(TenantId tenantId, EntityId entityId, TbMsg tbMsg) {
        if (entityId.getEntityType().equals((Object)EntityType.DEVICE)) {
            if (TbMsgType.ENTITY_DELETED.equals((Object)tbMsg.getInternalType())) {
                try {
                    Device deletedDevice = (Device)JacksonUtil.fromString((String)tbMsg.getData(), Device.class);
                    if (deletedDevice == null) {
                        return null;
                    }
                    return this.deviceProfileCache.get(tenantId, deletedDevice.getDeviceProfileId());
                }
                catch (Exception e) {
                    log.warn("[{}][{}] Failed to deserialize device: {}", new Object[]{tenantId, entityId, tbMsg, e});
                    return null;
                }
            }
            return this.deviceProfileCache.get(tenantId, new DeviceId(entityId.getId()));
        }
        if (entityId.getEntityType().equals((Object)EntityType.DEVICE_PROFILE)) {
            return this.deviceProfileCache.get(tenantId, new DeviceProfileId(entityId.getId()));
        }
        if (entityId.getEntityType().equals((Object)EntityType.ASSET)) {
            if (TbMsgType.ENTITY_DELETED.equals((Object)tbMsg.getInternalType())) {
                try {
                    Asset deletedAsset = (Asset)JacksonUtil.fromString((String)tbMsg.getData(), Asset.class);
                    if (deletedAsset == null) {
                        return null;
                    }
                    return this.assetProfileCache.get(tenantId, deletedAsset.getAssetProfileId());
                }
                catch (Exception e) {
                    log.warn("[{}][{}] Failed to deserialize asset: {}", new Object[]{tenantId, entityId, tbMsg, e});
                    return null;
                }
            }
            return this.assetProfileCache.get(tenantId, new AssetId(entityId.getId()));
        }
        if (entityId.getEntityType().equals((Object)EntityType.ASSET_PROFILE)) {
            return this.assetProfileCache.get(tenantId, new AssetProfileId(entityId.getId()));
        }
        return null;
    }

    private TbMsg transformMsg(TbMsg tbMsg, HasRuleEngineProfile ruleEngineProfile, boolean useQueueFromTbMsg) {
        if (ruleEngineProfile != null) {
            boolean isQueueTransform;
            RuleChainId targetRuleChainId = ruleEngineProfile.getDefaultRuleChainId();
            String targetQueueName = useQueueFromTbMsg ? tbMsg.getQueueName() : ruleEngineProfile.getDefaultQueueName();
            boolean isRuleChainTransform = targetRuleChainId != null && !targetRuleChainId.equals((Object)tbMsg.getRuleChainId());
            boolean bl = isQueueTransform = targetQueueName != null && !targetQueueName.equals(tbMsg.getQueueName());
            if (isRuleChainTransform && isQueueTransform) {
                tbMsg = tbMsg.transform().queueName(targetQueueName).ruleChainId(targetRuleChainId).build();
            } else if (isRuleChainTransform) {
                tbMsg = tbMsg.transform().ruleChainId(targetRuleChainId).build();
            } else if (isQueueTransform) {
                tbMsg = tbMsg.transform(targetQueueName);
            }
        }
        return tbMsg;
    }

    public void pushNotificationToRuleEngine(String serviceId, FromDeviceRpcResponse response, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_RULE_ENGINE, serviceId);
        log.trace("PUSHING msg: {} to:{}", (Object)response, (Object)tpi);
        TransportProtos.FromDeviceRPCResponseProto.Builder builder = TransportProtos.FromDeviceRPCResponseProto.newBuilder().setRequestIdMSB(response.getId().getMostSignificantBits()).setRequestIdLSB(response.getId().getLeastSignificantBits()).setError(response.getError().isPresent() ? ((RpcError)response.getError().get()).ordinal() : -1);
        response.getResponse().ifPresent(arg_0 -> ((TransportProtos.FromDeviceRPCResponseProto.Builder)builder).setResponse(arg_0));
        TransportProtos.ToRuleEngineNotificationMsg msg = TransportProtos.ToRuleEngineNotificationMsg.newBuilder().setFromDeviceRpcResponse(builder).build();
        this.producerProvider.getRuleEngineNotificationsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(response.getId(), (GeneratedMessageV3)msg), callback);
        this.toRuleEngineNfs.incrementAndGet();
    }

    public void pushNotificationToTransport(String serviceId, TransportProtos.ToTransportMsg response, TbQueueCallback callback) {
        if (serviceId == null || serviceId.isEmpty()) {
            log.trace("pushNotificationToTransport: skipping message without serviceId [{}], (ToTransportMsg) response [{}]", (Object)serviceId, (Object)response);
            if (callback != null) {
                callback.onSuccess(null);
            }
            return;
        }
        TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_TRANSPORT, serviceId);
        log.trace("PUSHING msg: {} to:{}", (Object)response, (Object)tpi);
        this.producerProvider.getTransportNotificationsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)response), callback);
        this.toTransportNfs.incrementAndGet();
    }

    public void pushMsgToCalculatedFields(TenantId tenantId, EntityId entityId, TransportProtos.ToCalculatedFieldMsg msg, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_RULE_ENGINE, "CalculatedFields", tenantId, entityId);
        this.pushMsgToCalculatedFields(tpi, UUID.randomUUID(), msg, callback);
    }

    public void pushMsgToCalculatedFields(TopicPartitionInfo tpi, UUID msgId, TransportProtos.ToCalculatedFieldMsg msg, TbQueueCallback callback) {
        log.trace("PUSHING msg: {} to:{}", (Object)msg, (Object)tpi);
        this.producerProvider.getCalculatedFieldsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(msgId, (GeneratedMessageV3)msg), callback);
        this.toRuleEngineMsgs.incrementAndGet();
    }

    public void broadcastEntityStateChangeEvent(TenantId tenantId, EntityId entityId, ComponentLifecycleEvent state) {
        log.trace("[{}] Processing {} state change event: {}", new Object[]{tenantId, entityId.getEntityType(), state});
        this.broadcast(new ComponentLifecycleMsg(tenantId, entityId, state));
    }

    public void onDeviceProfileChange(DeviceProfile deviceProfile, DeviceProfile oldDeviceProfile, TbQueueCallback callback) {
        boolean isFirmwareChanged = false;
        boolean isSoftwareChanged = false;
        if (oldDeviceProfile != null) {
            isFirmwareChanged = !Objects.equals(deviceProfile.getFirmwareId(), oldDeviceProfile.getFirmwareId());
            isSoftwareChanged = !Objects.equals(deviceProfile.getSoftwareId(), oldDeviceProfile.getSoftwareId());
        }
        this.broadcastEntityChangeToTransport(deviceProfile.getTenantId(), (EntityId)deviceProfile.getId(), deviceProfile, callback);
        this.broadcastEntityStateChangeEvent(deviceProfile.getTenantId(), (EntityId)deviceProfile.getId(), oldDeviceProfile == null ? ComponentLifecycleEvent.CREATED : ComponentLifecycleEvent.UPDATED);
        this.otaPackageStateService.update(deviceProfile, isFirmwareChanged, isSoftwareChanged);
    }

    public void onTenantProfileChange(TenantProfile tenantProfile, TbQueueCallback callback) {
        this.broadcastEntityChangeToTransport(TenantId.SYS_TENANT_ID, (EntityId)tenantProfile.getId(), tenantProfile, callback);
    }

    public void onTenantChange(Tenant tenant, TbQueueCallback callback) {
        this.broadcastEntityChangeToTransport(TenantId.SYS_TENANT_ID, (EntityId)tenant.getId(), tenant, callback);
    }

    public void onApiStateChange(ApiUsageState apiUsageState, TbQueueCallback callback) {
        this.broadcastEntityChangeToTransport(apiUsageState.getTenantId(), (EntityId)apiUsageState.getId(), apiUsageState, callback);
        this.broadcast(new ComponentLifecycleMsg(apiUsageState.getTenantId(), (EntityId)apiUsageState.getId(), ComponentLifecycleEvent.UPDATED));
    }

    public void onDeviceProfileDelete(DeviceProfile entity, TbQueueCallback callback) {
        this.broadcastEntityDeleteToTransport(entity.getTenantId(), (EntityId)entity.getId(), entity.getName(), callback);
    }

    public void onTenantProfileDelete(TenantProfile entity, TbQueueCallback callback) {
        this.broadcastEntityDeleteToTransport(TenantId.SYS_TENANT_ID, (EntityId)entity.getId(), entity.getName(), callback);
    }

    public void onTenantDelete(Tenant entity, TbQueueCallback callback) {
        this.broadcastEntityDeleteToTransport(TenantId.SYS_TENANT_ID, (EntityId)entity.getId(), entity.getName(), callback);
    }

    public void onDeviceDeleted(TenantId tenantId, Device device, TbQueueCallback callback) {
        DeviceId deviceId = device.getId();
        this.gatewayNotificationsService.onDeviceDeleted(device);
        this.broadcastEntityDeleteToTransport(tenantId, (EntityId)deviceId, device.getName(), callback);
        this.sendDeviceStateServiceEvent(tenantId, deviceId, false, false, true);
        this.broadcastEntityStateChangeEvent(tenantId, (EntityId)deviceId, ComponentLifecycleEvent.DELETED);
    }

    public void onAssetDeleted(TenantId tenantId, Asset asset, TbQueueCallback callback) {
        AssetId assetId = asset.getId();
        this.broadcastEntityStateChangeEvent(tenantId, (EntityId)assetId, ComponentLifecycleEvent.DELETED);
    }

    public void onDeviceAssignedToTenant(TenantId oldTenantId, Device device) {
        this.onDeviceDeleted(oldTenantId, device, null);
        this.sendDeviceStateServiceEvent(device.getTenantId(), device.getId(), true, false, false);
    }

    public void onResourceChange(TbResourceInfo resource, TbQueueCallback callback) {
        TenantId tenantId = resource.getTenantId();
        TbResourceId resourceId = resource.getId();
        if (resource.getResourceType() == ResourceType.LWM2M_MODEL) {
            log.trace("[{}][{}][{}] Processing change resource", new Object[]{tenantId, resource.getResourceType(), resource.getResourceKey()});
            TransportProtos.ResourceUpdateMsg resourceUpdateMsg = TransportProtos.ResourceUpdateMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setResourceType(resource.getResourceType().name()).setResourceKey(resource.getResourceKey()).build();
            TransportProtos.ToTransportMsg transportMsg = TransportProtos.ToTransportMsg.newBuilder().setResourceUpdateMsg(resourceUpdateMsg).build();
            this.broadcast(transportMsg, "LWM2M", callback);
        }
        this.broadcastEntityStateChangeEvent(tenantId, (EntityId)resourceId, ComponentLifecycleEvent.UPDATED);
    }

    public void onResourceDeleted(TbResourceInfo resource, TbQueueCallback callback) {
        if (resource.getResourceType() == ResourceType.LWM2M_MODEL) {
            log.trace("[{}][{}][{}] Processing delete resource", new Object[]{resource.getTenantId(), resource.getResourceType(), resource.getResourceKey()});
            TransportProtos.ResourceDeleteMsg resourceDeleteMsg = TransportProtos.ResourceDeleteMsg.newBuilder().setTenantIdMSB(resource.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(resource.getTenantId().getId().getLeastSignificantBits()).setResourceType(resource.getResourceType().name()).setResourceKey(resource.getResourceKey()).build();
            TransportProtos.ToTransportMsg transportMsg = TransportProtos.ToTransportMsg.newBuilder().setResourceDeleteMsg(resourceDeleteMsg).build();
            this.broadcast(transportMsg, "LWM2M", callback);
        }
        this.broadcastEntityStateChangeEvent(resource.getTenantId(), (EntityId)resource.getId(), ComponentLifecycleEvent.DELETED);
    }

    private <T> void broadcastEntityChangeToTransport(TenantId tenantId, EntityId entityid, T entity, TbQueueCallback callback) {
        String entityName = entity instanceof HasName ? ((HasName)entity).getName() : entity.getClass().getName();
        log.trace("[{}][{}][{}] Processing [{}] change event", new Object[]{tenantId, entityid.getEntityType(), entityid.getId(), entityName});
        TransportProtos.ToTransportMsg transportMsg = TransportProtos.ToTransportMsg.newBuilder().setEntityUpdateMsg(ProtoUtils.toEntityUpdateProto(entity)).build();
        this.broadcast(transportMsg, callback);
    }

    private void broadcastEntityDeleteToTransport(TenantId tenantId, EntityId entityId, String name, TbQueueCallback callback) {
        log.trace("[{}][{}][{}] Processing [{}] delete event", new Object[]{tenantId, entityId.getEntityType(), entityId.getId(), name});
        TransportProtos.EntityDeleteMsg entityDeleteMsg = TransportProtos.EntityDeleteMsg.newBuilder().setEntityType(entityId.getEntityType().name()).setEntityIdMSB(entityId.getId().getMostSignificantBits()).setEntityIdLSB(entityId.getId().getLeastSignificantBits()).build();
        TransportProtos.ToTransportMsg transportMsg = TransportProtos.ToTransportMsg.newBuilder().setEntityDeleteMsg(entityDeleteMsg).build();
        this.broadcast(transportMsg, callback);
    }

    private void broadcast(TransportProtos.ToTransportMsg transportMsg, TbQueueCallback callback) {
        Set tbTransportServices = this.partitionService.getAllServiceIds(ServiceType.TB_TRANSPORT);
        this.broadcast(transportMsg, tbTransportServices, callback);
    }

    private void broadcast(TransportProtos.ToTransportMsg transportMsg, String transportType, TbQueueCallback callback) {
        Set<String> tbTransportServices = this.partitionService.getAllServices(ServiceType.TB_TRANSPORT).stream().filter(info -> info.getTransportsList().contains((Object)transportType)).map(TransportProtos.ServiceInfo::getServiceId).collect(Collectors.toSet());
        this.broadcast(transportMsg, tbTransportServices, callback);
    }

    private void broadcast(TransportProtos.ToTransportMsg transportMsg, Set<String> tbTransportServices, TbQueueCallback callback) {
        TbQueueProducer toTransportNfProducer = this.producerProvider.getTransportNotificationsMsgProducer();
        MultipleTbQueueCallbackWrapper proxyCallback = callback != null ? new MultipleTbQueueCallbackWrapper(tbTransportServices.size(), callback) : null;
        for (String transportServiceId : tbTransportServices) {
            TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_TRANSPORT, transportServiceId);
            toTransportNfProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)transportMsg), (TbQueueCallback)proxyCallback);
            this.toTransportNfs.incrementAndGet();
        }
    }

    public void pushMsgToEdge(TenantId tenantId, EntityId entityId, TransportProtos.ToEdgeMsg msg, TbQueueCallback callback) {
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, "Edge", tenantId, entityId);
        TbQueueProducer toEdgeProducer = this.producerProvider.getTbEdgeMsgProducer();
        toEdgeProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)msg), callback);
        this.toEdgeMsgs.incrementAndGet();
    }

    public void onEdgeHighPriorityMsg(EdgeHighPriorityMsg msg) {
        log.trace("[{}] Processing edge event for edgeId: {}", (Object)msg.getTenantId(), (Object)msg.getEdgeEvent().getEdgeId());
        TransportProtos.ToEdgeNotificationMsg toEdgeNotificationMsg = TransportProtos.ToEdgeNotificationMsg.newBuilder().setEdgeHighPriority(ProtoUtils.toProto((EdgeHighPriorityMsg)msg)).build();
        this.processEdgeNotification(msg.getEdgeEvent().getEdgeId(), toEdgeNotificationMsg);
    }

    public void onEdgeEventUpdate(EdgeEventUpdateMsg msg) {
        log.trace("[{}] Processing edge event update for edgeId: {}", (Object)msg.getTenantId(), (Object)msg.getEdgeId());
        TransportProtos.ToEdgeNotificationMsg toEdgeNotificationMsg = TransportProtos.ToEdgeNotificationMsg.newBuilder().setEdgeEventUpdate(ProtoUtils.toProto((EdgeEventUpdateMsg)msg)).build();
        this.processEdgeNotification(msg.getEdgeId(), toEdgeNotificationMsg);
    }

    public void onEdgeStateChangeEvent(ComponentLifecycleMsg msg) {
        log.trace("[{}] Processing {} state change event: {}", new Object[]{msg.getTenantId(), EntityType.EDGE, msg.getEvent()});
        TransportProtos.ComponentLifecycleMsgProto componentLifecycleMsgProto = ProtoUtils.toProto((ComponentLifecycleMsg)msg);
        TransportProtos.ToEdgeNotificationMsg toEdgeNotificationMsg = TransportProtos.ToEdgeNotificationMsg.newBuilder().setComponentLifecycle(componentLifecycleMsgProto).build();
        this.processEdgeNotification((EdgeId)msg.getEntityId(), toEdgeNotificationMsg);
    }

    public void pushEdgeSyncRequestToEdge(ToEdgeSyncRequest request) {
        log.trace("[{}] Processing edge sync request for edgeId: {}", (Object)request.getTenantId(), (Object)request.getEdgeId());
        TransportProtos.ToEdgeNotificationMsg toEdgeNotificationMsg = TransportProtos.ToEdgeNotificationMsg.newBuilder().setToEdgeSyncRequest(ProtoUtils.toProto((ToEdgeSyncRequest)request)).build();
        this.processEdgeNotification(request.getEdgeId(), toEdgeNotificationMsg);
    }

    public void pushEdgeSyncResponseToCore(FromEdgeSyncResponse response, String requestServiceId) {
        log.trace("[{}] Processing edge sync response for edgeId: {}", (Object)response.getTenantId(), (Object)response.getEdgeId());
        TransportProtos.ToEdgeNotificationMsg toEdgeNotificationMsg = TransportProtos.ToEdgeNotificationMsg.newBuilder().setFromEdgeSyncResponse(ProtoUtils.toProto((FromEdgeSyncResponse)response)).build();
        this.pushMsgToEdgeNotification(toEdgeNotificationMsg, requestServiceId);
    }

    private void processEdgeNotification(EdgeId edgeId, TransportProtos.ToEdgeNotificationMsg toEdgeNotificationMsg) {
        if (this.edgesEnabled) {
            Optional<TbCacheValueWrapper> serviceIdOpt = Optional.ofNullable(this.edgeIdServiceIdCache.get((Serializable)edgeId));
            serviceIdOpt.ifPresentOrElse(serviceId -> this.pushMsgToEdgeNotification(toEdgeNotificationMsg, (String)serviceId.get()), () -> this.broadcastEdgeNotification(edgeId, toEdgeNotificationMsg));
        } else {
            log.trace("Edges disabled. Ignoring edge notification {} for edgeId: {}", (Object)toEdgeNotificationMsg, (Object)edgeId);
        }
    }

    private void pushMsgToEdgeNotification(TransportProtos.ToEdgeNotificationMsg toEdgeNotificationMsg, String serviceId) {
        TopicPartitionInfo tpi = this.topicService.getEdgeNotificationsTopic(serviceId);
        TbQueueProducer toEdgeNotificationProducer = this.producerProvider.getTbEdgeNotificationsMsgProducer();
        toEdgeNotificationProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)toEdgeNotificationMsg), null);
        this.toEdgeNfs.incrementAndGet();
    }

    private void broadcastEdgeNotification(EdgeId edgeId, TransportProtos.ToEdgeNotificationMsg toEdgeNotificationMsg) {
        TbQueueProducer toEdgeNotificationProducer = this.producerProvider.getTbEdgeNotificationsMsgProducer();
        Set serviceIds = this.partitionService.getAllServiceIds(ServiceType.TB_CORE);
        for (String serviceId : serviceIds) {
            TopicPartitionInfo tpi = this.topicService.getEdgeNotificationsTopic(serviceId);
            toEdgeNotificationProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(edgeId.getId(), (GeneratedMessageV3)toEdgeNotificationMsg), null);
            this.toEdgeNfs.incrementAndGet();
        }
    }

    public void broadcast(ComponentLifecycleMsg msg) {
        TransportProtos.ComponentLifecycleMsgProto componentLifecycleMsgProto = ProtoUtils.toProto((ComponentLifecycleMsg)msg);
        TbQueueProducer toRuleEngineProducer = this.producerProvider.getRuleEngineNotificationsMsgProducer();
        Set tbRuleEngineServices = this.partitionService.getAllServiceIds(ServiceType.TB_RULE_ENGINE);
        EntityType entityType = msg.getEntityId().getEntityType();
        if (entityType.isOneOf(new EntityType[]{EntityType.TENANT, EntityType.API_USAGE_STATE, EntityType.ENTITY_VIEW, EntityType.NOTIFICATION_RULE, EntityType.CALCULATED_FIELD, EntityType.TENANT_PROFILE, EntityType.DEVICE_PROFILE, EntityType.ASSET_PROFILE, EntityType.JOB, EntityType.TB_RESOURCE}) || entityType == EntityType.ASSET && msg.getEvent() == ComponentLifecycleEvent.UPDATED || entityType == EntityType.DEVICE && msg.getEvent() == ComponentLifecycleEvent.UPDATED) {
            TbQueueProducer toCoreNfProducer = this.producerProvider.getTbCoreNotificationsMsgProducer();
            Set tbCoreServices = this.partitionService.getAllServiceIds(ServiceType.TB_CORE);
            for (String serviceId : tbCoreServices) {
                TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_CORE, serviceId);
                TransportProtos.ToCoreNotificationMsg toCoreMsg = TransportProtos.ToCoreNotificationMsg.newBuilder().setComponentLifecycle(componentLifecycleMsgProto).build();
                toCoreNfProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(msg.getEntityId().getId(), (GeneratedMessageV3)toCoreMsg), null);
                this.toCoreNfs.incrementAndGet();
            }
            tbRuleEngineServices.removeAll(tbCoreServices);
        }
        for (String serviceId : tbRuleEngineServices) {
            TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_RULE_ENGINE, serviceId);
            TransportProtos.ToRuleEngineNotificationMsg toRuleEngineMsg = TransportProtos.ToRuleEngineNotificationMsg.newBuilder().setComponentLifecycle(componentLifecycleMsgProto).build();
            toRuleEngineProducer.send(tpi, (TbQueueMsg)new TbProtoQueueMsg(msg.getEntityId().getId(), (GeneratedMessageV3)toRuleEngineMsg), null);
            this.toRuleEngineNfs.incrementAndGet();
        }
    }

    @Scheduled(fixedDelayString="${cluster.stats.print_interval_ms}")
    public void printStats() {
        if (this.statsEnabled) {
            int toCoreMsgCnt = this.toCoreMsgs.getAndSet(0);
            int toCoreNfsCnt = this.toCoreNfs.getAndSet(0);
            int toRuleEngineMsgsCnt = this.toRuleEngineMsgs.getAndSet(0);
            int toRuleEngineNfsCnt = this.toRuleEngineNfs.getAndSet(0);
            int toTransportNfsCnt = this.toTransportNfs.getAndSet(0);
            int toEdgeMsgCnt = this.toEdgeMsgs.getAndSet(0);
            int toEdgeNfsCnt = this.toEdgeNfs.getAndSet(0);
            if (toCoreMsgCnt > 0 || toCoreNfsCnt > 0 || toRuleEngineMsgsCnt > 0 || toRuleEngineNfsCnt > 0 || toTransportNfsCnt > 0 || toEdgeMsgCnt > 0 || toEdgeNfsCnt > 0) {
                log.info("To TbCore: [{}] messages [{}] notifications; To TbRuleEngine: [{}] messages [{}] notifications; To Transport: [{}] notifications;To Edge: [{}] messages [{}] notifications", new Object[]{toCoreMsgCnt, toCoreNfsCnt, toRuleEngineMsgsCnt, toRuleEngineNfsCnt, toTransportNfsCnt, toEdgeMsgCnt, toEdgeNfsCnt});
            }
        }
    }

    private void sendDeviceStateServiceEvent(TenantId tenantId, DeviceId deviceId, boolean added, boolean updated, boolean deleted) {
        TransportProtos.DeviceStateServiceMsgProto.Builder builder = TransportProtos.DeviceStateServiceMsgProto.newBuilder();
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        builder.setDeviceIdMSB(deviceId.getId().getMostSignificantBits());
        builder.setDeviceIdLSB(deviceId.getId().getLeastSignificantBits());
        builder.setAdded(added);
        builder.setUpdated(updated);
        builder.setDeleted(deleted);
        TransportProtos.DeviceStateServiceMsgProto msg = builder.build();
        this.pushMsgToCore(tenantId, (EntityId)deviceId, TransportProtos.ToCoreMsg.newBuilder().setDeviceStateServiceMsg(msg).build(), null);
    }

    public void onDeviceUpdated(Device entity, Device old) {
        boolean created = old == null;
        this.broadcastEntityChangeToTransport(entity.getTenantId(), (EntityId)entity.getId(), entity, null);
        ComponentLifecycleMsg.ComponentLifecycleMsgBuilder msg = ComponentLifecycleMsg.builder().tenantId(entity.getTenantId()).entityId((EntityId)entity.getId()).profileId((EntityId)entity.getDeviceProfileId()).name(entity.getName());
        if (created) {
            msg.event(ComponentLifecycleEvent.CREATED);
        } else {
            boolean deviceProfileChanged;
            boolean deviceNameChanged;
            boolean bl = deviceNameChanged = !entity.getName().equals(old.getName());
            if (deviceNameChanged) {
                this.gatewayNotificationsService.onDeviceUpdated(entity, old);
            }
            boolean bl2 = deviceProfileChanged = !entity.getDeviceProfileId().equals((Object)old.getDeviceProfileId());
            if (deviceNameChanged || deviceProfileChanged) {
                this.pushMsgToCore((ToDeviceActorNotificationMsg)new DeviceNameOrTypeUpdateMsg(entity.getTenantId(), entity.getId(), entity.getName(), entity.getType()), null);
            }
            msg.event(ComponentLifecycleEvent.UPDATED).oldProfileId((EntityId)old.getDeviceProfileId()).oldName(old.getName());
        }
        this.broadcast(msg.build());
        this.sendDeviceStateServiceEvent(entity.getTenantId(), entity.getId(), created, !created, false);
        this.otaPackageStateService.update(entity, old);
    }

    public void onAssetUpdated(Asset entity, Asset old) {
        boolean created = old == null;
        ComponentLifecycleMsg.ComponentLifecycleMsgBuilder msg = ComponentLifecycleMsg.builder().tenantId(entity.getTenantId()).entityId((EntityId)entity.getId()).profileId((EntityId)entity.getAssetProfileId()).name(entity.getName());
        if (created) {
            msg.event(ComponentLifecycleEvent.CREATED);
        } else {
            msg.event(ComponentLifecycleEvent.UPDATED).oldProfileId((EntityId)old.getAssetProfileId()).oldName(old.getName());
        }
        this.broadcast(msg.build());
    }

    public void onCalculatedFieldUpdated(CalculatedField calculatedField, CalculatedField oldCalculatedField, TbQueueCallback callback) {
        this.broadcastEntityStateChangeEvent(calculatedField.getTenantId(), (EntityId)calculatedField.getId(), oldCalculatedField == null ? ComponentLifecycleEvent.CREATED : ComponentLifecycleEvent.UPDATED);
    }

    public void onCalculatedFieldDeleted(CalculatedField calculatedField, TbQueueCallback callback) {
        this.broadcastEntityStateChangeEvent(calculatedField.getTenantId(), (EntityId)calculatedField.getId(), ComponentLifecycleEvent.DELETED);
    }

    public void sendNotificationMsgToEdge(TenantId tenantId, EdgeId edgeId, EntityId entityId, String body, EdgeEventType type, EdgeEventActionType action, EdgeId originatorEdgeId) {
        if (!this.edgesEnabled) {
            return;
        }
        if (type == null) {
            if (entityId == null) {
                log.trace("[{}] entity id and type are null. Ignoring this notification", (Object)tenantId);
                return;
            }
            type = EdgeUtils.getEdgeEventTypeByEntityType((EntityType)entityId.getEntityType());
            if (type == null) {
                log.trace("[{}] edge event type is null. Ignoring this notification [{}]", (Object)tenantId, (Object)entityId);
                return;
            }
        }
        TransportProtos.EdgeNotificationMsgProto.Builder builder = TransportProtos.EdgeNotificationMsgProto.newBuilder();
        builder.setTenantIdMSB(tenantId.getId().getMostSignificantBits());
        builder.setTenantIdLSB(tenantId.getId().getLeastSignificantBits());
        builder.setType(type.name());
        builder.setAction(action.name());
        if (entityId != null) {
            builder.setEntityIdMSB(entityId.getId().getMostSignificantBits());
            builder.setEntityIdLSB(entityId.getId().getLeastSignificantBits());
            builder.setEntityType(entityId.getEntityType().name());
        }
        if (edgeId != null) {
            builder.setEdgeIdMSB(edgeId.getId().getMostSignificantBits());
            builder.setEdgeIdLSB(edgeId.getId().getLeastSignificantBits());
        }
        if (body != null) {
            builder.setBody(body);
        }
        if (originatorEdgeId != null) {
            builder.setOriginatorEdgeIdMSB(originatorEdgeId.getId().getMostSignificantBits());
            builder.setOriginatorEdgeIdLSB(originatorEdgeId.getId().getLeastSignificantBits());
        }
        TransportProtos.EdgeNotificationMsgProto msg = builder.build();
        log.trace("[{}] sending notification to edge service {}", (Object)tenantId.getId(), (Object)msg);
        this.pushMsgToEdge(tenantId, (EntityId)(entityId != null ? entityId : tenantId), TransportProtos.ToEdgeMsg.newBuilder().setEdgeNotificationMsg(msg).build(), null);
        if (entityId != null && EntityType.DEVICE.equals((Object)entityId.getEntityType())) {
            this.pushDeviceUpdateMessage(tenantId, edgeId, entityId, action);
        }
    }

    private void pushDeviceUpdateMessage(TenantId tenantId, EdgeId edgeId, EntityId entityId, EdgeEventActionType action) {
        log.trace("{} Going to send edge update notification for device actor, device id {}, edge id {}", new Object[]{tenantId, entityId, edgeId});
        switch (action) {
            case ASSIGNED_TO_EDGE: {
                this.pushMsgToCore((ToDeviceActorNotificationMsg)new DeviceEdgeUpdateMsg(tenantId, new DeviceId(entityId.getId()), edgeId), null);
                break;
            }
            case UNASSIGNED_FROM_EDGE: {
                EdgeId relatedEdgeId = this.findRelatedEdgeIdIfAny(tenantId, entityId);
                this.pushMsgToCore((ToDeviceActorNotificationMsg)new DeviceEdgeUpdateMsg(tenantId, new DeviceId(entityId.getId()), relatedEdgeId), null);
            }
        }
    }

    private EdgeId findRelatedEdgeIdIfAny(TenantId tenantId, EntityId entityId) {
        PageData pageData = this.edgeService.findRelatedEdgeIdsByEntityId(tenantId, entityId, new PageLink(1));
        return Optional.ofNullable(pageData).filter(pd -> pd.getTotalElements() > 0L).map(pd -> (EdgeId)pd.getData().get(0)).orElse(null);
    }

    public void onQueuesUpdate(List<Queue> queues) {
        List queueUpdateMsgs = queues.stream().map(queue -> TransportProtos.QueueUpdateMsg.newBuilder().setTenantIdMSB(queue.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(queue.getTenantId().getId().getLeastSignificantBits()).setQueueIdMSB(((QueueId)queue.getId()).getId().getMostSignificantBits()).setQueueIdLSB(((QueueId)queue.getId()).getId().getLeastSignificantBits()).setQueueName(queue.getName()).setQueueTopic(queue.getTopic()).setPartitions(queue.getPartitions()).setDuplicateMsgToAllPartitions(queue.isDuplicateMsgToAllPartitions()).build()).collect(Collectors.toList());
        TransportProtos.ToRuleEngineNotificationMsg ruleEngineMsg = TransportProtos.ToRuleEngineNotificationMsg.newBuilder().addAllQueueUpdateMsgs(queueUpdateMsgs).build();
        TransportProtos.ToCoreNotificationMsg coreMsg = TransportProtos.ToCoreNotificationMsg.newBuilder().addAllQueueUpdateMsgs(queueUpdateMsgs).build();
        TransportProtos.ToTransportMsg transportMsg = TransportProtos.ToTransportMsg.newBuilder().addAllQueueUpdateMsgs(queueUpdateMsgs).build();
        this.doSendQueueNotifications(ruleEngineMsg, coreMsg, transportMsg);
    }

    public void onQueuesDelete(List<Queue> queues) {
        List queueDeleteMsgs = queues.stream().map(queue -> TransportProtos.QueueDeleteMsg.newBuilder().setTenantIdMSB(queue.getTenantId().getId().getMostSignificantBits()).setTenantIdLSB(queue.getTenantId().getId().getLeastSignificantBits()).setQueueIdMSB(((QueueId)queue.getId()).getId().getMostSignificantBits()).setQueueIdLSB(((QueueId)queue.getId()).getId().getLeastSignificantBits()).setQueueName(queue.getName()).build()).collect(Collectors.toList());
        TransportProtos.ToRuleEngineNotificationMsg ruleEngineMsg = TransportProtos.ToRuleEngineNotificationMsg.newBuilder().addAllQueueDeleteMsgs(queueDeleteMsgs).build();
        TransportProtos.ToCoreNotificationMsg coreMsg = TransportProtos.ToCoreNotificationMsg.newBuilder().addAllQueueDeleteMsgs(queueDeleteMsgs).build();
        TransportProtos.ToTransportMsg transportMsg = TransportProtos.ToTransportMsg.newBuilder().addAllQueueDeleteMsgs(queueDeleteMsgs).build();
        this.doSendQueueNotifications(ruleEngineMsg, coreMsg, transportMsg);
    }

    private void doSendQueueNotifications(TransportProtos.ToRuleEngineNotificationMsg ruleEngineMsg, TransportProtos.ToCoreNotificationMsg coreMsg, TransportProtos.ToTransportMsg transportMsg) {
        TopicPartitionInfo tpi;
        Set tbRuleEngineServices = this.partitionService.getAllServiceIds(ServiceType.TB_RULE_ENGINE);
        Set tbCoreServices = this.partitionService.getAllServiceIds(ServiceType.TB_CORE);
        Set tbTransportServices = this.partitionService.getAllServiceIds(ServiceType.TB_TRANSPORT);
        tbTransportServices.removeAll(tbCoreServices);
        tbCoreServices.removeAll(tbRuleEngineServices);
        for (String ruleEngineServiceId : tbRuleEngineServices) {
            tpi = this.topicService.getNotificationsTopic(ServiceType.TB_RULE_ENGINE, ruleEngineServiceId);
            this.producerProvider.getRuleEngineNotificationsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)ruleEngineMsg), null);
            this.toRuleEngineNfs.incrementAndGet();
        }
        for (String coreServiceId : tbCoreServices) {
            tpi = this.topicService.getNotificationsTopic(ServiceType.TB_CORE, coreServiceId);
            this.producerProvider.getTbCoreNotificationsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)coreMsg), null);
            this.toCoreNfs.incrementAndGet();
        }
        for (String transportServiceId : tbTransportServices) {
            tpi = this.topicService.getNotificationsTopic(ServiceType.TB_TRANSPORT, transportServiceId);
            this.producerProvider.getTransportNotificationsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)transportMsg), null);
            this.toTransportNfs.incrementAndGet();
        }
    }

    @ConstructorProperties(value={"topicService", "deviceProfileCache", "assetProfileCache", "gatewayNotificationsService", "edgeService", "edgeIdServiceIdCache"})
    @Generated
    public DefaultTbClusterService(TopicService topicService, TbDeviceProfileCache deviceProfileCache, TbAssetProfileCache assetProfileCache, GatewayNotificationsService gatewayNotificationsService, EdgeService edgeService, TbTransactionalCache<EdgeId, String> edgeIdServiceIdCache) {
        this.topicService = topicService;
        this.deviceProfileCache = deviceProfileCache;
        this.assetProfileCache = assetProfileCache;
        this.gatewayNotificationsService = gatewayNotificationsService;
        this.edgeService = edgeService;
        this.edgeIdServiceIdCache = edgeIdServiceIdCache;
    }
}

