/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.rule.trigger;

import java.beans.ConstructorProperties;
import java.util.Collection;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.notification.info.ApiUsageLimitNotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.rule.trigger.ApiUsageLimitTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.config.ApiUsageLimitNotificationRuleTriggerConfig;
import org.thingsboard.server.common.data.notification.rule.trigger.config.NotificationRuleTriggerType;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.service.notification.rule.trigger.NotificationRuleTriggerProcessor;

@Service
public class ApiUsageLimitTriggerProcessor
implements NotificationRuleTriggerProcessor<ApiUsageLimitTrigger, ApiUsageLimitNotificationRuleTriggerConfig> {
    private final TenantService tenantService;

    @Override
    public boolean matchesFilter(ApiUsageLimitTrigger trigger, ApiUsageLimitNotificationRuleTriggerConfig triggerConfig) {
        return CollectionsUtil.emptyOrContains((Collection)triggerConfig.getApiFeatures(), (Object)trigger.getState().getApiFeature()) && CollectionsUtil.emptyOrContains((Collection)triggerConfig.getNotifyOn(), (Object)trigger.getStatus());
    }

    @Override
    public RuleOriginatedNotificationInfo constructNotificationInfo(ApiUsageLimitTrigger trigger) {
        return ApiUsageLimitNotificationInfo.builder().feature(trigger.getState().getApiFeature()).recordKey(trigger.getState().getKey()).status(trigger.getStatus()).limit(trigger.getState().getThresholdAsString()).currentValue(trigger.getState().getValueAsString()).tenantId(trigger.getTenantId()).tenantName(this.tenantService.findTenantById(trigger.getTenantId()).getName()).build();
    }

    @Override
    public NotificationRuleTriggerType getTriggerType() {
        return NotificationRuleTriggerType.API_USAGE_LIMIT;
    }

    @ConstructorProperties(value={"tenantService"})
    @Generated
    public ApiUsageLimitTriggerProcessor(TenantService tenantService) {
        this.tenantService = tenantService;
    }
}

