/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification.provider;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.slack.api.Slack;
import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiRequest;
import com.slack.api.methods.SlackApiTextResponse;
import com.slack.api.methods.SlackFilesUploadV2Exception;
import com.slack.api.methods.request.chat.ChatPostMessageRequest;
import com.slack.api.methods.request.conversations.ConversationsListRequest;
import com.slack.api.methods.request.conversations.ConversationsOpenRequest;
import com.slack.api.methods.request.files.FilesUploadV2Request;
import com.slack.api.methods.request.users.UsersListRequest;
import com.slack.api.methods.response.conversations.ConversationsListResponse;
import com.slack.api.methods.response.conversations.ConversationsOpenResponse;
import com.slack.api.methods.response.users.UsersListResponse;
import com.slack.api.model.ConversationType;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.notification.SlackService;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.settings.SlackNotificationDeliveryMethodConfig;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversation;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversationType;
import org.thingsboard.server.common.data.notification.targets.slack.SlackFile;
import org.thingsboard.server.common.data.util.CollectionsUtil;
import org.thingsboard.server.common.data.util.ThrowingBiFunction;
import org.thingsboard.server.dao.notification.NotificationSettingsService;

@Service
public class DefaultSlackService
implements SlackService {
    private final NotificationSettingsService notificationSettingsService;
    private final Slack slack = Slack.getInstance();
    private final Cache<String, List<SlackConversation>> cache = Caffeine.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).maximumSize(100L).build();
    private static final int CONVERSATIONS_LOAD_LIMIT = 1000;

    public void sendMessage(TenantId tenantId, String token, String conversationId, String message) {
        this.sendMessage(tenantId, token, conversationId, message, null);
    }

    public void sendMessage(TenantId tenantId, String token, String conversationId, String message, List<SlackFile> files) {
        if (CollectionsUtil.isNotEmpty(files)) {
            if (conversationId.startsWith("U")) {
                conversationId = ((ConversationsOpenResponse)this.sendRequest(token, ConversationsOpenRequest.builder().users(List.of(conversationId)).build(), MethodsClient::conversationsOpen)).getChannel().getId();
            }
            FilesUploadV2Request request = FilesUploadV2Request.builder().initialComment(message).channel(conversationId).uploadFiles(files.stream().map(file -> FilesUploadV2Request.UploadFile.builder().filename(file.getName()).title(file.getName()).fileData(file.getData()).build()).toList()).build();
            this.sendRequest(token, request, MethodsClient::filesUploadV2);
        } else {
            ChatPostMessageRequest request = ChatPostMessageRequest.builder().channel(conversationId).text(message).build();
            this.sendRequest(token, request, MethodsClient::chatPostMessage);
        }
    }

    public List<SlackConversation> listConversations(TenantId tenantId, String token, SlackConversationType conversationType) {
        return (List)this.cache.get((Object)(String.valueOf(conversationType) + ":" + token), k -> {
            if (conversationType == SlackConversationType.DIRECT) {
                UsersListRequest request = UsersListRequest.builder().limit(Integer.valueOf(1000)).build();
                UsersListResponse response = (UsersListResponse)this.sendRequest(token, request, MethodsClient::usersList);
                return response.getMembers().stream().filter(user -> !user.isDeleted() && !user.isStranger() && !user.isBot()).map(user -> {
                    SlackConversation conversation = new SlackConversation();
                    conversation.setType(conversationType);
                    conversation.setId(user.getId());
                    conversation.setName(user.getName());
                    conversation.setWholeName(user.getProfile() != null ? user.getProfile().getRealNameNormalized() : user.getRealName());
                    conversation.setEmail(user.getProfile() != null ? user.getProfile().getEmail() : null);
                    return conversation;
                }).collect(Collectors.toList());
            }
            ConversationsListRequest request = ConversationsListRequest.builder().types(List.of(conversationType == SlackConversationType.PUBLIC_CHANNEL ? ConversationType.PUBLIC_CHANNEL : ConversationType.PRIVATE_CHANNEL)).limit(Integer.valueOf(1000)).excludeArchived(true).build();
            ConversationsListResponse response = (ConversationsListResponse)this.sendRequest(token, request, MethodsClient::conversationsList);
            return response.getChannels().stream().filter(channel -> !channel.isArchived()).map(channel -> {
                SlackConversation conversation = new SlackConversation();
                conversation.setType(conversationType);
                conversation.setId(channel.getId());
                conversation.setName(channel.getName());
                conversation.setWholeName(channel.getNameNormalized());
                return conversation;
            }).collect(Collectors.toList());
        });
    }

    public String getToken(TenantId tenantId) {
        NotificationSettings settings = this.notificationSettingsService.findNotificationSettings(tenantId);
        SlackNotificationDeliveryMethodConfig slackConfig = (SlackNotificationDeliveryMethodConfig)settings.getDeliveryMethodsConfigs().get(NotificationDeliveryMethod.SLACK);
        if (slackConfig != null) {
            return slackConfig.getBotToken();
        }
        return null;
    }

    private <T extends SlackApiRequest, R extends SlackApiTextResponse> R sendRequest(String token, T request, ThrowingBiFunction<MethodsClient, T, R> method) {
        SlackApiTextResponse response;
        MethodsClient client = this.slack.methods(token);
        try {
            response = (SlackApiTextResponse)method.apply((Object)client, request);
        }
        catch (SlackFilesUploadV2Exception e) {
            if (e.getGetURLResponses() != null) {
                e.getGetURLResponses().forEach(this::checkResponse);
            }
            if (e.getCompleteResponse() != null) {
                this.checkResponse((SlackApiTextResponse)e.getCompleteResponse());
            }
            if (e.getFileInfoResponses() != null) {
                e.getFileInfoResponses().forEach(this::checkResponse);
            }
            throw new RuntimeException("Failed to upload Slack file: " + e.toString(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.checkResponse(response);
        return (R)response;
    }

    private void checkResponse(SlackApiTextResponse response) {
        if (response.isOk()) {
            return;
        }
        Object error = response.getError();
        if (error != null) {
            switch (error) {
                case "missing_scope": {
                    String neededScope = response.getNeeded();
                    error = "bot token scope '" + neededScope + "' is needed";
                    break;
                }
                case "not_in_channel": {
                    error = "app needs to be added to the channel";
                    break;
                }
                default: {
                    error = null;
                }
            }
        }
        if (error == null) {
            ObjectNode responseJson = (ObjectNode)JacksonUtil.valueToTree((Object)response);
            responseJson.remove("httpResponseHeaders");
            error = responseJson.toString();
        }
        throw new RuntimeException("Slack API error: " + (String)error);
    }

    @ConstructorProperties(value={"notificationSettingsService"})
    @Generated
    public DefaultSlackService(NotificationSettingsService notificationSettingsService) {
        this.notificationSettingsService = notificationSettingsService;
    }
}

