/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.notification;

import com.google.common.util.concurrent.FutureCallback;
import com.google.protobuf.GeneratedMessageV3;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.server.cache.limits.RateLimitService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.NotificationId;
import org.thingsboard.server.common.data.id.NotificationRequestId;
import org.thingsboard.server.common.data.id.NotificationRuleId;
import org.thingsboard.server.common.data.id.NotificationTargetId;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.limit.LimitedApi;
import org.thingsboard.server.common.data.notification.AlreadySentException;
import org.thingsboard.server.common.data.notification.Notification;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationRequest;
import org.thingsboard.server.common.data.notification.NotificationRequestConfig;
import org.thingsboard.server.common.data.notification.NotificationRequestStats;
import org.thingsboard.server.common.data.notification.NotificationRequestStatus;
import org.thingsboard.server.common.data.notification.NotificationStatus;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.info.GeneralNotificationInfo;
import org.thingsboard.server.common.data.notification.info.NotificationInfo;
import org.thingsboard.server.common.data.notification.info.RuleOriginatedNotificationInfo;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.settings.UserNotificationSettings;
import org.thingsboard.server.common.data.notification.targets.MicrosoftTeamsNotificationTargetConfig;
import org.thingsboard.server.common.data.notification.targets.NotificationRecipient;
import org.thingsboard.server.common.data.notification.targets.NotificationTarget;
import org.thingsboard.server.common.data.notification.targets.NotificationTargetConfig;
import org.thingsboard.server.common.data.notification.targets.NotificationTargetType;
import org.thingsboard.server.common.data.notification.targets.platform.PlatformUsersNotificationTargetConfig;
import org.thingsboard.server.common.data.notification.targets.platform.UsersFilter;
import org.thingsboard.server.common.data.notification.targets.slack.SlackNotificationTargetConfig;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;
import org.thingsboard.server.common.data.notification.template.WebDeliveryMethodNotificationTemplate;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.msg.tools.TbRateLimitsException;
import org.thingsboard.server.dao.notification.NotificationRequestService;
import org.thingsboard.server.dao.notification.NotificationService;
import org.thingsboard.server.dao.notification.NotificationSettingsService;
import org.thingsboard.server.dao.notification.NotificationTargetService;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.service.executors.NotificationExecutorService;
import org.thingsboard.server.service.notification.NotificationProcessingContext;
import org.thingsboard.server.service.notification.channels.NotificationChannel;
import org.thingsboard.server.service.subscription.TbSubscriptionUtils;
import org.thingsboard.server.service.telemetry.AbstractSubscriptionService;
import org.thingsboard.server.service.ws.notification.sub.NotificationRequestUpdate;
import org.thingsboard.server.service.ws.notification.sub.NotificationUpdate;

@Service
public class DefaultNotificationCenter
extends AbstractSubscriptionService
implements NotificationCenter,
NotificationChannel<User, WebDeliveryMethodNotificationTemplate> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationCenter.class);
    private final NotificationTargetService notificationTargetService;
    private final NotificationRequestService notificationRequestService;
    private final NotificationService notificationService;
    private final NotificationTemplateService notificationTemplateService;
    private final NotificationSettingsService notificationSettingsService;
    private final NotificationExecutorService notificationExecutor;
    private final TopicService topicService;
    private final TbQueueProducerProvider producerProvider;
    private final RateLimitService rateLimitService;
    private Map<NotificationDeliveryMethod, NotificationChannel> channels;

    public NotificationRequest processNotificationRequest(TenantId tenantId, NotificationRequest request, FutureCallback<NotificationRequestStats> callback) {
        NotificationRequestConfig config;
        if (request.getRuleId() == null && !this.rateLimitService.checkRateLimit(LimitedApi.NOTIFICATION_REQUESTS, tenantId)) {
            throw new TbRateLimitsException(EntityType.TENANT);
        }
        NotificationTemplate notificationTemplate = request.getTemplateId() != null ? this.notificationTemplateService.findNotificationTemplateById(tenantId, request.getTemplateId()) : request.getTemplate();
        if (notificationTemplate == null) {
            throw new IllegalArgumentException("Template is missing");
        }
        NotificationType notificationType = notificationTemplate.getNotificationType();
        HashSet<NotificationDeliveryMethod> deliveryMethods = new HashSet<NotificationDeliveryMethod>();
        ArrayList<NotificationTarget> targets = new ArrayList<NotificationTarget>();
        for (UUID targetId : request.getTargets()) {
            NotificationTarget target = this.notificationTargetService.findNotificationTargetById(tenantId, new NotificationTargetId(targetId));
            if (target != null) {
                targets.add(target);
                continue;
            }
            log.debug("Unknown notification target {} in request {}", (Object)targetId, (Object)request);
        }
        if (targets.isEmpty()) {
            throw new IllegalArgumentException("No recipients chosen");
        }
        NotificationRuleId ruleId = request.getRuleId();
        notificationTemplate.getConfiguration().getDeliveryMethodsTemplates().forEach((deliveryMethod, template) -> {
            if (!template.isEnabled()) {
                return;
            }
            try {
                this.channels.get(deliveryMethod).check(tenantId);
            }
            catch (Exception e) {
                if (ruleId == null && !notificationType.isSystem()) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                return;
            }
            if (ruleId == null && !notificationType.isSystem() && targets.stream().noneMatch(target -> target.getConfiguration().getType().getSupportedDeliveryMethods().contains(deliveryMethod))) {
                throw new IllegalArgumentException("Recipients for " + deliveryMethod.getName() + " delivery method not chosen");
            }
            deliveryMethods.add((NotificationDeliveryMethod)deliveryMethod);
        });
        if (deliveryMethods.isEmpty()) {
            throw new IllegalArgumentException("No delivery methods to send notification with");
        }
        if (request.getAdditionalConfig() != null && (config = request.getAdditionalConfig()).getSendingDelayInSec() > 0 && request.getId() == null) {
            request.setStatus(NotificationRequestStatus.SCHEDULED);
            request = this.notificationRequestService.saveNotificationRequest(tenantId, request);
            this.forwardToNotificationSchedulerService(tenantId, (NotificationRequestId)request.getId());
            return request;
        }
        NotificationSettings settings = this.notificationSettingsService.findNotificationSettings(tenantId);
        NotificationSettings systemSettings = tenantId.isSysTenantId() ? settings : this.notificationSettingsService.findNotificationSettings(TenantId.SYS_TENANT_ID);
        log.debug("Processing notification request (tenantId: {}, targets: {})", (Object)tenantId, (Object)request.getTargets());
        request.setStatus(NotificationRequestStatus.PROCESSING);
        request = this.notificationRequestService.saveNotificationRequest(tenantId, request);
        NotificationProcessingContext ctx = NotificationProcessingContext.builder().tenantId(tenantId).request(request).deliveryMethods(deliveryMethods).template(notificationTemplate).settings(settings).systemSettings(systemSettings).build();
        this.processNotificationRequestAsync(ctx, targets, callback);
        return request;
    }

    public void sendGeneralWebNotification(TenantId tenantId, UsersFilter recipients, NotificationTemplate template, GeneralNotificationInfo info) {
        NotificationTarget target = new NotificationTarget();
        target.setTenantId(tenantId);
        PlatformUsersNotificationTargetConfig targetConfig = new PlatformUsersNotificationTargetConfig();
        targetConfig.setUsersFilter(recipients);
        target.setConfiguration((NotificationTargetConfig)targetConfig);
        NotificationRequest notificationRequest = NotificationRequest.builder().tenantId(tenantId).template(template).targets(List.of(EntityId.NULL_UUID)).info((NotificationInfo)info).status(NotificationRequestStatus.PROCESSING).build();
        try {
            notificationRequest = this.notificationRequestService.saveNotificationRequest(tenantId, notificationRequest);
            NotificationProcessingContext ctx = NotificationProcessingContext.builder().tenantId(tenantId).request(notificationRequest).deliveryMethods(Set.of(NotificationDeliveryMethod.WEB)).template(template).build();
            this.processNotificationRequestAsync(ctx, List.of(target), null);
        }
        catch (Exception e) {
            log.error("Failed to process notification request for recipients {} for template '{}'", new Object[]{recipients, template.getName(), e});
        }
    }

    public void sendSystemNotification(TenantId tenantId, NotificationTargetId targetId, NotificationType type, NotificationInfo info) {
        log.debug("[{}] Sending {} system notification to {}: {}", new Object[]{tenantId, type, targetId, info});
        NotificationTemplate notificationTemplate = (NotificationTemplate)this.notificationTemplateService.findTenantOrSystemNotificationTemplate(tenantId, type).orElseThrow(() -> new IllegalArgumentException("No notification template found for type " + String.valueOf(type)));
        NotificationRequest notificationRequest = NotificationRequest.builder().tenantId(tenantId).targets(List.of(targetId.getId())).templateId((NotificationTemplateId)notificationTemplate.getId()).info(info).originatorEntityId((EntityId)TenantId.SYS_TENANT_ID).build();
        this.processNotificationRequest(tenantId, notificationRequest, null);
    }

    private void processNotificationRequestAsync(NotificationProcessingContext ctx, List<NotificationTarget> targets, FutureCallback<NotificationRequestStats> callback) {
        this.notificationExecutor.submit(() -> {
            long startTs = System.currentTimeMillis();
            NotificationRequestId requestId = (NotificationRequestId)ctx.getRequest().getId();
            for (NotificationTarget target : targets) {
                try {
                    this.processForTarget(target, ctx);
                }
                catch (Exception e) {
                    log.error("[{}] Failed to process notification request for target {}", new Object[]{requestId, target.getId(), e});
                    ctx.getStats().setError(e.getMessage());
                    this.updateRequestStats(ctx, requestId, ctx.getStats());
                    if (callback != null) {
                        callback.onFailure((Throwable)e);
                    }
                    return;
                }
            }
            NotificationRequestStats stats = ctx.getStats();
            long time = System.currentTimeMillis() - startTs;
            int sent = stats.getTotalSent().get();
            int errors = stats.getTotalErrors().get();
            if (errors > 0) {
                log.debug("[{}][{}] Notification request processing finished in {} ms (sent: {}, errors: {})", new Object[]{ctx.getTenantId(), requestId, time, sent, errors});
            } else {
                log.debug("[{}][{}] Notification request processing finished in {} ms (sent: {})", new Object[]{ctx.getTenantId(), requestId, time, sent});
            }
            this.updateRequestStats(ctx, requestId, stats);
            if (callback != null) {
                callback.onSuccess((Object)stats);
            }
        });
    }

    private void updateRequestStats(NotificationProcessingContext ctx, NotificationRequestId requestId, NotificationRequestStats stats) {
        try {
            this.notificationRequestService.updateNotificationRequest(ctx.getTenantId(), requestId, NotificationRequestStatus.SENT, stats);
        }
        catch (Exception e) {
            log.error("[{}] Failed to update stats for notification request", (Object)requestId, (Object)e);
        }
    }

    private void processForTarget(NotificationTarget target, NotificationProcessingContext ctx) {
        PageDataIterable recipients = switch (target.getConfiguration().getType()) {
            case NotificationTargetType.PLATFORM_USERS -> {
                PlatformUsersNotificationTargetConfig targetConfig = (PlatformUsersNotificationTargetConfig)target.getConfiguration();
                if (targetConfig.getUsersFilter().getType().isForRules() && ctx.getRequest().getInfo() instanceof RuleOriginatedNotificationInfo) {
                    yield new PageDataIterable(pageLink -> this.notificationTargetService.findRecipientsForRuleNotificationTargetConfig(ctx.getTenantId(), targetConfig, (RuleOriginatedNotificationInfo)ctx.getRequest().getInfo(), pageLink), 256);
                }
                yield new PageDataIterable(pageLink -> this.notificationTargetService.findRecipientsForNotificationTargetConfig(target.getTenantId(), targetConfig, pageLink), 256);
            }
            case NotificationTargetType.SLACK -> {
                PlatformUsersNotificationTargetConfig targetConfig = (SlackNotificationTargetConfig)target.getConfiguration();
                yield List.of(targetConfig.getConversation());
            }
            case NotificationTargetType.MICROSOFT_TEAMS -> {
                PlatformUsersNotificationTargetConfig targetConfig = (MicrosoftTeamsNotificationTargetConfig)target.getConfiguration();
                yield List.of(targetConfig);
            }
            default -> Collections.emptyList();
        };
        HashSet<NotificationDeliveryMethod> deliveryMethods = new HashSet<NotificationDeliveryMethod>(ctx.getDeliveryMethods());
        deliveryMethods.removeIf(deliveryMethod -> !target.getConfiguration().getType().getSupportedDeliveryMethods().contains(deliveryMethod));
        log.debug("[{}] Processing notification request for {} target ({}) for delivery methods {}", new Object[]{ctx.getRequest().getId(), target.getConfiguration().getType(), target.getId(), deliveryMethods});
        if (deliveryMethods.isEmpty()) {
            return;
        }
        for (NotificationRecipient recipient : recipients) {
            for (NotificationDeliveryMethod deliveryMethod2 : deliveryMethods) {
                try {
                    this.processForRecipient(deliveryMethod2, recipient, ctx);
                    ctx.getStats().reportSent(deliveryMethod2, recipient);
                }
                catch (Exception error) {
                    ctx.getStats().reportError(deliveryMethod2, (Throwable)error, recipient);
                }
            }
        }
    }

    private void processForRecipient(NotificationDeliveryMethod deliveryMethod, NotificationRecipient recipient, NotificationProcessingContext ctx) throws Exception {
        UserNotificationSettings settings;
        if (ctx.getStats().contains(deliveryMethod, recipient.getId())) {
            throw new AlreadySentException();
        }
        ctx.getStats().reportProcessed(deliveryMethod, recipient.getId());
        if (recipient instanceof User && !(settings = this.notificationSettingsService.getUserNotificationSettings(ctx.getTenantId(), ((User)recipient).getId(), false)).isEnabled(ctx.getNotificationType(), deliveryMethod)) {
            throw new RuntimeException("User disabled " + deliveryMethod.getName() + " notifications of this type");
        }
        NotificationChannel notificationChannel = this.channels.get(deliveryMethod);
        Object processedTemplate = ctx.getProcessedTemplate(deliveryMethod, recipient);
        log.trace("[{}] Sending {} notification for recipient {}", new Object[]{ctx.getRequest().getId(), deliveryMethod, recipient});
        notificationChannel.sendNotification(recipient, processedTemplate, ctx);
    }

    @Override
    public void sendNotification(User recipient, WebDeliveryMethodNotificationTemplate processedTemplate, NotificationProcessingContext ctx) throws Exception {
        NotificationRequest request = ctx.getRequest();
        Notification notification = Notification.builder().requestId((NotificationRequestId)request.getId()).recipientId(recipient.getId()).type(ctx.getNotificationType()).deliveryMethod(NotificationDeliveryMethod.WEB).subject(processedTemplate.getSubject()).text(processedTemplate.getBody()).additionalConfig(processedTemplate.getAdditionalConfig()).info(request.getInfo()).status(NotificationStatus.SENT).build();
        try {
            notification = this.notificationService.saveNotification(recipient.getTenantId(), notification);
        }
        catch (Exception e) {
            log.error("Failed to create notification for recipient {}", (Object)recipient.getId(), (Object)e);
            throw e;
        }
        NotificationUpdate update = NotificationUpdate.builder().created(true).notification(notification).build();
        this.onNotificationUpdate(recipient.getTenantId(), recipient.getId(), update);
    }

    public void markNotificationAsRead(TenantId tenantId, UserId recipientId, NotificationId notificationId) {
        boolean updated = this.notificationService.markNotificationAsRead(tenantId, recipientId, notificationId);
        if (updated) {
            log.trace("Marked notification {} as read (recipient id: {}, tenant id: {})", new Object[]{notificationId, recipientId, tenantId});
            Notification notification = this.notificationService.findNotificationById(tenantId, notificationId);
            if (notification.getDeliveryMethod() == NotificationDeliveryMethod.WEB) {
                NotificationUpdate update = NotificationUpdate.builder().updated(true).notificationId(notificationId.getId()).notificationType(notification.getType()).newStatus(NotificationStatus.READ).build();
                this.onNotificationUpdate(tenantId, recipientId, update);
            }
        }
    }

    public void markAllNotificationsAsRead(TenantId tenantId, NotificationDeliveryMethod deliveryMethod, UserId recipientId) {
        int updatedCount = this.notificationService.markAllNotificationsAsRead(tenantId, deliveryMethod, recipientId);
        if (updatedCount > 0 && deliveryMethod == NotificationDeliveryMethod.WEB) {
            log.trace("Marked all notifications as read (recipient id: {}, tenant id: {})", (Object)recipientId, (Object)tenantId);
            NotificationUpdate update = NotificationUpdate.builder().updated(true).allNotifications(true).newStatus(NotificationStatus.READ).build();
            this.onNotificationUpdate(tenantId, recipientId, update);
        }
    }

    public void deleteNotification(TenantId tenantId, UserId recipientId, NotificationId notificationId) {
        Notification notification = this.notificationService.findNotificationById(tenantId, notificationId);
        boolean deleted = this.notificationService.deleteNotification(tenantId, recipientId, notificationId);
        if (deleted && notification.getDeliveryMethod() == NotificationDeliveryMethod.WEB) {
            NotificationUpdate update = NotificationUpdate.builder().deleted(true).notification(notification).build();
            this.onNotificationUpdate(tenantId, recipientId, update);
        }
    }

    public List<NotificationDeliveryMethod> getAvailableDeliveryMethods(TenantId tenantId) {
        return this.channels.values().stream().filter(channel -> {
            try {
                channel.check(tenantId);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).map(NotificationChannel::getDeliveryMethod).sorted().toList();
    }

    @Override
    public void check(TenantId tenantId) throws Exception {
    }

    public void deleteNotificationRequest(TenantId tenantId, NotificationRequestId notificationRequestId) {
        log.debug("Deleting notification request {}", (Object)notificationRequestId);
        NotificationRequest notificationRequest = this.notificationRequestService.findNotificationRequestById(tenantId, notificationRequestId);
        this.notificationRequestService.deleteNotificationRequest(tenantId, notificationRequest);
        if (notificationRequest.isSent()) {
            this.onNotificationRequestUpdate(tenantId, NotificationRequestUpdate.builder().notificationRequestId(notificationRequestId).deleted(true).build());
        }
    }

    private void forwardToNotificationSchedulerService(TenantId tenantId, NotificationRequestId notificationRequestId) {
        TransportProtos.NotificationSchedulerServiceMsg.Builder msg = TransportProtos.NotificationSchedulerServiceMsg.newBuilder().setTenantIdMSB(tenantId.getId().getMostSignificantBits()).setTenantIdLSB(tenantId.getId().getLeastSignificantBits()).setRequestIdMSB(notificationRequestId.getId().getMostSignificantBits()).setRequestIdLSB(notificationRequestId.getId().getLeastSignificantBits()).setTs(System.currentTimeMillis());
        TransportProtos.ToCoreMsg toCoreMsg = TransportProtos.ToCoreMsg.newBuilder().setNotificationSchedulerServiceMsg(msg).build();
        this.clusterService.pushMsgToCore(tenantId, (EntityId)notificationRequestId, toCoreMsg, null);
    }

    private void onNotificationUpdate(TenantId tenantId, UserId recipientId, NotificationUpdate update) {
        log.trace("Submitting notification update for recipient {}: {}", (Object)recipientId, (Object)update);
        this.forwardToSubscriptionManagerService(tenantId, (EntityId)recipientId, subscriptionManagerService -> subscriptionManagerService.onNotificationUpdate(tenantId, recipientId, update, TbCallback.EMPTY), () -> TbSubscriptionUtils.notificationUpdateToProto(tenantId, recipientId, update));
    }

    private void onNotificationRequestUpdate(TenantId tenantId, NotificationRequestUpdate update) {
        log.trace("Submitting notification request update: {}", (Object)update);
        this.wsCallBackExecutor.submit(() -> {
            TransportProtos.ToCoreNotificationMsg notificationRequestUpdateProto = TbSubscriptionUtils.notificationRequestUpdateToProto(tenantId, update);
            HashSet coreServices = new HashSet(this.partitionService.getAllServiceIds(ServiceType.TB_CORE));
            for (String serviceId : coreServices) {
                TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_CORE, serviceId);
                this.producerProvider.getTbCoreNotificationsMsgProducer().send(tpi, (TbQueueMsg)new TbProtoQueueMsg(UUID.randomUUID(), (GeneratedMessageV3)notificationRequestUpdateProto), null);
            }
        });
    }

    @Override
    public NotificationDeliveryMethod getDeliveryMethod() {
        return NotificationDeliveryMethod.WEB;
    }

    @Override
    protected String getExecutorPrefix() {
        return "notification";
    }

    @Autowired
    public void setChannels(List<NotificationChannel> channels, NotificationCenter webNotificationChannel) {
        this.channels = channels.stream().collect(Collectors.toMap(NotificationChannel::getDeliveryMethod, c -> c));
        this.channels.put(NotificationDeliveryMethod.WEB, (NotificationChannel)webNotificationChannel);
    }

    @ConstructorProperties(value={"notificationTargetService", "notificationRequestService", "notificationService", "notificationTemplateService", "notificationSettingsService", "notificationExecutor", "topicService", "producerProvider", "rateLimitService"})
    @Generated
    public DefaultNotificationCenter(NotificationTargetService notificationTargetService, NotificationRequestService notificationRequestService, NotificationService notificationService, NotificationTemplateService notificationTemplateService, NotificationSettingsService notificationSettingsService, NotificationExecutorService notificationExecutor, TopicService topicService, TbQueueProducerProvider producerProvider, RateLimitService rateLimitService) {
        this.notificationTargetService = notificationTargetService;
        this.notificationRequestService = notificationRequestService;
        this.notificationService = notificationService;
        this.notificationTemplateService = notificationTemplateService;
        this.notificationSettingsService = notificationSettingsService;
        this.notificationExecutor = notificationExecutor;
        this.topicService = topicService;
        this.producerProvider = producerProvider;
        this.rateLimitService = rateLimitService;
    }
}

