/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.mail;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.mail.MailOauth2Provider;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.queue.util.TbCoreComponent;

@TbCoreComponent
@Service
public class RefreshTokenExpCheckService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RefreshTokenExpCheckService.class);
    public static final int AZURE_DEFAULT_REFRESH_TOKEN_LIFETIME_IN_DAYS = 90;
    private final AdminSettingsService adminSettingsService;

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${mail.oauth2.refreshTokenCheckingInterval})}", fixedDelayString="${mail.oauth2.refreshTokenCheckingInterval}", timeUnit=TimeUnit.SECONDS)
    public void check() throws IOException {
        AdminSettings settings = this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, "mail");
        if (settings != null && settings.getJsonValue().has("enableOauth2") && settings.getJsonValue().get("enableOauth2").asBoolean()) {
            JsonNode jsonValue = settings.getJsonValue();
            if (MailOauth2Provider.OFFICE_365.name().equals(jsonValue.get("providerId").asText()) && jsonValue.has("refreshToken") && jsonValue.has("refreshTokenExpires")) {
                try {
                    long expiresIn = jsonValue.get("refreshTokenExpires").longValue();
                    long tokenLifeDuration = expiresIn - System.currentTimeMillis();
                    if (tokenLifeDuration < 0L) {
                        ((ObjectNode)jsonValue).put("tokenGenerated", false);
                        ((ObjectNode)jsonValue).remove("refreshToken");
                        ((ObjectNode)jsonValue).remove("refreshTokenExpires");
                        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, settings);
                    } else if (tokenLifeDuration < 604800000L) {
                        log.info("Trying to refresh refresh token.");
                        String clientId = jsonValue.get("clientId").asText();
                        String clientSecret = jsonValue.get("clientSecret").asText();
                        String refreshToken = jsonValue.get("refreshToken").asText();
                        String tokenUri = jsonValue.get("tokenUri").asText();
                        TokenResponse tokenResponse = new RefreshTokenRequest((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), new GenericUrl(tokenUri), refreshToken).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(clientId, clientSecret)).execute();
                        ((ObjectNode)jsonValue).put("refreshToken", tokenResponse.getRefreshToken());
                        ((ObjectNode)jsonValue).put("refreshTokenExpires", Instant.now().plus(Duration.ofDays(90L)).toEpochMilli());
                        this.adminSettingsService.saveAdminSettings(TenantId.SYS_TENANT_ID, settings);
                    }
                }
                catch (Exception e) {
                    log.error("Error occurred while checking token", (Throwable)e);
                }
            }
        }
    }

    @ConstructorProperties(value={"adminSettingsService"})
    @Generated
    public RefreshTokenExpCheckService(AdminSettingsService adminSettingsService) {
        this.adminSettingsService = adminSettingsService;
    }
}

