/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;

public abstract class PaginatedUpdater<I, D> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PaginatedUpdater.class);
    private static final int DEFAULT_LIMIT = 100;
    private int updated = 0;

    public void updateEntities(I id) {
        this.updated = 0;
        PageLink pageLink = new PageLink(100);
        boolean hasNext = true;
        while (hasNext) {
            PageData<D> entities = this.findEntities(id, pageLink);
            for (Object entity : entities.getData()) {
                this.updateEntity(entity);
            }
            this.updated += entities.getData().size();
            hasNext = entities.hasNext();
            if (hasNext) {
                log.info("{}: {} entities updated so far...", (Object)this.getName(), (Object)this.updated);
                pageLink = pageLink.nextPageLink();
                continue;
            }
            if (this.updated <= 100 && !this.forceReportTotal()) continue;
            log.info("{}: {} total entities updated.", (Object)this.getName(), (Object)this.updated);
        }
    }

    public void updateEntities() {
        this.updateEntities(null);
    }

    protected boolean forceReportTotal() {
        return false;
    }

    protected abstract String getName();

    protected abstract PageData<D> findEntities(I var1, PageLink var2);

    protected abstract void updateEntity(D var1);
}

