/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install.update;

import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.thingsboard.server.service.install.update.CacheCleanupService;

@Service
@Profile(value={"install"})
public class DefaultCacheCleanupService
implements CacheCleanupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultCacheCleanupService.class);
    private final CacheManager cacheManager;
    private final Optional<RedisTemplate<String, Object>> redisTemplate;

    @Override
    public void clearCache() throws Exception {
        log.info("Clearing cache to upgrade.");
        this.clearAll();
    }

    void clearAllCaches() {
        this.cacheManager.getCacheNames().forEach(this::clearCacheByName);
    }

    void clearCacheByName(String cacheName) {
        log.info("Clearing cache [{}]", (Object)cacheName);
        Cache cache = this.cacheManager.getCache(cacheName);
        Objects.requireNonNull(cache, "Cache does not exist for name " + cacheName);
        cache.clear();
    }

    void clearAll() {
        if (this.redisTemplate.isPresent()) {
            log.info("Flushing all caches");
            this.redisTemplate.get().execute(connection -> {
                connection.serverCommands().flushAll();
                return null;
            });
            return;
        }
        this.cacheManager.getCacheNames().forEach(this::clearCacheByName);
    }

    @ConstructorProperties(value={"cacheManager", "redisTemplate"})
    @Generated
    public DefaultCacheCleanupService(CacheManager cacheManager, Optional<RedisTemplate<String, Object>> redisTemplate) {
        this.cacheManager = cacheManager;
        this.redisTemplate = redisTemplate;
    }
}

