/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;
import org.thingsboard.server.service.install.EntityDatabaseSchemaService;
import org.thingsboard.server.service.install.SqlAbstractDatabaseSchemaService;

@Service
@Profile(value={"install"})
public class SqlEntityDatabaseSchemaService
extends SqlAbstractDatabaseSchemaService
implements EntityDatabaseSchemaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlEntityDatabaseSchemaService.class);
    public static final String SCHEMA_ENTITIES_SQL = "schema-entities.sql";
    public static final String SCHEMA_ENTITIES_IDX_SQL = "schema-entities-idx.sql";
    public static final String SCHEMA_ENTITIES_IDX_PSQL_ADDON_SQL = "schema-entities-idx-psql-addon.sql";
    public static final String SCHEMA_VIEWS_AND_FUNCTIONS_SQL = "schema-views-and-functions.sql";

    public SqlEntityDatabaseSchemaService() {
        super(SCHEMA_ENTITIES_SQL, SCHEMA_ENTITIES_IDX_SQL);
    }

    @Override
    public void createDatabaseIndexes() throws Exception {
        super.createDatabaseIndexes();
        log.info("Installing SQL DataBase schema PostgreSQL specific indexes part: schema-entities-idx-psql-addon.sql");
        this.executeQueryFromFile(SCHEMA_ENTITIES_IDX_PSQL_ADDON_SQL);
    }

    @Override
    public void createOrUpdateDeviceInfoView(boolean activityStateInTelemetry) {
        String sourceViewName = activityStateInTelemetry ? "device_info_active_ts_view" : "device_info_active_attribute_view";
        this.executeQuery("DROP VIEW IF EXISTS device_info_view CASCADE;");
        this.executeQuery("CREATE OR REPLACE VIEW device_info_view AS SELECT * FROM " + sourceViewName + ";");
    }

    @Override
    public void createOrUpdateViewsAndFunctions() throws Exception {
        log.info("Installing SQL DataBase schema views and functions: schema-views-and-functions.sql");
        this.executeQueryFromFile(SCHEMA_VIEWS_AND_FUNCTIONS_SQL);
    }
}

