/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.server.service.install.DatabaseSchemaService;
import org.thingsboard.server.service.install.InstallScripts;

public abstract class SqlAbstractDatabaseSchemaService
implements DatabaseSchemaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlAbstractDatabaseSchemaService.class);
    protected static final String SQL_DIR = "sql";
    @Value(value="${spring.datasource.url}")
    protected String dbUrl;
    @Value(value="${spring.datasource.username}")
    protected String dbUserName;
    @Value(value="${spring.datasource.password}")
    protected String dbPassword;
    @Autowired
    protected InstallScripts installScripts;
    private final String schemaSql;
    private final String schemaIdxSql;

    protected SqlAbstractDatabaseSchemaService(String schemaSql, String schemaIdxSql) {
        this.schemaSql = schemaSql;
        this.schemaIdxSql = schemaIdxSql;
    }

    @Override
    public void createDatabaseSchema() throws Exception {
        this.createDatabaseSchema(true);
    }

    @Override
    public void createDatabaseSchema(boolean createIndexes) throws Exception {
        log.info("Installing SQL DataBase schema part: " + this.schemaSql);
        this.executeQueryFromFile(this.schemaSql);
        if (createIndexes) {
            this.createDatabaseIndexes();
        }
    }

    @Override
    public void createDatabaseIndexes() throws Exception {
        if (this.schemaIdxSql != null) {
            log.info("Installing SQL DataBase schema indexes part: " + this.schemaIdxSql);
            this.executeQueryFromFile(this.schemaIdxSql);
        }
    }

    void executeQueryFromFile(String schemaIdxSql) throws SQLException, IOException {
        Path schemaIdxFile = Paths.get(this.installScripts.getDataDir(), SQL_DIR, schemaIdxSql);
        String sql = Files.readString(schemaIdxFile);
        try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);){
            conn.createStatement().execute(sql);
        }
    }

    protected void executeQuery(String query) {
        this.executeQuery(query, null);
    }

    protected void executeQuery(String query, String logQuery) {
        logQuery = logQuery != null ? logQuery : query;
        try (Connection conn = DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);){
            conn.createStatement().execute(query);
            log.info("Successfully executed query: {}", (Object)logQuery);
            Thread.sleep(5000L);
        }
        catch (InterruptedException | SQLException e) {
            throw new RuntimeException("Failed to execute query: " + logQuery, e);
        }
    }
}

