/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.install;

import java.nio.file.Path;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.cassandra.CassandraInstallCluster;
import org.thingsboard.server.service.install.cql.CQLStatementsParser;

public abstract class AbstractCassandraDatabaseUpgradeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCassandraDatabaseUpgradeService.class);
    @Autowired
    protected CassandraCluster cluster;
    @Autowired
    @Qualifier(value="CassandraInstallCluster")
    private CassandraInstallCluster installCluster;

    protected void loadCql(Path cql) throws Exception {
        List<String> statements = new CQLStatementsParser(cql).getStatements();
        statements.forEach(statement -> {
            this.installCluster.getSession().execute(statement);
            try {
                Thread.sleep(2500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        Thread.sleep(5000L);
    }
}

