/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.stats;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.stats.DefaultCounter;
import org.thingsboard.server.common.stats.StatsCounter;
import org.thingsboard.server.common.stats.StatsFactory;
import org.thingsboard.server.common.stats.StatsTimer;
import org.thingsboard.server.common.stats.StatsType;
import org.thingsboard.server.gen.transport.TransportProtos;

@Service
@ConditionalOnProperty(name={"queue.core.housekeeper.stats.enabled"}, havingValue="true", matchIfMissing=true)
public class HousekeeperStatsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HousekeeperStatsService.class);
    private final Map<HousekeeperTaskType, HousekeeperStats> stats = new EnumMap<HousekeeperTaskType, HousekeeperStats>(HousekeeperTaskType.class);

    public HousekeeperStatsService(StatsFactory statsFactory) {
        for (HousekeeperTaskType taskType : HousekeeperTaskType.values()) {
            this.stats.put(taskType, new HousekeeperStats(taskType, statsFactory));
        }
    }

    @Scheduled(initialDelayString="${queue.core.housekeeper.stats.print-interval-ms:60000}", fixedDelayString="${queue.core.housekeeper.stats.print-interval-ms:60000}")
    private void reportStats() {
        String statsStr = this.stats.values().stream().map(stats -> {
            String countersStr = stats.getCounters().stream().filter(counter -> counter.get() > 0).map(counter -> counter.getName() + " = [" + counter.get() + "]").collect(Collectors.joining(" "));
            if (countersStr.isEmpty()) {
                return null;
            }
            return String.valueOf(stats.getTaskType()) + " " + countersStr + " avgProcessingTime [" + stats.getProcessingTimer().getAvg() + " ms]";
        }).filter(Objects::nonNull).collect(Collectors.joining(", "));
        if (!statsStr.isEmpty()) {
            this.stats.values().forEach(HousekeeperStats::reset);
            log.info("Housekeeper stats: {}", (Object)statsStr);
        }
    }

    public void reportProcessed(HousekeeperTaskType taskType, TransportProtos.ToHousekeeperServiceMsg msg, long timing) {
        HousekeeperStats stats = this.stats.get(taskType);
        if (msg.getTask().getErrorsCount() == 0) {
            stats.getProcessedCounter().increment();
        } else {
            stats.getReprocessedCounter().increment();
        }
        stats.getProcessingTimer().record(timing);
    }

    public void reportFailure(HousekeeperTaskType taskType, TransportProtos.ToHousekeeperServiceMsg msg) {
        HousekeeperStats stats = this.stats.get(taskType);
        if (msg.getTask().getErrorsCount() == 0) {
            stats.getFailedProcessingCounter().increment();
        } else {
            stats.getFailedReprocessingCounter().increment();
        }
    }

    static class HousekeeperStats {
        private final HousekeeperTaskType taskType;
        private final List<StatsCounter> counters = new ArrayList<StatsCounter>();
        private final StatsCounter processedCounter;
        private final StatsCounter failedProcessingCounter;
        private final StatsCounter reprocessedCounter;
        private final StatsCounter failedReprocessingCounter;
        private final StatsTimer processingTimer;

        public HousekeeperStats(HousekeeperTaskType taskType, StatsFactory statsFactory) {
            this.taskType = taskType;
            this.processedCounter = this.register("processed", statsFactory);
            this.failedProcessingCounter = this.register("failedProcessing", statsFactory);
            this.reprocessedCounter = this.register("reprocessed", statsFactory);
            this.failedReprocessingCounter = this.register("failedReprocessing", statsFactory);
            this.processingTimer = statsFactory.createStatsTimer(StatsType.HOUSEKEEPER.getName(), "processingTime", new String[]{"taskType", taskType.name()});
        }

        private StatsCounter register(String statsName, StatsFactory statsFactory) {
            StatsCounter counter = statsFactory.createStatsCounter(StatsType.HOUSEKEEPER.getName(), statsName, new String[]{"taskType", this.taskType.name()});
            this.counters.add(counter);
            return counter;
        }

        public void reset() {
            this.counters.forEach(DefaultCounter::clear);
            this.processingTimer.reset();
        }

        @Generated
        public HousekeeperTaskType getTaskType() {
            return this.taskType;
        }

        @Generated
        public List<StatsCounter> getCounters() {
            return this.counters;
        }

        @Generated
        public StatsCounter getProcessedCounter() {
            return this.processedCounter;
        }

        @Generated
        public StatsCounter getFailedProcessingCounter() {
            return this.failedProcessingCounter;
        }

        @Generated
        public StatsCounter getReprocessedCounter() {
            return this.reprocessedCounter;
        }

        @Generated
        public StatsCounter getFailedReprocessingCounter() {
            return this.failedReprocessingCounter;
        }

        @Generated
        public StatsTimer getProcessingTimer() {
            return this.processingTimer;
        }
    }
}

