/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.housekeeper.processor;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.housekeeper.AlarmsUnassignHousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTask;
import org.thingsboard.server.common.data.housekeeper.HousekeeperTaskType;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.util.TbPair;
import org.thingsboard.server.dao.alarm.AlarmService;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmService;
import org.thingsboard.server.service.housekeeper.processor.HousekeeperTaskProcessor;

@Component
public class AlarmsUnassignTaskProcessor
extends HousekeeperTaskProcessor<AlarmsUnassignHousekeeperTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmsUnassignTaskProcessor.class);
    private final TbAlarmService tbAlarmService;
    private final AlarmService alarmService;

    @Override
    public void process(AlarmsUnassignHousekeeperTask task) throws Exception {
        TenantId tenantId = task.getTenantId();
        UserId userId = (UserId)task.getEntityId();
        if (task.getAlarms() == null) {
            List alarms;
            AlarmId lastId = null;
            long lastCreatedTime = 0L;
            while (!(alarms = this.alarmService.findAlarmIdsByAssigneeId(tenantId, userId, lastCreatedTime, lastId, 64)).isEmpty()) {
                this.housekeeperClient.submitTask((HousekeeperTask)new AlarmsUnassignHousekeeperTask(tenantId, userId, task.getUserTitle(), alarms.stream().map(TbPair::getFirst).toList()));
                TbPair last = (TbPair)alarms.get(alarms.size() - 1);
                lastId = new AlarmId((UUID)last.getFirst());
                lastCreatedTime = (Long)last.getSecond();
                log.debug("[{}][{}] Submitted task for unassigning {} alarms", new Object[]{tenantId, userId, alarms.size()});
            }
        } else {
            this.tbAlarmService.unassignDeletedUserAlarms(tenantId, userId, task.getUserTitle(), task.getAlarms(), task.getTs());
            log.debug("[{}][{}] Unassigned {} alarms", new Object[]{tenantId, userId, task.getAlarms().size()});
        }
    }

    @Override
    public HousekeeperTaskType getTaskType() {
        return HousekeeperTaskType.UNASSIGN_ALARMS;
    }

    @ConstructorProperties(value={"tbAlarmService", "alarmService"})
    @Generated
    public AlarmsUnassignTaskProcessor(TbAlarmService tbAlarmService, AlarmService alarmService) {
        this.tbAlarmService = tbAlarmService;
        this.alarmService = alarmService;
    }
}

