/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.widgets.bundle;

import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.WidgetTypeId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.widgets.bundle.TbWidgetsBundleService;
import org.thingsboard.server.service.security.model.SecurityUser;

@Service
@TbCoreComponent
public class DefaultWidgetsBundleService
extends AbstractTbEntityService
implements TbWidgetsBundleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultWidgetsBundleService.class);
    private final WidgetsBundleService widgetsBundleService;
    private final WidgetTypeService widgetTypeService;

    @Override
    public WidgetsBundle save(WidgetsBundle widgetsBundle, SecurityUser user) throws Exception {
        ActionType actionType = widgetsBundle.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = widgetsBundle.getTenantId();
        try {
            WidgetsBundle savedWidgetsBundle = this.checkNotNull(this.widgetsBundleService.saveWidgetsBundle(widgetsBundle));
            this.autoCommit(user, (EntityId)savedWidgetsBundle.getId());
            this.logEntityActionService.logEntityAction(tenantId, savedWidgetsBundle.getId(), savedWidgetsBundle, null, actionType, (User)user, new Object[0]);
            return savedWidgetsBundle;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.WIDGETS_BUNDLE), widgetsBundle, actionType, (User)user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public void delete(WidgetsBundle widgetsBundle, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = widgetsBundle.getTenantId();
        try {
            this.widgetsBundleService.deleteWidgetsBundle(widgetsBundle.getTenantId(), widgetsBundle.getId());
            this.logEntityActionService.logEntityAction(tenantId, widgetsBundle.getId(), widgetsBundle, null, actionType, user, new Object[0]);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.WIDGETS_BUNDLE), actionType, user, e, new Object[]{widgetsBundle.getId()});
            throw e;
        }
    }

    @Override
    public void updateWidgetsBundleWidgetTypes(WidgetsBundleId widgetsBundleId, List<WidgetTypeId> widgetTypeIds, User user) throws Exception {
        this.widgetTypeService.updateWidgetsBundleWidgetTypes(user.getTenantId(), widgetsBundleId, widgetTypeIds);
        this.autoCommit(user, (EntityId)widgetsBundleId);
    }

    @Override
    public void updateWidgetsBundleWidgetFqns(WidgetsBundleId widgetsBundleId, List<String> widgetFqns, User user) throws Exception {
        this.widgetTypeService.updateWidgetsBundleWidgetFqns(user.getTenantId(), widgetsBundleId, widgetFqns);
        this.autoCommit(user, (EntityId)widgetsBundleId);
    }

    @ConstructorProperties(value={"widgetsBundleService", "widgetTypeService"})
    @Generated
    public DefaultWidgetsBundleService(WidgetsBundleService widgetsBundleService, WidgetTypeService widgetTypeService) {
        this.widgetsBundleService = widgetsBundleService;
        this.widgetTypeService = widgetTypeService;
    }
}

