/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.device;

import com.google.common.util.concurrent.ListenableFuture;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.dao.device.claim.ClaimResult;
import org.thingsboard.server.dao.device.claim.ReclaimResult;

public interface TbDeviceService {
    public Device save(Device var1, String var2, User var3) throws Exception;

    public Device saveDeviceWithCredentials(Device var1, DeviceCredentials var2, User var3) throws ThingsboardException;

    public void delete(Device var1, User var2);

    public Device assignDeviceToCustomer(TenantId var1, DeviceId var2, Customer var3, User var4) throws ThingsboardException;

    public Device unassignDeviceFromCustomer(Device var1, Customer var2, User var3) throws ThingsboardException;

    public Device assignDeviceToPublicCustomer(TenantId var1, DeviceId var2, User var3) throws ThingsboardException;

    public DeviceCredentials getDeviceCredentialsByDeviceId(Device var1, User var2) throws ThingsboardException;

    public DeviceCredentials updateDeviceCredentials(Device var1, DeviceCredentials var2, User var3) throws ThingsboardException;

    public ListenableFuture<ClaimResult> claimDevice(TenantId var1, Device var2, CustomerId var3, String var4, User var5);

    public ListenableFuture<ReclaimResult> reclaimDevice(TenantId var1, Device var2, User var3);

    public Device assignDeviceToTenant(Device var1, Tenant var2, User var3);

    public Device assignDeviceToEdge(TenantId var1, DeviceId var2, Edge var3, User var4) throws ThingsboardException;

    public Device unassignDeviceFromEdge(Device var1, Edge var2, User var3) throws ThingsboardException;
}

