/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.device;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.dao.device.ClaimDevicesService;
import org.thingsboard.server.dao.device.DeviceCredentialsService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.device.claim.ClaimResponse;
import org.thingsboard.server.dao.device.claim.ClaimResult;
import org.thingsboard.server.dao.device.claim.ReclaimResult;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.device.TbDeviceService;

@TbCoreComponent
@Service
public class DefaultTbDeviceService
extends AbstractTbEntityService
implements TbDeviceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbDeviceService.class);
    private final DeviceService deviceService;
    private final DeviceCredentialsService deviceCredentialsService;
    private final ClaimDevicesService claimDevicesService;

    @Override
    public Device save(Device device, String accessToken, User user) throws Exception {
        ActionType actionType = device.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = device.getTenantId();
        try {
            Device savedDevice = this.checkNotNull(this.deviceService.saveDeviceWithAccessToken(device, accessToken));
            this.autoCommit(user, (EntityId)savedDevice.getId());
            this.logEntityActionService.logEntityAction(tenantId, savedDevice.getId(), savedDevice, savedDevice.getCustomerId(), actionType, user, new Object[0]);
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), device, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public Device saveDeviceWithCredentials(Device device, DeviceCredentials credentials, User user) throws ThingsboardException {
        ActionType actionType = device.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = device.getTenantId();
        try {
            Device savedDevice = this.checkNotNull(this.deviceService.saveDeviceWithCredentials(device, credentials));
            this.logEntityActionService.logEntityAction(tenantId, savedDevice.getId(), savedDevice, savedDevice.getCustomerId(), actionType, user, new Object[0]);
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), device, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    @Transactional
    public void delete(Device device, User user) {
        ActionType actionType = ActionType.DELETED;
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        try {
            this.deviceService.deleteDevice(tenantId, deviceId);
            this.logEntityActionService.logEntityAction(tenantId, deviceId, device, device.getCustomerId(), actionType, user, deviceId.toString());
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString()});
            throw e;
        }
    }

    @Override
    public Device assignDeviceToCustomer(TenantId tenantId, DeviceId deviceId, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        CustomerId customerId = customer.getId();
        try {
            Device savedDevice = this.checkNotNull(this.deviceService.assignDeviceToCustomer(tenantId, deviceId, customerId));
            this.logEntityActionService.logEntityAction(tenantId, deviceId, savedDevice, customerId, actionType, user, (Object)deviceId.toString(), (Object)customerId.toString(), (Object)customer.getName());
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString(), customerId.toString()});
            throw e;
        }
    }

    @Override
    public Device unassignDeviceFromCustomer(Device device, Customer customer, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_CUSTOMER;
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        try {
            Device savedDevice = this.checkNotNull(this.deviceService.unassignDeviceFromCustomer(tenantId, deviceId));
            CustomerId customerId = customer.getId();
            this.logEntityActionService.logEntityAction(tenantId, deviceId, savedDevice, customerId, actionType, user, (Object)deviceId.toString(), (Object)customerId.toString(), (Object)customer.getName());
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString()});
            throw e;
        }
    }

    @Override
    public Device assignDeviceToPublicCustomer(TenantId tenantId, DeviceId deviceId, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_CUSTOMER;
        Customer publicCustomer = this.customerService.findOrCreatePublicCustomer(tenantId);
        try {
            Device savedDevice = this.checkNotNull(this.deviceService.assignDeviceToCustomer(tenantId, deviceId, publicCustomer.getId()));
            this.logEntityActionService.logEntityAction(tenantId, deviceId, savedDevice, savedDevice.getCustomerId(), actionType, user, (Object)deviceId.toString(), (Object)publicCustomer.getId().toString(), (Object)publicCustomer.getName());
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString()});
            throw e;
        }
    }

    @Override
    public DeviceCredentials getDeviceCredentialsByDeviceId(Device device, User user) throws ThingsboardException {
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        try {
            DeviceCredentials deviceCredentials = this.checkNotNull(this.deviceCredentialsService.findDeviceCredentialsByDeviceId(tenantId, deviceId));
            this.logEntityActionService.logEntityAction(tenantId, deviceId, device, device.getCustomerId(), ActionType.CREDENTIALS_READ, user, deviceId.toString());
            return deviceCredentials;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), ActionType.CREDENTIALS_READ, user, e, new Object[]{deviceId.toString()});
            throw e;
        }
    }

    @Override
    public DeviceCredentials updateDeviceCredentials(Device device, DeviceCredentials deviceCredentials, User user) throws ThingsboardException {
        ActionType actionType = ActionType.CREDENTIALS_UPDATED;
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        try {
            DeviceCredentials result = this.checkNotNull(this.deviceCredentialsService.updateDeviceCredentials(tenantId, deviceCredentials));
            this.logEntityActionService.logEntityAction(tenantId, deviceId, device, device.getCustomerId(), actionType, user, result);
            return result;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceCredentials});
            throw e;
        }
    }

    @Override
    public ListenableFuture<ClaimResult> claimDevice(TenantId tenantId, Device device, CustomerId customerId, String secretKey, User user) {
        ListenableFuture future = this.claimDevicesService.claimDevice(device, customerId, secretKey);
        return Futures.transform((ListenableFuture)future, result -> {
            if (result != null && result.getResponse().equals((Object)ClaimResponse.SUCCESS)) {
                this.logEntityActionService.logEntityAction(tenantId, device.getId(), result.getDevice(), customerId, ActionType.ASSIGNED_TO_CUSTOMER, user, (Object)device.getId().toString(), (Object)customerId.toString(), (Object)this.customerService.findCustomerById(tenantId, customerId).getName());
            }
            return result;
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ListenableFuture<ReclaimResult> reclaimDevice(TenantId tenantId, Device device, User user) {
        ListenableFuture future = this.claimDevicesService.reClaimDevice(tenantId, device);
        return Futures.transform((ListenableFuture)future, result -> {
            Customer unassignedCustomer = result.getUnassignedCustomer();
            if (unassignedCustomer != null) {
                this.logEntityActionService.logEntityAction(tenantId, device.getId(), device, device.getCustomerId(), ActionType.UNASSIGNED_FROM_CUSTOMER, user, (Object)device.getId().toString(), (Object)unassignedCustomer.getId().toString(), (Object)unassignedCustomer.getName());
            }
            return result;
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public Device assignDeviceToTenant(Device device, Tenant newTenant, User user) {
        ActionType actionType = ActionType.ASSIGNED_TO_TENANT;
        TenantId tenantId = device.getTenantId();
        TenantId newTenantId = newTenant.getId();
        DeviceId deviceId = device.getId();
        try {
            Device assignedDevice = this.deviceService.assignDeviceToTenant(newTenantId, device);
            this.logEntityActionService.logEntityAction(tenantId, deviceId, assignedDevice, assignedDevice.getCustomerId(), actionType, user, (Object)newTenantId.toString(), (Object)newTenant.getName());
            return assignedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString()});
            throw e;
        }
    }

    @Override
    public Device assignDeviceToEdge(TenantId tenantId, DeviceId deviceId, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.ASSIGNED_TO_EDGE;
        EdgeId edgeId = edge.getId();
        try {
            Device savedDevice = this.checkNotNull(this.deviceService.assignDeviceToEdge(tenantId, deviceId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, deviceId, savedDevice, savedDevice.getCustomerId(), actionType, user, (Object)deviceId.toString(), (Object)edgeId.toString(), (Object)edge.getName());
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString(), edgeId.toString()});
            throw e;
        }
    }

    @Override
    public Device unassignDeviceFromEdge(Device device, Edge edge, User user) throws ThingsboardException {
        ActionType actionType = ActionType.UNASSIGNED_FROM_EDGE;
        TenantId tenantId = device.getTenantId();
        DeviceId deviceId = device.getId();
        EdgeId edgeId = edge.getId();
        try {
            Device savedDevice = this.checkNotNull(this.deviceService.unassignDeviceFromEdge(tenantId, deviceId, edgeId));
            this.logEntityActionService.logEntityAction(tenantId, deviceId, savedDevice, savedDevice.getCustomerId(), actionType, user, (Object)deviceId.toString(), (Object)edgeId.toString(), (Object)edge.getName());
            return savedDevice;
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.DEVICE), actionType, user, e, new Object[]{deviceId.toString(), edgeId.toString()});
            throw e;
        }
    }

    @ConstructorProperties(value={"deviceService", "deviceCredentialsService", "claimDevicesService"})
    @Generated
    public DefaultTbDeviceService(DeviceService deviceService, DeviceCredentialsService deviceCredentialsService, ClaimDevicesService claimDevicesService) {
        this.deviceService = deviceService;
        this.deviceCredentialsService = deviceCredentialsService;
        this.claimDevicesService = claimDevicesService;
    }
}

