/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.entitiy.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmAssignee;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmUpdateRequest;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.exception.ThingsboardErrorCode;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.service.entitiy.AbstractTbEntityService;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmCommentService;
import org.thingsboard.server.service.entitiy.alarm.TbAlarmService;

@Service
public class DefaultTbAlarmService
extends AbstractTbEntityService
implements TbAlarmService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbAlarmService.class);
    @Autowired
    protected TbAlarmCommentService alarmCommentService;

    @Override
    public Alarm save(Alarm alarm, User user) throws ThingsboardException {
        ActionType actionType = alarm.getId() == null ? ActionType.ADDED : ActionType.UPDATED;
        TenantId tenantId = alarm.getTenantId();
        try {
            AlarmApiCallResult result = alarm.getId() == null ? this.alarmSubscriptionService.createAlarm(AlarmCreateOrUpdateActiveRequest.fromAlarm((Alarm)alarm, (UserId)user.getId())) : this.alarmSubscriptionService.updateAlarm(AlarmUpdateRequest.fromAlarm((Alarm)alarm, (UserId)user.getId()));
            if (!result.isSuccessful()) {
                throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
            }
            AlarmInfo resultAlarm = result.getAlarm();
            if (alarm.isAcknowledged() && !resultAlarm.isAcknowledged()) {
                resultAlarm = this.ack((Alarm)resultAlarm, alarm.getAckTs(), user);
            }
            if (alarm.isCleared() && !resultAlarm.isCleared()) {
                resultAlarm = this.clear((Alarm)resultAlarm, alarm.getClearTs(), user);
            }
            UserId newAssignee = alarm.getAssigneeId();
            UserId curAssignee = resultAlarm.getAssigneeId();
            if (newAssignee != null && !newAssignee.equals((Object)curAssignee)) {
                resultAlarm = this.assign((Alarm)resultAlarm, newAssignee, alarm.getAssignTs(), user);
            } else if (newAssignee == null && curAssignee != null) {
                resultAlarm = this.unassign(alarm, alarm.getAssignTs(), user);
            }
            if (result.isModified()) {
                this.logEntityActionService.logEntityAction(tenantId, alarm.getOriginator(), resultAlarm, resultAlarm.getCustomerId(), actionType, user, new Object[0]);
            }
            return new Alarm((Alarm)resultAlarm);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(EntityType.ALARM), alarm, actionType, user, e, new Object[0]);
            throw e;
        }
    }

    @Override
    public AlarmInfo ack(Alarm alarm, User user) throws ThingsboardException {
        return this.ack(alarm, System.currentTimeMillis(), user);
    }

    @Override
    public AlarmInfo ack(Alarm alarm, long ackTs, User user) throws ThingsboardException {
        AlarmApiCallResult result = this.alarmSubscriptionService.acknowledgeAlarm(alarm.getTenantId(), alarm.getId(), DefaultTbAlarmService.getOrDefault(ackTs));
        if (!result.isSuccessful()) {
            throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        AlarmInfo alarmInfo = result.getAlarm();
        if (!result.isModified()) {
            throw new ThingsboardException("Alarm was already acknowledged!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        String systemComment = String.format("Alarm was acknowledged by user %s", user.getTitle());
        this.addSystemAlarmComment((Alarm)alarmInfo, user, "ACK", systemComment);
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), alarm.getOriginator(), alarmInfo, alarmInfo.getCustomerId(), ActionType.ALARM_ACK, user, new Object[0]);
        return alarmInfo;
    }

    @Override
    public AlarmInfo clear(Alarm alarm, User user) throws ThingsboardException {
        return this.clear(alarm, System.currentTimeMillis(), user);
    }

    @Override
    public AlarmInfo clear(Alarm alarm, long clearTs, User user) throws ThingsboardException {
        AlarmApiCallResult result = this.alarmSubscriptionService.clearAlarm(alarm.getTenantId(), alarm.getId(), DefaultTbAlarmService.getOrDefault(clearTs), null);
        if (!result.isSuccessful()) {
            throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        AlarmInfo alarmInfo = result.getAlarm();
        if (!result.isCleared()) {
            throw new ThingsboardException("Alarm was already cleared!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        String systemComment = String.format("Alarm was cleared by user %s", user.getTitle());
        this.addSystemAlarmComment((Alarm)alarmInfo, user, "CLEAR", systemComment);
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), alarm.getOriginator(), alarmInfo, alarmInfo.getCustomerId(), ActionType.ALARM_CLEAR, user, new Object[0]);
        return alarmInfo;
    }

    @Override
    public AlarmInfo assign(Alarm alarm, UserId assigneeId, long assignTs, User user) throws ThingsboardException {
        AlarmApiCallResult result = this.alarmSubscriptionService.assignAlarm(alarm.getTenantId(), alarm.getId(), assigneeId, DefaultTbAlarmService.getOrDefault(assignTs));
        if (!result.isSuccessful()) {
            throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        AlarmInfo alarmInfo = result.getAlarm();
        if (!result.isModified()) {
            throw new ThingsboardException("Alarm was already assigned to this user!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        AlarmAssignee assignee = alarmInfo.getAssignee();
        String systemComment = String.format("Alarm was assigned by user %s to user %s", user.getTitle(), assignee.getTitle());
        this.addSystemAlarmComment((Alarm)alarmInfo, user, "ASSIGN", systemComment, assignee.getId());
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), alarm.getOriginator(), alarmInfo, alarmInfo.getCustomerId(), ActionType.ALARM_ASSIGNED, user, new Object[0]);
        return alarmInfo;
    }

    @Override
    public AlarmInfo unassign(Alarm alarm, long unassignTs, User user) throws ThingsboardException {
        AlarmApiCallResult result = this.alarmSubscriptionService.unassignAlarm(alarm.getTenantId(), alarm.getId(), DefaultTbAlarmService.getOrDefault(unassignTs));
        if (!result.isSuccessful()) {
            throw new ThingsboardException(ThingsboardErrorCode.ITEM_NOT_FOUND);
        }
        AlarmInfo alarmInfo = result.getAlarm();
        if (!result.isModified()) {
            throw new ThingsboardException("Alarm was already unassigned!", ThingsboardErrorCode.BAD_REQUEST_PARAMS);
        }
        String systemComment = String.format("Alarm was unassigned by user %s", user.getTitle());
        this.addSystemAlarmComment((Alarm)alarmInfo, user, "ASSIGN", systemComment);
        this.logEntityActionService.logEntityAction(alarm.getTenantId(), alarm.getOriginator(), alarmInfo, alarmInfo.getCustomerId(), ActionType.ALARM_UNASSIGNED, user, new Object[0]);
        return alarmInfo;
    }

    @Override
    public void unassignDeletedUserAlarms(TenantId tenantId, UserId userId, String userTitle, List<UUID> alarms, long unassignTs) {
        for (UUID alarmId : alarms) {
            log.trace("[{}] Unassigning alarm {} from user {}", new Object[]{tenantId, alarmId, userId});
            AlarmApiCallResult result = this.alarmSubscriptionService.unassignAlarm(tenantId, new AlarmId(alarmId), unassignTs);
            if (!result.isSuccessful()) {
                log.error("[{}] Cannot unassign alarm {} from user {}", new Object[]{tenantId, alarmId, userId});
                continue;
            }
            if (!result.isModified()) continue;
            String comment = String.format("Alarm was unassigned because user %s - was deleted", userTitle);
            this.addSystemAlarmComment((Alarm)result.getAlarm(), null, "ASSIGN", comment);
            this.logEntityActionService.logEntityAction(result.getAlarm().getTenantId(), result.getAlarm().getOriginator(), result.getAlarm(), result.getAlarm().getCustomerId(), ActionType.ALARM_UNASSIGNED, null, new Object[0]);
        }
    }

    @Override
    public boolean delete(Alarm alarm, User user) {
        boolean deleted;
        TenantId tenantId = alarm.getTenantId();
        AlarmId alarmId = alarm.getId();
        EntityId alarmOriginator = alarm.getOriginator();
        try {
            deleted = this.alarmSubscriptionService.deleteAlarm(tenantId, alarmId);
        }
        catch (Exception e) {
            this.logEntityActionService.logEntityAction(tenantId, this.emptyId(alarmOriginator.getEntityType()), ActionType.ALARM_DELETE, user, e, new Object[]{alarmId});
            throw e;
        }
        if (deleted) {
            this.logEntityActionService.logEntityAction(tenantId, alarmOriginator, alarm, alarm.getCustomerId(), ActionType.ALARM_DELETE, user, alarmId);
        }
        return deleted;
    }

    private static long getOrDefault(long ts) {
        return ts > 0L ? ts : System.currentTimeMillis();
    }

    private void addSystemAlarmComment(Alarm alarm, User user, String subType, String commentText) {
        this.addSystemAlarmComment(alarm, user, subType, commentText, null);
    }

    private void addSystemAlarmComment(Alarm alarm, User user, String subType, String commentText, UserId assigneeId) {
        ObjectNode commentNode = JacksonUtil.newObjectNode();
        commentNode.put("text", commentText).put("subtype", subType);
        if (user != null) {
            commentNode.put("userId", user.getId().getId().toString());
        }
        if (assigneeId != null) {
            commentNode.put("assigneeId", assigneeId.getId().toString());
        }
        AlarmComment alarmComment = AlarmComment.builder().alarmId(alarm.getId()).type(AlarmCommentType.SYSTEM).comment((JsonNode)commentNode).build();
        try {
            this.alarmCommentService.saveAlarmComment(alarm, alarmComment, user);
        }
        catch (ThingsboardException e) {
            log.error("Failed to save alarm comment", (Throwable)e);
        }
    }

    @ConstructorProperties(value={"alarmCommentService"})
    @Generated
    public DefaultTbAlarmService(TbAlarmCommentService alarmCommentService) {
        this.alarmCommentService = alarmCommentService;
    }
}

