/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.sync;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.DataType;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.common.data.relation.EntityRelationsQuery;
import org.thingsboard.server.common.data.relation.EntitySearchDirection;
import org.thingsboard.server.common.data.relation.RelationTypeGroup;
import org.thingsboard.server.common.data.relation.RelationsSearchParameters;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.cf.CalculatedFieldService;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.relation.RelationService;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.widget.WidgetTypeService;
import org.thingsboard.server.dao.widget.WidgetsBundleService;
import org.thingsboard.server.gen.edge.v1.AttributesRequestMsg;
import org.thingsboard.server.gen.edge.v1.CalculatedFieldRequestMsg;
import org.thingsboard.server.gen.edge.v1.DeviceCredentialsRequestMsg;
import org.thingsboard.server.gen.edge.v1.EntityViewsRequestMsg;
import org.thingsboard.server.gen.edge.v1.RelationRequestMsg;
import org.thingsboard.server.gen.edge.v1.RuleChainMetadataRequestMsg;
import org.thingsboard.server.gen.edge.v1.UserCredentialsRequestMsg;
import org.thingsboard.server.gen.edge.v1.WidgetBundleTypesRequestMsg;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.rpc.sync.EdgeRequestsService;
import org.thingsboard.server.service.entitiy.entityview.TbEntityViewService;
import org.thingsboard.server.service.executors.DbCallbackExecutorService;
import org.thingsboard.server.service.state.DefaultDeviceStateService;

@Service
@TbCoreComponent
public class DefaultEdgeRequestsService
implements EdgeRequestsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEdgeRequestsService.class);
    @Autowired
    private EdgeEventService edgeEventService;
    @Autowired
    private AttributesService attributesService;
    @Autowired
    private TimeseriesService timeseriesService;
    @Autowired
    private RelationService relationService;
    @Lazy
    @Autowired
    private TbEntityViewService entityViewService;
    @Autowired
    private WidgetsBundleService widgetsBundleService;
    @Autowired
    private WidgetTypeService widgetTypeService;
    @Autowired
    private CalculatedFieldService calculatedFieldService;
    @Autowired
    private DbCallbackExecutorService dbCallbackExecutorService;

    @Override
    public ListenableFuture<Void> processRuleChainMetadataRequestMsg(TenantId tenantId, Edge edge, RuleChainMetadataRequestMsg ruleChainMetadataRequestMsg) {
        log.trace("[{}] processRuleChainMetadataRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), ruleChainMetadataRequestMsg});
        if (ruleChainMetadataRequestMsg.getRuleChainIdMSB() == 0L || ruleChainMetadataRequestMsg.getRuleChainIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        RuleChainId ruleChainId = new RuleChainId(new UUID(ruleChainMetadataRequestMsg.getRuleChainIdMSB(), ruleChainMetadataRequestMsg.getRuleChainIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.RULE_CHAIN_METADATA, EdgeEventActionType.ADDED, (EntityId)ruleChainId, null);
    }

    @Override
    public ListenableFuture<Void> processAttributesRequestMsg(TenantId tenantId, Edge edge, AttributesRequestMsg attributesRequestMsg) {
        log.trace("[{}] processAttributesRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), attributesRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)attributesRequestMsg.getEntityType()), (UUID)new UUID(attributesRequestMsg.getEntityIdMSB(), attributesRequestMsg.getEntityIdLSB()));
        EdgeEventType entityType = EdgeUtils.getEdgeEventTypeByEntityType((EntityType)entityId.getEntityType());
        if (entityType == null) {
            log.warn("[{}] Type doesn't supported {}", (Object)tenantId, (Object)entityId.getEntityType());
            return Futures.immediateFuture(null);
        }
        String scope = attributesRequestMsg.getScope();
        ListenableFuture findAttrFuture = this.attributesService.findAll(tenantId, entityId, AttributeScope.valueOf((String)scope));
        return Futures.transformAsync((ListenableFuture)findAttrFuture, ssAttributes -> this.processEntityAttributesAndAddToEdgeQueue(tenantId, entityId, edge, entityType, scope, (List<AttributeKvEntry>)ssAttributes, attributesRequestMsg), (Executor)((Object)this.dbCallbackExecutorService));
    }

    private ListenableFuture<Void> processEntityAttributesAndAddToEdgeQueue(TenantId tenantId, EntityId entityId, Edge edge, EdgeEventType entityType, String scope, List<AttributeKvEntry> ssAttributes, AttributesRequestMsg attributesRequestMsg) {
        HashMap<String, Object> entityData = null;
        ObjectNode attributes = null;
        try {
            ListenableFuture<Void> future;
            if (ssAttributes == null || ssAttributes.isEmpty()) {
                log.trace("[{}][{}] No attributes found for entity {} [{}]", new Object[]{tenantId, edge.getName(), entityId.getEntityType(), entityId.getId()});
                future = Futures.immediateFuture(null);
            } else {
                entityData = new HashMap<String, Object>();
                attributes = JacksonUtil.newObjectNode();
                for (AttributeKvEntry attr : ssAttributes) {
                    if (DefaultDeviceStateService.ACTIVITY_KEYS_WITHOUT_INACTIVITY_TIMEOUT.contains(attr.getKey())) continue;
                    if (attr.getDataType() == DataType.BOOLEAN && attr.getBooleanValue().isPresent()) {
                        attributes.put(attr.getKey(), (Boolean)attr.getBooleanValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.DOUBLE && attr.getDoubleValue().isPresent()) {
                        attributes.put(attr.getKey(), (Double)attr.getDoubleValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.LONG && attr.getLongValue().isPresent()) {
                        attributes.put(attr.getKey(), (Long)attr.getLongValue().get());
                        continue;
                    }
                    if (attr.getDataType() == DataType.JSON && attr.getJsonValue().isPresent()) {
                        attributes.set(attr.getKey(), JacksonUtil.toJsonNode((String)((String)attr.getJsonValue().get())));
                        continue;
                    }
                    attributes.put(attr.getKey(), attr.getValueAsString());
                }
                if (!attributes.isEmpty()) {
                    entityData.put("kv", attributes);
                    entityData.put("scope", scope);
                    JsonNode body = JacksonUtil.valueToTree(entityData);
                    log.debug("[{}] Sending attributes data msg, entityId [{}], attributes [{}]", new Object[]{tenantId, entityId, body});
                    future = this.saveEdgeEvent(tenantId, edge.getId(), entityType, EdgeEventActionType.ATTRIBUTES_UPDATED, entityId, body);
                } else {
                    future = Futures.immediateFuture(null);
                }
            }
            return Futures.transformAsync((ListenableFuture)future, v -> this.processLatestTimeseriesAndAddToEdgeQueue(tenantId, entityId, edge, entityType), (Executor)((Object)this.dbCallbackExecutorService));
        }
        catch (Exception e) {
            String errMsg = String.format("[%s][%s] Failed to save attribute updates to the edge [%s], scope = %s, entityData = %s, attributes = %s", tenantId, edge.getId(), attributesRequestMsg, scope, entityData, attributes);
            log.error(errMsg, (Throwable)e);
            return Futures.immediateFailedFuture((Throwable)new RuntimeException(errMsg, e));
        }
    }

    private ListenableFuture<Void> processLatestTimeseriesAndAddToEdgeQueue(TenantId tenantId, EntityId entityId, Edge edge, EdgeEventType entityType) {
        ListenableFuture getAllLatestFuture = this.timeseriesService.findAllLatest(tenantId, entityId);
        return Futures.transformAsync((ListenableFuture)getAllLatestFuture, tsKvEntries -> {
            if (tsKvEntries == null || tsKvEntries.isEmpty()) {
                log.trace("[{}][{}] No timeseries found for entity {} [{}]", new Object[]{tenantId, edge.getName(), entityId.getEntityType(), entityId.getId()});
                return Futures.immediateFuture(null);
            }
            HashMap<Long, Map> tsData = new HashMap<Long, Map>();
            for (TsKvEntry tsKvEntry : tsKvEntries) {
                if (DefaultDeviceStateService.ACTIVITY_KEYS_WITH_INACTIVITY_TIMEOUT.contains(tsKvEntry.getKey())) continue;
                tsData.computeIfAbsent(tsKvEntry.getTs(), k -> new HashMap()).put(tsKvEntry.getKey(), tsKvEntry.getValue());
            }
            ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
            for (Map.Entry entry : tsData.entrySet()) {
                HashMap<String, Object> entityBody = new HashMap<String, Object>();
                entityBody.put("data", entry.getValue());
                entityBody.put("ts", entry.getKey());
                futures.add(this.saveEdgeEvent(tenantId, edge.getId(), entityType, EdgeEventActionType.TIMESERIES_UPDATED, entityId, JacksonUtil.valueToTree(entityBody)));
            }
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), v -> null, (Executor)((Object)this.dbCallbackExecutorService));
        }, (Executor)((Object)this.dbCallbackExecutorService));
    }

    @Override
    public ListenableFuture<Void> processRelationRequestMsg(final TenantId tenantId, final Edge edge, final RelationRequestMsg relationRequestMsg) {
        log.trace("[{}] processRelationRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), relationRequestMsg});
        final EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)relationRequestMsg.getEntityType()), (UUID)new UUID(relationRequestMsg.getEntityIdMSB(), relationRequestMsg.getEntityIdLSB()));
        ArrayList<ListenableFuture<List<EntityRelation>>> futures = new ArrayList<ListenableFuture<List<EntityRelation>>>();
        futures.add(this.findRelationByQuery(tenantId, edge, entityId, EntitySearchDirection.FROM));
        futures.add(this.findRelationByQuery(tenantId, edge, entityId, EntitySearchDirection.TO));
        ListenableFuture relationsListFuture = Futures.allAsList(futures);
        final SettableFuture futureToSet = SettableFuture.create();
        Futures.addCallback((ListenableFuture)relationsListFuture, (FutureCallback)new FutureCallback<List<List<EntityRelation>>>(){

            public void onSuccess(@Nullable List<List<EntityRelation>> relationsList) {
                try {
                    if (relationsList != null && !relationsList.isEmpty()) {
                        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
                        for (List<EntityRelation> entityRelations : relationsList) {
                            if (entityRelations.isEmpty()) continue;
                            log.trace("[{}][{}][{}][{}] relation(s) are going to be pushed to edge.", new Object[]{tenantId, edge.getId(), entityId, entityRelations.size()});
                            for (EntityRelation relation : entityRelations) {
                                try {
                                    if (relation.getFrom().getEntityType().equals((Object)EntityType.EDGE) || relation.getTo().getEntityType().equals((Object)EntityType.EDGE)) continue;
                                    futures.add(DefaultEdgeRequestsService.this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.RELATION, EdgeEventActionType.ADDED, null, JacksonUtil.valueToTree((Object)relation)));
                                }
                                catch (Exception e) {
                                    String errMsg = String.format("[%s][%s] Exception during loading relation [%s] to edge on sync!", tenantId, edge.getId(), relation);
                                    log.error(errMsg, (Throwable)e);
                                    futureToSet.setException((Throwable)new RuntimeException(errMsg, e));
                                    return;
                                }
                            }
                        }
                        if (futures.isEmpty()) {
                            futureToSet.set(null);
                        } else {
                            Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new FutureCallback<List<Void>>(){

                                public void onSuccess(@Nullable List<Void> voids) {
                                    futureToSet.set(null);
                                }

                                public void onFailure(Throwable throwable) {
                                    String errMsg = String.format("[%s][%s] Exception during saving edge events [%s]!", tenantId, edge.getId(), relationRequestMsg);
                                    log.error(errMsg, throwable);
                                    futureToSet.setException((Throwable)new RuntimeException(errMsg, throwable));
                                }
                            }, (Executor)((Object)DefaultEdgeRequestsService.this.dbCallbackExecutorService));
                        }
                    } else {
                        futureToSet.set(null);
                    }
                }
                catch (Exception e) {
                    log.error("[{}] Exception during loading relation(s) to edge on sync!", (Object)tenantId, (Object)e);
                    futureToSet.setException((Throwable)e);
                }
            }

            public void onFailure(Throwable t) {
                String errMsg = String.format("[%s] Can't find relation by query. Entity id [%s]!", tenantId, entityId);
                log.error(errMsg, t);
                futureToSet.setException((Throwable)new RuntimeException(errMsg, t));
            }
        }, (Executor)((Object)this.dbCallbackExecutorService));
        return futureToSet;
    }

    @Override
    public ListenableFuture<Void> processCalculatedFieldRequestMsg(TenantId tenantId, Edge edge, CalculatedFieldRequestMsg calculatedFieldRequestMsg) {
        log.trace("[{}] processCalculatedFieldRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), calculatedFieldRequestMsg});
        EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)calculatedFieldRequestMsg.getEntityType()), (UUID)new UUID(calculatedFieldRequestMsg.getEntityIdMSB(), calculatedFieldRequestMsg.getEntityIdLSB()));
        log.trace("[{}] processCalculatedField [{}][{}] for entity [{}][{}]", new Object[]{tenantId, edge.getName(), calculatedFieldRequestMsg, entityId.getEntityType(), entityId.getId()});
        return this.saveCalculatedFieldsToEdge(tenantId, edge.getId(), entityId);
    }

    private ListenableFuture<Void> saveCalculatedFieldsToEdge(TenantId tenantId, EdgeId edgeId, EntityId entityId) {
        return Futures.transformAsync((ListenableFuture)this.dbCallbackExecutorService.submit(() -> this.calculatedFieldService.findCalculatedFieldsByEntityId(tenantId, entityId)), calculatedFields -> {
            log.trace("[{}][{}][{}][{}] calculatedField(s) are going to be pushed to edge.", new Object[]{tenantId, edgeId, entityId, calculatedFields.size()});
            List<ListenableFuture> futures = calculatedFields.stream().map(calculatedField -> {
                try {
                    return this.saveEdgeEvent(tenantId, edgeId, EdgeEventType.CALCULATED_FIELD, EdgeEventActionType.ADDED, (EntityId)calculatedField.getId(), JacksonUtil.valueToTree((Object)calculatedField));
                }
                catch (Exception e) {
                    log.error("[{}][{}] Exception during loading calculatedField [{}] to edge on sync!", new Object[]{tenantId, edgeId, calculatedField, e});
                    return Futures.immediateFailedFuture((Throwable)e);
                }
            }).toList();
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
        }, (Executor)((Object)this.dbCallbackExecutorService));
    }

    private ListenableFuture<List<EntityRelation>> findRelationByQuery(TenantId tenantId, Edge edge, EntityId entityId, EntitySearchDirection direction) {
        EntityRelationsQuery query = new EntityRelationsQuery();
        query.setParameters(new RelationsSearchParameters(entityId, direction, 1, false));
        return this.relationService.findByQuery(tenantId, query);
    }

    @Override
    public ListenableFuture<Void> processDeviceCredentialsRequestMsg(TenantId tenantId, Edge edge, DeviceCredentialsRequestMsg deviceCredentialsRequestMsg) {
        log.trace("[{}] processDeviceCredentialsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), deviceCredentialsRequestMsg});
        if (deviceCredentialsRequestMsg.getDeviceIdMSB() == 0L || deviceCredentialsRequestMsg.getDeviceIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        DeviceId deviceId = new DeviceId(new UUID(deviceCredentialsRequestMsg.getDeviceIdMSB(), deviceCredentialsRequestMsg.getDeviceIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.DEVICE, EdgeEventActionType.CREDENTIALS_UPDATED, (EntityId)deviceId, null);
    }

    @Override
    public ListenableFuture<Void> processUserCredentialsRequestMsg(TenantId tenantId, Edge edge, UserCredentialsRequestMsg userCredentialsRequestMsg) {
        log.trace("[{}] processUserCredentialsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), userCredentialsRequestMsg});
        if (userCredentialsRequestMsg.getUserIdMSB() == 0L || userCredentialsRequestMsg.getUserIdLSB() == 0L) {
            return Futures.immediateFuture(null);
        }
        UserId userId = new UserId(new UUID(userCredentialsRequestMsg.getUserIdMSB(), userCredentialsRequestMsg.getUserIdLSB()));
        return this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.USER, EdgeEventActionType.CREDENTIALS_UPDATED, (EntityId)userId, null);
    }

    @Override
    public ListenableFuture<Void> processWidgetBundleTypesRequestMsg(TenantId tenantId, Edge edge, WidgetBundleTypesRequestMsg widgetBundleTypesRequestMsg) {
        WidgetsBundleId widgetsBundleId;
        WidgetsBundle widgetsBundleById;
        log.trace("[{}] processWidgetBundleTypesRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), widgetBundleTypesRequestMsg});
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        if (widgetBundleTypesRequestMsg.getWidgetBundleIdMSB() != 0L && widgetBundleTypesRequestMsg.getWidgetBundleIdLSB() != 0L && (widgetsBundleById = this.widgetsBundleService.findWidgetsBundleById(tenantId, widgetsBundleId = new WidgetsBundleId(new UUID(widgetBundleTypesRequestMsg.getWidgetBundleIdMSB(), widgetBundleTypesRequestMsg.getWidgetBundleIdLSB())))) != null) {
            List widgetTypesToPush = this.widgetTypeService.findWidgetTypesByWidgetsBundleId(widgetsBundleById.getTenantId(), widgetsBundleId);
            for (WidgetType widgetType : widgetTypesToPush) {
                futures.add(this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.WIDGET_TYPE, EdgeEventActionType.ADDED, (EntityId)widgetType.getId(), null));
            }
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
    }

    @Override
    public ListenableFuture<Void> processEntityViewsRequestMsg(final TenantId tenantId, final Edge edge, EntityViewsRequestMsg entityViewsRequestMsg) {
        log.trace("[{}] processEntityViewsRequestMsg [{}][{}]", new Object[]{tenantId, edge.getName(), entityViewsRequestMsg});
        final EntityId entityId = EntityIdFactory.getByTypeAndUuid((EntityType)EntityType.valueOf((String)entityViewsRequestMsg.getEntityType()), (UUID)new UUID(entityViewsRequestMsg.getEntityIdMSB(), entityViewsRequestMsg.getEntityIdLSB()));
        final SettableFuture futureToSet = SettableFuture.create();
        Futures.addCallback(this.entityViewService.findEntityViewsByTenantIdAndEntityIdAsync(tenantId, entityId), (FutureCallback)new FutureCallback<List<EntityView>>(){

            public void onSuccess(@Nullable List<EntityView> entityViews) {
                if (entityViews == null || entityViews.isEmpty()) {
                    futureToSet.set(null);
                    return;
                }
                ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
                for (EntityView entityView : entityViews) {
                    ListenableFuture future = DefaultEdgeRequestsService.this.relationService.checkRelationAsync(tenantId, (EntityId)edge.getId(), (EntityId)entityView.getId(), "Contains", RelationTypeGroup.EDGE);
                    futures.add(Futures.transformAsync((ListenableFuture)future, result -> {
                        if (Boolean.TRUE.equals(result)) {
                            return DefaultEdgeRequestsService.this.saveEdgeEvent(tenantId, edge.getId(), EdgeEventType.ENTITY_VIEW, EdgeEventActionType.ADDED, (EntityId)entityView.getId(), null);
                        }
                        return Futures.immediateFuture(null);
                    }, (Executor)((Object)DefaultEdgeRequestsService.this.dbCallbackExecutorService)));
                }
                Futures.addCallback((ListenableFuture)Futures.allAsList(futures), (FutureCallback)new FutureCallback<List<Void>>(){

                    public void onSuccess(@Nullable List<Void> result) {
                        futureToSet.set(null);
                    }

                    public void onFailure(Throwable t) {
                        log.error("[{}] Exception during loading relation to edge on sync!", (Object)tenantId, (Object)t);
                        futureToSet.setException(t);
                    }
                }, (Executor)((Object)DefaultEdgeRequestsService.this.dbCallbackExecutorService));
            }

            public void onFailure(Throwable t) {
                log.error("[{}] Can't find entity views by entity id [{}]", new Object[]{tenantId, entityId, t});
                futureToSet.setException(t);
            }
        }, (Executor)((Object)this.dbCallbackExecutorService));
        return futureToSet;
    }

    private ListenableFuture<Void> saveEdgeEvent(TenantId tenantId, EdgeId edgeId, EdgeEventType type, EdgeEventActionType action, EntityId entityId, JsonNode body) {
        log.trace("Pushing edge event to edge queue. tenantId [{}], edgeId [{}], type [{}], action[{}], entityId [{}], body [{}]", new Object[]{tenantId, edgeId, type, action, entityId, body});
        EdgeEvent edgeEvent = EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edgeId, (EdgeEventType)type, (EdgeEventActionType)action, (EntityId)entityId, (JsonNode)body);
        return this.edgeEventService.saveAsync(edgeEvent);
    }
}

