/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.relation;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.server.gen.edge.v1.RelationUpdateMsg;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

public abstract class BaseRelationProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseRelationProcessor.class);

    protected ListenableFuture<Void> processRelationMsg(TenantId tenantId, RelationUpdateMsg relationUpdateMsg) {
        log.trace("[{}] processRelationMsg [{}]", (Object)tenantId, (Object)relationUpdateMsg);
        try {
            EntityRelation entityRelation = (EntityRelation)JacksonUtil.fromString((String)relationUpdateMsg.getEntity(), EntityRelation.class, (boolean)true);
            if (entityRelation == null) {
                throw new RuntimeException("[{" + String.valueOf(tenantId) + "}] relationUpdateMsg {" + String.valueOf(relationUpdateMsg) + "} cannot be converted to entity relation");
            }
            switch (relationUpdateMsg.getMsgType()) {
                case ENTITY_CREATED_RPC_MESSAGE: 
                case ENTITY_UPDATED_RPC_MESSAGE: {
                    if (this.isEntityExists(tenantId, entityRelation.getTo()) && this.isEntityExists(tenantId, entityRelation.getFrom())) {
                        this.edgeCtx.getRelationService().saveRelation(tenantId, entityRelation);
                        break;
                    }
                    log.warn("[{}] Skipping relating update msg because from/to entity doesn't exists on edge, {}", (Object)tenantId, (Object)relationUpdateMsg);
                    break;
                }
                case ENTITY_DELETED_RPC_MESSAGE: {
                    this.edgeCtx.getRelationService().deleteRelation(tenantId, entityRelation);
                    break;
                }
                default: {
                    return this.handleUnsupportedMsgType(relationUpdateMsg.getMsgType());
                }
            }
        }
        catch (Exception e) {
            log.error("[{}] Failed to process relation update msg [{}]", new Object[]{tenantId, relationUpdateMsg, e});
            return Futures.immediateFailedFuture((Throwable)e);
        }
        return Futures.immediateFuture(null);
    }
}

