/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.processor.customer;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.EntityIdFactory;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.gen.edge.v1.CustomerUpdateMsg;
import org.thingsboard.server.gen.edge.v1.DownlinkMsg;
import org.thingsboard.server.gen.edge.v1.EdgeVersion;
import org.thingsboard.server.gen.edge.v1.UpdateMsgType;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.EdgeMsgConstructorUtils;
import org.thingsboard.server.service.edge.rpc.processor.BaseEdgeProcessor;

@Component
@TbCoreComponent
public class CustomerEdgeProcessor
extends BaseEdgeProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomerEdgeProcessor.class);

    @Override
    public DownlinkMsg convertEdgeEventToDownlink(EdgeEvent edgeEvent, EdgeVersion edgeVersion) {
        CustomerId customerId = new CustomerId(edgeEvent.getEntityId());
        switch (edgeEvent.getAction()) {
            case ADDED: 
            case UPDATED: {
                Customer customer = this.edgeCtx.getCustomerService().findCustomerById(edgeEvent.getTenantId(), customerId);
                if (customer == null) break;
                UpdateMsgType msgType = this.getUpdateMsgType(edgeEvent.getAction());
                CustomerUpdateMsg customerUpdateMsg = EdgeMsgConstructorUtils.constructCustomerUpdatedMsg(msgType, customer);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addCustomerUpdateMsg(customerUpdateMsg).build();
            }
            case DELETED: {
                CustomerUpdateMsg customerUpdateMsg = EdgeMsgConstructorUtils.constructCustomerDeleteMsg(customerId);
                return DownlinkMsg.newBuilder().setDownlinkMsgId(EdgeUtils.nextPositiveInt()).addCustomerUpdateMsg(customerUpdateMsg).build();
            }
        }
        return null;
    }

    @Override
    public ListenableFuture<Void> processEntityNotification(TenantId tenantId, TransportProtos.EdgeNotificationMsgProto edgeNotificationMsg) {
        EdgeEventActionType actionType = EdgeEventActionType.valueOf((String)edgeNotificationMsg.getAction());
        EdgeEventType type = EdgeEventType.valueOf((String)edgeNotificationMsg.getType());
        UUID uuid = new UUID(edgeNotificationMsg.getEntityIdMSB(), edgeNotificationMsg.getEntityIdLSB());
        CustomerId customerId = new CustomerId(EntityIdFactory.getByEdgeEventTypeAndUuid((EdgeEventType)type, (UUID)uuid).getId());
        switch (actionType) {
            case ADDED: {
                Customer customerById = this.edgeCtx.getCustomerService().findCustomerById(tenantId, customerId);
                if (customerById != null && customerById.isPublic()) {
                    return this.findEdgesAndSaveEdgeEvents((PageDataIterable.FetchFunction<Edge>)((PageDataIterable.FetchFunction)link -> this.edgeCtx.getEdgeService().findEdgesByTenantId(tenantId, link)), tenantId, type, actionType, customerId);
                }
                return Futures.immediateFuture(null);
            }
            case UPDATED: {
                return this.findEdgesAndSaveEdgeEvents((PageDataIterable.FetchFunction<Edge>)((PageDataIterable.FetchFunction)link -> this.edgeCtx.getEdgeService().findEdgesByTenantIdAndCustomerId(tenantId, customerId, link)), tenantId, type, actionType, customerId);
            }
            case DELETED: {
                EdgeId edgeId = new EdgeId(new UUID(edgeNotificationMsg.getEdgeIdMSB(), edgeNotificationMsg.getEdgeIdLSB()));
                return this.saveEdgeEvent(tenantId, edgeId, type, actionType, (EntityId)customerId, null);
            }
        }
        return Futures.immediateFuture(null);
    }

    public ListenableFuture<Void> findEdgesAndSaveEdgeEvents(PageDataIterable.FetchFunction<Edge> edgeFetcher, TenantId tenantId, EdgeEventType type, EdgeEventActionType actionType, CustomerId customerId) {
        ArrayList<ListenableFuture<Void>> futures = new ArrayList<ListenableFuture<Void>>();
        PageDataIterable edges = new PageDataIterable(edgeFetcher, 1024);
        for (Edge edge : edges) {
            futures.add(this.saveEdgeEvent(tenantId, edge.getId(), type, actionType, (EntityId)customerId, null));
        }
        return Futures.transform((ListenableFuture)Futures.allAsList(futures), voids -> null, (Executor)((Object)this.dbCallbackExecutorService));
    }

    @Override
    public EdgeEventType getEdgeEventType() {
        return EdgeEventType.CUSTOMER;
    }
}

