/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc.fetch;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.EdgeUtils;
import org.thingsboard.server.common.data.EntityView;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeEvent;
import org.thingsboard.server.common.data.edge.EdgeEventActionType;
import org.thingsboard.server.common.data.edge.EdgeEventType;
import org.thingsboard.server.common.data.id.EdgeId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.entityview.EntityViewService;
import org.thingsboard.server.service.edge.rpc.fetch.BasePageableEdgeEventFetcher;

public class EntityViewsEdgeEventFetcher
extends BasePageableEdgeEventFetcher<EntityView> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityViewsEdgeEventFetcher.class);
    private final EntityViewService entityViewService;

    @Override
    PageData<EntityView> fetchEntities(TenantId tenantId, Edge edge, PageLink pageLink) {
        return this.entityViewService.findEntityViewsByTenantIdAndEdgeId(tenantId, edge.getId(), pageLink);
    }

    @Override
    EdgeEvent constructEdgeEvent(TenantId tenantId, Edge edge, EntityView entityView) {
        return EdgeUtils.constructEdgeEvent((TenantId)tenantId, (EdgeId)edge.getId(), (EdgeEventType)EdgeEventType.ENTITY_VIEW, (EdgeEventActionType)EdgeEventActionType.ADDED, (EntityId)entityView.getId(), null);
    }

    @ConstructorProperties(value={"entityViewService"})
    @Generated
    public EntityViewsEdgeEventFetcher(EntityViewService entityViewService) {
        this.entityViewService = entityViewService;
    }
}

