/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.rpc;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.Generated;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.service.edge.EdgeContextComponent;
import org.thingsboard.server.service.edge.rpc.fetch.AdminSettingsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.AssetProfilesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.AssetsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.CustomerEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.CustomerUsersEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.DashboardsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.DefaultProfilesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.DeviceProfilesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.DevicesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.EdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.EntityViewsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.NotificationRuleEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.NotificationTargetEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.NotificationTemplateEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.OAuth2EdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.OtaPackagesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.QueuesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.RuleChainsEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.SystemWidgetTypesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.SystemWidgetsBundlesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantAdminUsersEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantResourcesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantWidgetTypesEdgeEventFetcher;
import org.thingsboard.server.service.edge.rpc.fetch.TenantWidgetsBundlesEdgeEventFetcher;

public class EdgeSyncCursor {
    private final List<EdgeEventFetcher> fetchers = new LinkedList<EdgeEventFetcher>();
    private int currentIdx = 0;

    public EdgeSyncCursor(EdgeContextComponent ctx, Edge edge, boolean fullSync) {
        Customer publicCustomer;
        if (fullSync) {
            this.fetchers.add(new TenantEdgeEventFetcher(ctx.getTenantService()));
            this.fetchers.add(new QueuesEdgeEventFetcher(ctx.getQueueService()));
            this.fetchers.add(new RuleChainsEdgeEventFetcher(ctx.getRuleChainService()));
            this.fetchers.add(new AdminSettingsEdgeEventFetcher(ctx.getAdminSettingsService()));
            this.fetchers.add(new TenantAdminUsersEdgeEventFetcher(ctx.getUserService()));
        }
        if ((publicCustomer = ctx.getCustomerService().findPublicCustomer(edge.getTenantId())) != null) {
            this.fetchers.add(new CustomerEdgeEventFetcher(publicCustomer.getId()));
        }
        if (edge.getCustomerId() != null && !EntityId.NULL_UUID.equals(edge.getCustomerId().getId())) {
            this.fetchers.add(new CustomerEdgeEventFetcher(edge.getCustomerId()));
            this.fetchers.add(new CustomerUsersEdgeEventFetcher(ctx.getUserService(), edge.getCustomerId()));
        }
        this.fetchers.add(new DashboardsEdgeEventFetcher(ctx.getDashboardService()));
        this.fetchers.add(new DefaultProfilesEdgeEventFetcher(ctx.getDeviceProfileService(), ctx.getAssetProfileService()));
        this.fetchers.add(new DeviceProfilesEdgeEventFetcher(ctx.getDeviceProfileService()));
        this.fetchers.add(new AssetProfilesEdgeEventFetcher(ctx.getAssetProfileService()));
        this.fetchers.add(new DevicesEdgeEventFetcher(ctx.getDeviceService()));
        this.fetchers.add(new AssetsEdgeEventFetcher(ctx.getAssetService()));
        this.fetchers.add(new EntityViewsEdgeEventFetcher(ctx.getEntityViewService()));
        if (fullSync) {
            this.fetchers.add(new NotificationTemplateEdgeEventFetcher(ctx.getNotificationTemplateService()));
            this.fetchers.add(new NotificationTargetEdgeEventFetcher(ctx.getNotificationTargetService()));
            this.fetchers.add(new NotificationRuleEdgeEventFetcher(ctx.getNotificationRuleService()));
            this.fetchers.add(new SystemWidgetTypesEdgeEventFetcher(ctx.getWidgetTypeService()));
            this.fetchers.add(new TenantWidgetTypesEdgeEventFetcher(ctx.getWidgetTypeService()));
            this.fetchers.add(new SystemWidgetsBundlesEdgeEventFetcher(ctx.getWidgetsBundleService()));
            this.fetchers.add(new TenantWidgetsBundlesEdgeEventFetcher(ctx.getWidgetsBundleService()));
            this.fetchers.add(new OtaPackagesEdgeEventFetcher(ctx.getOtaPackageService()));
            this.fetchers.add(new DeviceProfilesEdgeEventFetcher(ctx.getDeviceProfileService()));
            this.fetchers.add(new TenantResourcesEdgeEventFetcher(ctx.getResourceService()));
            this.fetchers.add(new OAuth2EdgeEventFetcher(ctx.getDomainService()));
        }
    }

    public boolean hasNext() {
        return this.fetchers.size() > this.currentIdx;
    }

    public EdgeEventFetcher getNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        EdgeEventFetcher edgeEventFetcher = this.fetchers.get(this.currentIdx);
        ++this.currentIdx;
        return edgeEventFetcher;
    }

    @Generated
    public int getCurrentIdx() {
        return this.currentIdx;
    }
}

