/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.edge.instructions;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.edge.Edge;
import org.thingsboard.server.common.data.edge.EdgeInstructions;
import org.thingsboard.server.dao.util.DeviceConnectivityUtil;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.edge.instructions.BaseEdgeInstallUpgradeInstructionsService;
import org.thingsboard.server.service.edge.instructions.EdgeInstallInstructionsService;
import org.thingsboard.server.service.install.InstallScripts;

@Service
@ConditionalOnProperty(prefix="edges", value={"enabled"}, havingValue="true")
@TbCoreComponent
public class DefaultEdgeInstallInstructionsService
extends BaseEdgeInstallUpgradeInstructionsService
implements EdgeInstallInstructionsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultEdgeInstallInstructionsService.class);
    private static final String INSTALL_DIR = "install";
    @Value(value="${edges.rpc.port}")
    private int rpcPort;
    @Value(value="${edges.rpc.ssl.enabled}")
    private boolean sslEnabled;

    public DefaultEdgeInstallInstructionsService(InstallScripts installScripts) {
        super(installScripts);
    }

    @Override
    public EdgeInstructions getInstallInstructions(Edge edge, String installationMethod, HttpServletRequest request) {
        return switch (installationMethod.toLowerCase()) {
            case "docker" -> this.getDockerInstallInstructions(edge, request);
            case "ubuntu", "centos" -> this.getLinuxInstallInstructions(edge, request, installationMethod.toLowerCase());
            default -> throw new IllegalArgumentException("Unsupported installation method for Edge: " + installationMethod);
        };
    }

    private EdgeInstructions getDockerInstallInstructions(Edge edge, HttpServletRequest request) {
        String dockerInstallInstructions = this.readFile(this.resolveFile("docker", "instructions.md"));
        String baseUrl = request.getServerName();
        if (DeviceConnectivityUtil.isLocalhost((String)baseUrl)) {
            dockerInstallInstructions = dockerInstallInstructions.replace("${EXTRA_HOSTS}", "extra_hosts:\n      - \"host.docker.internal:host-gateway\"\n");
            dockerInstallInstructions = dockerInstallInstructions.replace("${BASE_URL}", "host.docker.internal");
        } else {
            dockerInstallInstructions = dockerInstallInstructions.replace("${EXTRA_HOSTS}", "");
            dockerInstallInstructions = dockerInstallInstructions.replace("${BASE_URL}", baseUrl);
        }
        Object edgeVersion = this.appVersion + "EDGE";
        edgeVersion = ((String)edgeVersion).replace("-SNAPSHOT", "");
        dockerInstallInstructions = dockerInstallInstructions.replace("${TB_EDGE_VERSION}", (CharSequence)edgeVersion);
        dockerInstallInstructions = this.replacePlaceholders(dockerInstallInstructions, edge);
        return new EdgeInstructions(dockerInstallInstructions);
    }

    private EdgeInstructions getLinuxInstallInstructions(Edge edge, HttpServletRequest request, String os) {
        String ubuntuInstallInstructions = this.readFile(this.resolveFile(os, "instructions.md"));
        ubuntuInstallInstructions = this.replacePlaceholders(ubuntuInstallInstructions, edge);
        ubuntuInstallInstructions = ubuntuInstallInstructions.replace("${BASE_URL}", request.getServerName());
        String edgeVersion = this.appVersion.replace("-SNAPSHOT", "");
        ubuntuInstallInstructions = ubuntuInstallInstructions.replace("${TB_EDGE_VERSION}", edgeVersion);
        ubuntuInstallInstructions = ubuntuInstallInstructions.replace("${TB_EDGE_TAG}", this.getTagVersion(edgeVersion));
        return new EdgeInstructions(ubuntuInstallInstructions);
    }

    private String replacePlaceholders(String instructions, Edge edge) {
        instructions = instructions.replace("${CLOUD_ROUTING_KEY}", edge.getRoutingKey());
        instructions = instructions.replace("${CLOUD_ROUTING_SECRET}", edge.getSecret());
        instructions = instructions.replace("${CLOUD_RPC_PORT}", Integer.toString(this.rpcPort));
        instructions = instructions.replace("${CLOUD_RPC_SSL_ENABLED}", Boolean.toString(this.sslEnabled));
        return instructions;
    }

    @Override
    protected String getBaseDirName() {
        return INSTALL_DIR;
    }
}

