/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.component;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.annotation.PostConstruct;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.rule.engine.api.NodeConfiguration;
import org.thingsboard.rule.engine.api.NodeDefinition;
import org.thingsboard.rule.engine.api.RuleNode;
import org.thingsboard.rule.engine.filter.TbMsgTypeSwitchNode;
import org.thingsboard.rule.engine.filter.TbOriginatorTypeSwitchNode;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.plugin.ComponentDescriptor;
import org.thingsboard.server.common.data.plugin.ComponentType;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.dao.component.ComponentDescriptorService;
import org.thingsboard.server.service.component.ComponentDiscoveryService;
import org.thingsboard.server.service.component.RuleNodeClassInfo;

@Service
public class AnnotationComponentDiscoveryService
implements ComponentDiscoveryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotationComponentDiscoveryService.class);
    public static final int MAX_OPTIMISITC_RETRIES = 3;
    @Value(value="${plugins.scan_packages}")
    private String[] scanPackages;
    @Autowired
    private Environment environment;
    @Autowired
    private ComponentDescriptorService componentDescriptorService;
    private final Map<String, RuleNodeClassInfo> ruleNodeClasses = new HashMap<String, RuleNodeClassInfo>();
    private final Map<String, ComponentDescriptor> components = new HashMap<String, ComponentDescriptor>();
    private final Map<ComponentType, List<ComponentDescriptor>> coreComponentsMap = new HashMap<ComponentType, List<ComponentDescriptor>>();
    private final Map<ComponentType, List<ComponentDescriptor>> edgeComponentsMap = new HashMap<ComponentType, List<ComponentDescriptor>>();

    private boolean isInstall() {
        return this.environment.acceptsProfiles(Profiles.of((String[])new String[]{"install"}));
    }

    @PostConstruct
    public void init() {
        for (BeanDefinition def : this.discoverBeansByAnnotationType(RuleNode.class)) {
            String clazzName = def.getBeanClassName();
            try {
                Class<?> clazz = Class.forName(clazzName);
                RuleNode annotation = clazz.getAnnotation(RuleNode.class);
                this.ruleNodeClasses.put(clazzName, new RuleNodeClassInfo(clazz, annotation));
            }
            catch (Exception e) {
                log.warn("Failed to create instance of rule node type: {} due to: ", (Object)clazzName, (Object)e);
            }
        }
        if (!this.isInstall()) {
            this.discoverComponents();
        }
    }

    private Set<BeanDefinition> discoverBeansByAnnotationType(Class<? extends Annotation> annotationType) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
        HashSet<BeanDefinition> defs = new HashSet<BeanDefinition>();
        for (String scanPackage : this.scanPackages) {
            defs.addAll(scanner.findCandidateComponents(scanPackage));
        }
        return defs;
    }

    @Override
    public Optional<RuleNodeClassInfo> getRuleNodeInfo(String clazz) {
        return Optional.ofNullable(this.ruleNodeClasses.get(clazz));
    }

    @Override
    public List<RuleNodeClassInfo> getVersionedNodes() {
        return this.ruleNodeClasses.values().stream().filter(RuleNodeClassInfo::isVersioned).collect(Collectors.toList());
    }

    private void registerRuleNodeComponents() {
        for (RuleNodeClassInfo def : this.ruleNodeClasses.values()) {
            int retryCount;
            Throwable cause = null;
            for (retryCount = 0; retryCount < 3; ++retryCount) {
                try {
                    ComponentType type = def.getAnnotation().type();
                    ComponentDescriptor component = this.scanAndPersistComponent(def, type);
                    this.components.put(component.getClazz(), component);
                    this.putComponentIntoMaps(type, def.getAnnotation(), component);
                    break;
                }
                catch (Exception e) {
                    log.trace("Can't initialize component {}, due to {}", new Object[]{def.getClassName(), e.getMessage(), e});
                    cause = e;
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            }
            if (cause == null || retryCount != 3) continue;
            log.error("Can't initialize component {}, due to {}", new Object[]{def.getClassName(), cause.getMessage(), cause});
            throw new RuntimeException(cause);
        }
    }

    private void putComponentIntoMaps(ComponentType type, RuleNode ruleNodeAnnotation, ComponentDescriptor component) {
        boolean ruleChainTypesMethodAvailable;
        try {
            ruleNodeAnnotation.getClass().getMethod("ruleChainTypes", new Class[0]);
            ruleChainTypesMethodAvailable = true;
        }
        catch (NoSuchMethodException exception) {
            log.warn("[{}] does not have ruleChainTypes. Probably extension class compiled before 3.3 release. Please update your extensions and compile using latest 3.3 release dependency", (Object)ruleNodeAnnotation.name());
            ruleChainTypesMethodAvailable = false;
        }
        if (ruleChainTypesMethodAvailable) {
            if (this.ruleChainTypeContainsArray(RuleChainType.CORE, ruleNodeAnnotation.ruleChainTypes())) {
                this.coreComponentsMap.computeIfAbsent(type, k -> new ArrayList()).add(component);
            }
            if (this.ruleChainTypeContainsArray(RuleChainType.EDGE, ruleNodeAnnotation.ruleChainTypes())) {
                this.edgeComponentsMap.computeIfAbsent(type, k -> new ArrayList()).add(component);
            }
        } else {
            this.coreComponentsMap.computeIfAbsent(type, k -> new ArrayList()).add(component);
        }
    }

    private boolean ruleChainTypeContainsArray(RuleChainType ruleChainType, RuleChainType[] array) {
        for (RuleChainType tmp : array) {
            if (!ruleChainType.equals((Object)tmp)) continue;
            return true;
        }
        return false;
    }

    private ComponentDescriptor scanAndPersistComponent(RuleNodeClassInfo def, ComponentType type) {
        ComponentDescriptor scannedComponent = new ComponentDescriptor();
        String clazzName = def.getClassName();
        try {
            scannedComponent.setType(type);
            Class<?> clazz = def.getClazz();
            RuleNode ruleNodeAnnotation = clazz.getAnnotation(RuleNode.class);
            scannedComponent.setConfigurationVersion(def.getCurrentVersion());
            scannedComponent.setName(ruleNodeAnnotation.name());
            scannedComponent.setScope(ruleNodeAnnotation.scope());
            scannedComponent.setClusteringMode(ruleNodeAnnotation.clusteringMode());
            scannedComponent.setHasQueueName(ruleNodeAnnotation.hasQueueName());
            NodeDefinition nodeDefinition = this.prepareNodeDefinition(clazz, ruleNodeAnnotation);
            ObjectNode configurationDescriptor = JacksonUtil.newObjectNode();
            JsonNode node = JacksonUtil.valueToTree((Object)nodeDefinition);
            configurationDescriptor.set("nodeDefinition", node);
            scannedComponent.setConfigurationDescriptor((JsonNode)configurationDescriptor);
            scannedComponent.setClazz(clazzName);
            log.debug("Processing scanned component: {}", (Object)scannedComponent);
        }
        catch (Exception e) {
            log.error("Can't initialize component {}, due to {}", new Object[]{clazzName, e.getMessage(), e});
            throw new RuntimeException(e);
        }
        ComponentDescriptor persistedComponent = this.componentDescriptorService.findByClazz(TenantId.SYS_TENANT_ID, clazzName);
        if (persistedComponent == null) {
            log.debug("Persisting new component: {}", (Object)scannedComponent);
            scannedComponent = this.componentDescriptorService.saveComponent(TenantId.SYS_TENANT_ID, scannedComponent);
        } else if (scannedComponent.equals((Object)persistedComponent)) {
            log.debug("Component is already persisted: {}", (Object)persistedComponent);
            scannedComponent = persistedComponent;
        } else {
            log.debug("Component {} will be updated to {}", (Object)persistedComponent, (Object)scannedComponent);
            this.componentDescriptorService.deleteByClazz(TenantId.SYS_TENANT_ID, persistedComponent.getClazz());
            scannedComponent.setId((UUIDBased)persistedComponent.getId());
            scannedComponent = this.componentDescriptorService.saveComponent(TenantId.SYS_TENANT_ID, scannedComponent);
        }
        return scannedComponent;
    }

    private NodeDefinition prepareNodeDefinition(Class<?> clazz, RuleNode nodeAnnotation) throws Exception {
        NodeDefinition nodeDefinition = new NodeDefinition();
        nodeDefinition.setDetails(nodeAnnotation.nodeDetails());
        nodeDefinition.setDescription(nodeAnnotation.nodeDescription());
        nodeDefinition.setInEnabled(nodeAnnotation.inEnabled());
        nodeDefinition.setOutEnabled(nodeAnnotation.outEnabled());
        nodeDefinition.setRelationTypes(this.getRelationTypesWithFailureRelation(clazz, nodeAnnotation));
        nodeDefinition.setCustomRelations(nodeAnnotation.customRelations());
        nodeDefinition.setRuleChainNode(nodeAnnotation.ruleChainNode());
        Class configClazz = nodeAnnotation.configClazz();
        NodeConfiguration config = (NodeConfiguration)configClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        NodeConfiguration defaultConfiguration = config.defaultConfiguration();
        nodeDefinition.setDefaultConfiguration(JacksonUtil.valueToTree((Object)defaultConfiguration));
        nodeDefinition.setUiResources(nodeAnnotation.uiResources());
        nodeDefinition.setConfigDirective(nodeAnnotation.configDirective());
        nodeDefinition.setIcon(nodeAnnotation.icon());
        nodeDefinition.setIconUrl(nodeAnnotation.iconUrl());
        nodeDefinition.setDocUrl(nodeAnnotation.docUrl());
        return nodeDefinition;
    }

    private String[] getRelationTypesWithFailureRelation(Class<?> clazz, RuleNode nodeAnnotation) {
        ArrayList<String> relationTypes = new ArrayList<String>(Arrays.asList(nodeAnnotation.relationTypes()));
        if (TbOriginatorTypeSwitchNode.class.equals(clazz)) {
            relationTypes.addAll(EntityType.NORMAL_NAMES);
        }
        if (TbMsgTypeSwitchNode.class.equals(clazz)) {
            relationTypes.addAll(TbMsgType.NODE_CONNECTIONS);
            relationTypes.add("Other");
        }
        if (!relationTypes.contains("Failure")) {
            relationTypes.add("Failure");
        }
        return relationTypes.toArray(new String[relationTypes.size()]);
    }

    @Override
    public void discoverComponents() {
        this.registerRuleNodeComponents();
        log.debug("Found following definitions: {}", this.components.values());
    }

    @Override
    public List<ComponentDescriptor> getComponents(ComponentType type, RuleChainType ruleChainType) {
        if (RuleChainType.CORE.equals((Object)ruleChainType)) {
            if (this.coreComponentsMap.containsKey(type)) {
                return Collections.unmodifiableList(this.coreComponentsMap.get(type));
            }
            return Collections.emptyList();
        }
        if (RuleChainType.EDGE.equals((Object)ruleChainType)) {
            if (this.edgeComponentsMap.containsKey(type)) {
                return Collections.unmodifiableList(this.edgeComponentsMap.get(type));
            }
            return Collections.emptyList();
        }
        log.error("Unsupported rule chain type {}", (Object)ruleChainType);
        throw new RuntimeException("Unsupported rule chain type " + String.valueOf(ruleChainType));
    }

    @Override
    public List<ComponentDescriptor> getComponents(Set<ComponentType> types, RuleChainType ruleChainType) {
        if (RuleChainType.CORE.equals((Object)ruleChainType)) {
            return this.getComponents(types, this.coreComponentsMap);
        }
        if (RuleChainType.EDGE.equals((Object)ruleChainType)) {
            return this.getComponents(types, this.edgeComponentsMap);
        }
        log.error("Unsupported rule chain type {}", (Object)ruleChainType);
        throw new RuntimeException("Unsupported rule chain type " + String.valueOf(ruleChainType));
    }

    @Override
    public Optional<ComponentDescriptor> getComponent(String clazz) {
        return Optional.ofNullable(this.components.get(clazz));
    }

    private List<ComponentDescriptor> getComponents(Set<ComponentType> types, Map<ComponentType, List<ComponentDescriptor>> componentsMap) {
        ArrayList result = new ArrayList();
        types.stream().filter(componentsMap::containsKey).forEach(type -> result.addAll((Collection)componentsMap.get(type)));
        return Collections.unmodifiableList(result);
    }
}

