/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.cf.ctx.state;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.service.cf.CalculatedFieldResult;
import org.thingsboard.server.service.cf.ctx.CalculatedFieldEntityCtxId;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.ScriptCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SimpleCalculatedFieldState;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SimpleCalculatedFieldState.class, name="SIMPLE"), @JsonSubTypes.Type(value=ScriptCalculatedFieldState.class, name="SCRIPT")})
public interface CalculatedFieldState {
    @JsonIgnore
    public CalculatedFieldType getType();

    public Map<String, ArgumentEntry> getArguments();

    public long getLatestTimestamp();

    public void setRequiredArguments(List<String> var1);

    public boolean updateState(CalculatedFieldCtx var1, Map<String, ArgumentEntry> var2);

    public ListenableFuture<CalculatedFieldResult> performCalculation(CalculatedFieldCtx var1);

    @JsonIgnore
    public boolean isReady();

    public boolean isSizeExceedsLimit();

    @JsonIgnore
    default public boolean isSizeOk() {
        return !this.isSizeExceedsLimit();
    }

    public void checkStateSize(CalculatedFieldEntityCtxId var1, long var2);

    public void checkArgumentSize(String var1, ArgumentEntry var2, CalculatedFieldCtx var3);
}

