/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.trendz.TrendzSettings;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.trendz.TrendzSettingsService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api"})
public class TrendzController
extends BaseController {
    private final TrendzSettingsService trendzSettingsService;

    @ApiOperation(value="Save Trendz settings (saveTrendzSettings)", notes="Saves Trendz settings for this tenant.\n\n\nHere is an example of the Trendz settings:\n```json\n{\n  \"enabled\": true,\n  \"baseUrl\": \"https://some.domain.com:18888/also_necessary_prefix\"\n}\n```\n\nAvailable for users with 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/trendz/settings"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    public TrendzSettings saveTrendzSettings(@RequestBody TrendzSettings trendzSettings, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        this.accessControlService.checkPermission(user, Resource.ADMIN_SETTINGS, Operation.WRITE);
        TenantId tenantId = user.getTenantId();
        this.trendzSettingsService.saveTrendzSettings(tenantId, trendzSettings);
        return trendzSettings;
    }

    @ApiOperation(value="Get Trendz Settings (getTrendzSettings)", notes="Retrieves Trendz settings for this tenant.\n\nAvailable for users with 'TENANT_ADMIN' or 'CUSTOMER_USER' authority.")
    @GetMapping(value={"/trendz/settings"})
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    public TrendzSettings getTrendzSettings(@AuthenticationPrincipal SecurityUser user) {
        TenantId tenantId = user.getTenantId();
        return this.trendzSettingsService.findTrendzSettings(tenantId);
    }

    @ConstructorProperties(value={"trendzSettingsService"})
    @Generated
    public TrendzController(TrendzSettingsService trendzSettingsService) {
        this.trendzSettingsService = trendzSettingsService;
    }
}

