/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.controller;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.rule.engine.api.notification.SlackService;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.exception.ThingsboardException;
import org.thingsboard.server.common.data.id.NotificationTemplateId;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.notification.settings.NotificationSettings;
import org.thingsboard.server.common.data.notification.settings.SlackNotificationDeliveryMethodConfig;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversation;
import org.thingsboard.server.common.data.notification.targets.slack.SlackConversationType;
import org.thingsboard.server.common.data.notification.template.NotificationTemplate;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.config.annotations.ApiOperation;
import org.thingsboard.server.controller.BaseController;
import org.thingsboard.server.dao.notification.NotificationSettingsService;
import org.thingsboard.server.dao.notification.NotificationTemplateService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.security.permission.Operation;
import org.thingsboard.server.service.security.permission.Resource;

@RestController
@TbCoreComponent
@RequestMapping(value={"/api/notification"})
public class NotificationTemplateController
extends BaseController {
    private final NotificationTemplateService notificationTemplateService;
    private final NotificationSettingsService notificationSettingsService;
    private final SlackService slackService;

    @ApiOperation(value="Save notification template (saveNotificationTemplate)", notes="Creates or updates notification template.\n\nHere is an example of template to send notification via Web, SMS and Slack:\n```json\n{\n  \"name\": \"Greetings\",\n  \"notificationType\": \"GENERAL\",\n  \"configuration\": {\n    \"deliveryMethodsTemplates\": {\n      \"WEB\": {\n        \"enabled\": true,\n        \"subject\": \"Greetings\",\n        \"body\": \"Hi there, ${recipientTitle}\",\n        \"additionalConfig\": {\n          \"icon\": {\n            \"enabled\": true,\n            \"icon\": \"back_hand\",\n            \"color\": \"#757575\"\n          },\n          \"actionButtonConfig\": {\n            \"enabled\": false\n          }\n        },\n        \"method\": \"WEB\"\n      },\n      \"SMS\": {\n        \"enabled\": true,\n        \"body\": \"Hi there, ${recipientTitle}\",\n        \"method\": \"SMS\"\n      },\n      \"SLACK\": {\n        \"enabled\": true,\n        \"body\": \"Hi there, @${recipientTitle}\",\n        \"method\": \"SLACK\"\n      }\n    }\n  }\n}\n```\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @PostMapping(value={"/template"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationTemplate saveNotificationTemplate(@RequestBody @Valid NotificationTemplate notificationTemplate) throws Exception {
        notificationTemplate.setTenantId(this.getTenantId());
        this.checkEntity((NotificationTemplateId)notificationTemplate.getId(), notificationTemplate, Resource.NOTIFICATION);
        return this.doSaveAndLog(EntityType.NOTIFICATION_TEMPLATE, notificationTemplate, (arg_0, arg_1) -> ((NotificationTemplateService)this.notificationTemplateService).saveNotificationTemplate(arg_0, arg_1));
    }

    @ApiOperation(value="Get notification template by id (getNotificationTemplateById)", notes="Fetches notification template by id.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/template/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public NotificationTemplate getNotificationTemplateById(@PathVariable UUID id) throws ThingsboardException {
        NotificationTemplateId notificationTemplateId = new NotificationTemplateId(id);
        return (NotificationTemplate)this.checkEntityId(notificationTemplateId, (arg_0, arg_1) -> ((NotificationTemplateService)this.notificationTemplateService).findNotificationTemplateById(arg_0, arg_1), Operation.READ);
    }

    @ApiOperation(value="Get notification templates (getNotificationTemplates)", notes="Returns the page of notification templates owned by sysadmin or tenant.\n\nYou can specify parameters to filter the results. The result is wrapped with PageData object that allows you to iterate over result set using pagination. See response schema for more details. \n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/templates"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public PageData<NotificationTemplate> getNotificationTemplates(@Parameter(description="Maximum amount of entities in a one page", required=true) @RequestParam int pageSize, @Parameter(description="Sequence number of page starting from 0", required=true) @RequestParam int page, @Parameter(description="Case-insensitive 'substring' filter based on template's name and notification type") @RequestParam(required=false) String textSearch, @Parameter(description="Property of entity to sort by") @RequestParam(required=false) String sortProperty, @Parameter(description="Sort order. ASC (ASCENDING) or DESC (DESCENDING)") @RequestParam(required=false) String sortOrder, @Parameter(description="Comma-separated list of notification types to filter the templates", array=@ArraySchema(schema=@Schema(type="string"))) @RequestParam(required=false) NotificationType[] notificationTypes, @AuthenticationPrincipal SecurityUser user) throws ThingsboardException {
        PageLink pageLink = this.createPageLink(pageSize, page, textSearch, sortProperty, sortOrder);
        if (notificationTypes == null || notificationTypes.length == 0) {
            notificationTypes = NotificationType.values();
        }
        return this.notificationTemplateService.findNotificationTemplatesByTenantIdAndNotificationTypes(user.getTenantId(), List.of(notificationTypes), pageLink);
    }

    @ApiOperation(value="Delete notification template by id (deleteNotificationTemplateById", notes="Deletes notification template by its id.\n\nThis template cannot be referenced by existing scheduled notification requests or any notification rules.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @DeleteMapping(value={"/template/{id}"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public void deleteNotificationTemplateById(@PathVariable UUID id) throws Exception {
        NotificationTemplateId notificationTemplateId = new NotificationTemplateId(id);
        NotificationTemplate notificationTemplate = (NotificationTemplate)this.checkEntityId(notificationTemplateId, (arg_0, arg_1) -> ((NotificationTemplateService)this.notificationTemplateService).findNotificationTemplateById(arg_0, arg_1), Operation.DELETE);
        this.doDeleteAndLog(EntityType.NOTIFICATION_TEMPLATE, notificationTemplate, (arg_0, arg_1) -> ((NotificationTemplateService)this.notificationTemplateService).deleteNotificationTemplateById(arg_0, arg_1));
    }

    @ApiOperation(value="List Slack conversations (listSlackConversations)", notes="List available Slack conversations by type.\n\nAvailable for users with 'SYS_ADMIN' or 'TENANT_ADMIN' authority.")
    @GetMapping(value={"/slack/conversations"})
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public List<SlackConversation> listSlackConversations(@RequestParam SlackConversationType type, @Parameter(description="Slack bot token. If absent - system Slack settings will be used") @RequestParam(required=false) String token, @AuthenticationPrincipal SecurityUser user) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            NotificationSettings settings = this.notificationSettingsService.findNotificationSettings(user.getTenantId());
            SlackNotificationDeliveryMethodConfig slackConfig = (SlackNotificationDeliveryMethodConfig)settings.getDeliveryMethodsConfigs().get(NotificationDeliveryMethod.SLACK);
            if (slackConfig == null) {
                throw new IllegalArgumentException("Slack is not configured");
            }
            token = slackConfig.getBotToken();
        }
        return this.slackService.listConversations(user.getTenantId(), token, type);
    }

    @ConstructorProperties(value={"notificationTemplateService", "notificationSettingsService", "slackService"})
    @Generated
    public NotificationTemplateController(NotificationTemplateService notificationTemplateService, NotificationSettingsService notificationSettingsService, SlackService slackService) {
        this.notificationTemplateService = notificationTemplateService;
        this.notificationSettingsService = notificationSettingsService;
        this.slackService = slackService;
    }
}

