/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.config;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;
import org.thingsboard.server.controller.plugin.TbWebSocketHandler;
import org.thingsboard.server.queue.util.TbCoreComponent;

@Configuration
@TbCoreComponent
@EnableWebSocket
public class WebSocketConfiguration
implements WebSocketConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketConfiguration.class);
    public static final String WS_API_ENDPOINT = "/api/ws";
    public static final String WS_PLUGINS_ENDPOINT = "/api/ws/plugins/";
    private static final String WS_API_MAPPING = "/api/ws/**";
    private final WebSocketHandler wsHandler;

    @Bean
    public ServletServerContainerFactoryBean createWebSocketContainer() {
        ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
        container.setMaxTextMessageBufferSize(Integer.valueOf(32768));
        container.setMaxBinaryMessageBufferSize(Integer.valueOf(32768));
        return container;
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        if (!(this.wsHandler instanceof TbWebSocketHandler)) {
            log.error("TbWebSocketHandler expected but [{}] provided", (Object)this.wsHandler);
            throw new RuntimeException("TbWebSocketHandler expected but " + String.valueOf(this.wsHandler) + " provided");
        }
        registry.addHandler(this.wsHandler, new String[]{WS_API_MAPPING}).setAllowedOriginPatterns(new String[]{"*"});
    }

    @ConstructorProperties(value={"wsHandler"})
    @Generated
    public WebSocketConfiguration(WebSocketHandler wsHandler) {
        this.wsHandler = wsHandler;
    }
}

