/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.shared;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActor;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbEntityActorId;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.actors.service.ContextBasedCreator;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.aware.RuleChainAwareMsg;
import org.thingsboard.server.common.msg.queue.RuleEngineException;

public class RuleChainErrorActor
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleChainErrorActor.class);
    private final TenantId tenantId;
    private final RuleEngineException error;

    private RuleChainErrorActor(ActorSystemContext systemContext, TenantId tenantId, RuleEngineException error) {
        super(systemContext);
        this.tenantId = tenantId;
        this.error = error;
    }

    @Override
    protected boolean doProcess(TbActorMsg msg) {
        if (msg instanceof RuleChainAwareMsg) {
            RuleChainAwareMsg rcMsg = (RuleChainAwareMsg)msg;
            log.debug("[{}] Reply with {} for message {}", new Object[]{this.tenantId, this.error.getMessage(), msg});
            rcMsg.getMsg().getCallback().onFailure(this.error);
            return true;
        }
        return false;
    }

    public static class ActorCreator
    extends ContextBasedCreator {
        private final TenantId tenantId;
        private final RuleChainId ruleChainId;
        private final RuleEngineException error;

        public ActorCreator(ActorSystemContext context, TenantId tenantId, RuleChainId ruleChainId, RuleEngineException error) {
            super(context);
            this.tenantId = tenantId;
            this.ruleChainId = ruleChainId;
            this.error = error;
        }

        public TbActorId createActorId() {
            return new TbEntityActorId((EntityId)this.ruleChainId);
        }

        public TbActor createActor() {
            return new RuleChainErrorActor(this.context, this.tenantId, this.error);
        }
    }
}

