/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.ruleChain;

import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActor;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorId;
import org.thingsboard.server.actors.TbActorRef;
import org.thingsboard.server.actors.TbEntityActorId;
import org.thingsboard.server.actors.ruleChain.RuleChainActorMessageProcessor;
import org.thingsboard.server.actors.ruleChain.RuleChainInputMsg;
import org.thingsboard.server.actors.ruleChain.RuleChainOutputMsg;
import org.thingsboard.server.actors.ruleChain.RuleChainToRuleChainMsg;
import org.thingsboard.server.actors.ruleChain.RuleEngineComponentActor;
import org.thingsboard.server.actors.ruleChain.RuleNodeToRuleChainTellNextMsg;
import org.thingsboard.server.actors.service.ContextBasedCreator;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.plugin.ComponentLifecycleMsg;
import org.thingsboard.server.common.msg.queue.PartitionChangeMsg;
import org.thingsboard.server.common.msg.queue.QueueToRuleEngineMsg;

public class RuleChainActor
extends RuleEngineComponentActor<RuleChainId, RuleChainActorMessageProcessor> {
    private final RuleChain ruleChain;

    private RuleChainActor(ActorSystemContext systemContext, TenantId tenantId, RuleChain ruleChain) {
        super(systemContext, tenantId, ruleChain.getId());
        this.ruleChain = ruleChain;
    }

    @Override
    protected RuleChainActorMessageProcessor createProcessor(TbActorCtx ctx) {
        return new RuleChainActorMessageProcessor(this.tenantId, this.ruleChain, this.systemContext, ctx.getParentRef(), (TbActorRef)ctx);
    }

    @Override
    protected boolean doProcess(TbActorMsg msg) {
        switch (msg.getMsgType()) {
            case COMPONENT_LIFE_CYCLE_MSG: {
                this.onComponentLifecycleMsg((ComponentLifecycleMsg)msg);
                break;
            }
            case QUEUE_TO_RULE_ENGINE_MSG: {
                ((RuleChainActorMessageProcessor)this.processor).onQueueToRuleEngineMsg((QueueToRuleEngineMsg)msg);
                break;
            }
            case RULE_TO_RULE_CHAIN_TELL_NEXT_MSG: {
                ((RuleChainActorMessageProcessor)this.processor).onTellNext((RuleNodeToRuleChainTellNextMsg)msg);
                break;
            }
            case RULE_CHAIN_TO_RULE_CHAIN_MSG: {
                ((RuleChainActorMessageProcessor)this.processor).onRuleChainToRuleChainMsg((RuleChainToRuleChainMsg)msg);
                break;
            }
            case RULE_CHAIN_INPUT_MSG: {
                ((RuleChainActorMessageProcessor)this.processor).onRuleChainInputMsg((RuleChainInputMsg)msg);
                break;
            }
            case RULE_CHAIN_OUTPUT_MSG: {
                ((RuleChainActorMessageProcessor)this.processor).onRuleChainOutputMsg((RuleChainOutputMsg)msg);
                break;
            }
            case PARTITION_CHANGE_MSG: {
                ((RuleChainActorMessageProcessor)this.processor).onPartitionChangeMsg((PartitionChangeMsg)msg);
                break;
            }
            case STATS_PERSIST_TICK_MSG: {
                this.onStatsPersistTick(this.id);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected RuleChainId getRuleChainId() {
        return this.ruleChain.getId();
    }

    @Override
    protected String getRuleChainName() {
        return this.ruleChain.getName();
    }

    @Override
    protected long getErrorPersistFrequency() {
        return this.systemContext.getRuleChainErrorPersistFrequency();
    }

    public static class ActorCreator
    extends ContextBasedCreator {
        private static final long serialVersionUID = 1L;
        private final TenantId tenantId;
        private final RuleChain ruleChain;

        public ActorCreator(ActorSystemContext context, TenantId tenantId, RuleChain ruleChain) {
            super(context);
            this.tenantId = tenantId;
            this.ruleChain = ruleChain;
        }

        public TbActorId createActorId() {
            return new TbEntityActorId((EntityId)this.ruleChain.getId());
        }

        public TbActor createActor() {
            return new RuleChainActor(this.context, this.tenantId, this.ruleChain);
        }
    }
}

