/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.device;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.device.DeviceActorMessageProcessor;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.rpc.FromDeviceRpcResponseActorMsg;
import org.thingsboard.server.common.msg.rpc.RemoveRpcActorMsg;
import org.thingsboard.server.common.msg.rpc.ToDeviceRpcRequestActorMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceAttributesEventNotificationMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceEdgeUpdateMsg;
import org.thingsboard.server.common.msg.rule.engine.DeviceNameOrTypeUpdateMsg;
import org.thingsboard.server.common.msg.timeout.DeviceActorServerSideRpcTimeoutMsg;
import org.thingsboard.server.service.transport.msg.TransportToDeviceActorMsgWrapper;

public class DeviceActor
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceActor.class);
    private final DeviceActorMessageProcessor processor;

    DeviceActor(ActorSystemContext systemContext, TenantId tenantId, DeviceId deviceId) {
        super(systemContext);
        this.processor = new DeviceActorMessageProcessor(systemContext, tenantId, deviceId);
    }

    public void init(TbActorCtx ctx) throws TbActorException {
        super.init(ctx);
        log.debug("[{}][{}] Starting device actor.", (Object)this.processor.tenantId, (Object)this.processor.deviceId);
        try {
            this.processor.init(ctx);
            log.debug("[{}][{}] Device actor started.", (Object)this.processor.tenantId, (Object)this.processor.deviceId);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Unknown failure", new Object[]{this.processor.tenantId, this.processor.deviceId, e});
            throw new TbActorException("Failed to initialize device actor", (Throwable)e);
        }
    }

    @Override
    protected boolean doProcess(TbActorMsg msg) {
        switch (msg.getMsgType()) {
            case TRANSPORT_TO_DEVICE_ACTOR_MSG: {
                this.processor.process((TransportToDeviceActorMsgWrapper)msg);
                break;
            }
            case DEVICE_ATTRIBUTES_UPDATE_TO_DEVICE_ACTOR_MSG: {
                this.processor.processAttributesUpdate((DeviceAttributesEventNotificationMsg)msg);
                break;
            }
            case DEVICE_DELETE_TO_DEVICE_ACTOR_MSG: {
                this.ctx.stop(this.ctx.getSelf());
                break;
            }
            case DEVICE_CREDENTIALS_UPDATE_TO_DEVICE_ACTOR_MSG: {
                this.processor.processCredentialsUpdate(msg);
                break;
            }
            case DEVICE_NAME_OR_TYPE_UPDATE_TO_DEVICE_ACTOR_MSG: {
                this.processor.processNameOrTypeUpdate((DeviceNameOrTypeUpdateMsg)msg);
                break;
            }
            case DEVICE_RPC_REQUEST_TO_DEVICE_ACTOR_MSG: {
                this.processor.processRpcRequest(this.ctx, (ToDeviceRpcRequestActorMsg)msg);
                break;
            }
            case DEVICE_RPC_RESPONSE_TO_DEVICE_ACTOR_MSG: {
                this.processor.processRpcResponsesFromEdge((FromDeviceRpcResponseActorMsg)msg);
                break;
            }
            case DEVICE_ACTOR_SERVER_SIDE_RPC_TIMEOUT_MSG: {
                this.processor.processServerSideRpcTimeout((DeviceActorServerSideRpcTimeoutMsg)msg);
                break;
            }
            case SESSION_TIMEOUT_MSG: {
                this.processor.checkSessionsTimeout();
                break;
            }
            case DEVICE_EDGE_UPDATE_TO_DEVICE_ACTOR_MSG: {
                this.processor.processEdgeUpdate((DeviceEdgeUpdateMsg)msg);
                break;
            }
            case REMOVE_RPC_TO_DEVICE_ACTOR_MSG: {
                this.processor.processRemoveRpc((RemoveRpcActorMsg)msg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

