/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.TbActorCtx;
import org.thingsboard.server.actors.TbActorException;
import org.thingsboard.server.actors.calculatedField.AbstractCalculatedFieldActor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityDeleteMsg;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldEntityMessageProcessor;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldException;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldStateRestoreMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldLinkedTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityCalculatedFieldTelemetryMsg;
import org.thingsboard.server.actors.calculatedField.EntityInitCalculatedFieldMsg;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbActorStopReason;
import org.thingsboard.server.common.msg.ToCalculatedFieldSystemMsg;
import org.thingsboard.server.common.msg.cf.CalculatedFieldPartitionChangeMsg;

public class CalculatedFieldEntityActor
extends AbstractCalculatedFieldActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculatedFieldEntityActor.class);
    private final CalculatedFieldEntityMessageProcessor processor;

    CalculatedFieldEntityActor(ActorSystemContext systemContext, TenantId tenantId, EntityId entityId) {
        super(systemContext, tenantId);
        this.processor = new CalculatedFieldEntityMessageProcessor(systemContext, tenantId, entityId);
    }

    public void init(TbActorCtx ctx) throws TbActorException {
        super.init(ctx);
        log.debug("[{}][{}] Starting CF entity actor.", (Object)this.processor.tenantId, (Object)this.processor.entityId);
        try {
            this.processor.init(ctx);
            log.debug("[{}][{}] CF entity actor started.", (Object)this.processor.tenantId, (Object)this.processor.entityId);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Unknown failure", new Object[]{this.processor.tenantId, this.processor.entityId, e});
            throw new TbActorException("Failed to initialize CF entity actor", (Throwable)e);
        }
    }

    public void destroy(TbActorStopReason stopReason, Throwable cause) throws TbActorException {
        log.debug("[{}] Stopping CF entity actor.", (Object)this.processor.tenantId);
        this.processor.stop();
    }

    @Override
    protected boolean doProcessCfMsg(ToCalculatedFieldSystemMsg msg) throws CalculatedFieldException {
        switch (msg.getMsgType()) {
            case CF_PARTITIONS_CHANGE_MSG: {
                this.processor.process((CalculatedFieldPartitionChangeMsg)msg);
                break;
            }
            case CF_STATE_RESTORE_MSG: {
                this.processor.process((CalculatedFieldStateRestoreMsg)msg);
                break;
            }
            case CF_ENTITY_INIT_CF_MSG: {
                this.processor.process((EntityInitCalculatedFieldMsg)msg);
                break;
            }
            case CF_ENTITY_DELETE_MSG: {
                this.processor.process((CalculatedFieldEntityDeleteMsg)msg);
                break;
            }
            case CF_ENTITY_TELEMETRY_MSG: {
                this.processor.process((EntityCalculatedFieldTelemetryMsg)msg);
                break;
            }
            case CF_LINKED_TELEMETRY_MSG: {
                this.processor.process((EntityCalculatedFieldLinkedTelemetryMsg)msg);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    void logProcessingException(Exception e) {
        log.warn("[{}][{}] Processing failure", new Object[]{this.tenantId, this.processor.entityId, e});
    }
}

