/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.actors.calculatedField;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.DebugModeUtil;
import org.thingsboard.server.actors.ActorSystemContext;
import org.thingsboard.server.actors.calculatedField.CalculatedFieldException;
import org.thingsboard.server.actors.service.ContextAwareActor;
import org.thingsboard.server.common.data.HasDebugSettings;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.msg.TbActorMsg;
import org.thingsboard.server.common.msg.ToCalculatedFieldSystemMsg;

public abstract class AbstractCalculatedFieldActor
extends ContextAwareActor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCalculatedFieldActor.class);
    protected final TenantId tenantId;

    public AbstractCalculatedFieldActor(ActorSystemContext systemContext, TenantId tenantId) {
        super(systemContext);
        this.tenantId = tenantId;
    }

    @Override
    protected boolean doProcess(TbActorMsg msg) {
        if (msg instanceof ToCalculatedFieldSystemMsg) {
            Exception cause;
            ToCalculatedFieldSystemMsg cfm = (ToCalculatedFieldSystemMsg)msg;
            try {
                return this.doProcessCfMsg(cfm);
            }
            catch (CalculatedFieldException cfe) {
                if (DebugModeUtil.isDebugFailuresAvailable((HasDebugSettings)cfe.getCtx().getCalculatedField())) {
                    String message = cfe.getErrorMessage() != null ? cfe.getErrorMessage() : (cfe.getCause() != null ? cfe.getCause().getMessage() : "N/A");
                    this.systemContext.persistCalculatedFieldDebugEvent(this.tenantId, cfe.getCtx().getCfId(), cfe.getEventEntity(), cfe.getArguments(), cfe.getMsgId(), cfe.getMsgType(), null, message);
                }
                cause = cfe.getCause();
            }
            catch (Exception e) {
                this.logProcessingException(e);
                cause = e;
            }
            cfm.getCallback().onFailure((Throwable)cause);
            return true;
        }
        return false;
    }

    abstract void logProcessingException(Exception var1);

    abstract boolean doProcessCfMsg(ToCalculatedFieldSystemMsg var1) throws CalculatedFieldException;
}

