/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server;

import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.thingsboard.server.install.ThingsboardInstallService;

@SpringBootConfiguration
@ComponentScan(value={"org.thingsboard.server.install", "org.thingsboard.server.service.component", "org.thingsboard.server.service.install", "org.thingsboard.server.service.security.auth.jwt.settings", "org.thingsboard.server.dao", "org.thingsboard.server.common.stats", "org.thingsboard.server.common.transport.config.ssl", "org.thingsboard.server.cache"})
public class ThingsboardInstallApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThingsboardInstallApplication.class);
    private static final String SPRING_CONFIG_NAME_KEY = "--spring.config.name";
    private static final String DEFAULT_SPRING_CONFIG_PARAM = "--spring.config.name=thingsboard";

    public static void main(String[] args) {
        try {
            SpringApplication application = new SpringApplication(new Class[]{ThingsboardInstallApplication.class});
            application.setAdditionalProfiles(new String[]{"install"});
            ConfigurableApplicationContext context = application.run(ThingsboardInstallApplication.updateArguments(args));
            ((ThingsboardInstallService)context.getBean(ThingsboardInstallService.class)).performInstall();
        }
        catch (Exception e) {
            log.error(e.getMessage());
            System.exit(1);
        }
    }

    private static String[] updateArguments(String[] args) {
        if (Arrays.stream(args).noneMatch(arg -> arg.startsWith(SPRING_CONFIG_NAME_KEY))) {
            String[] modifiedArgs = new String[args.length + 1];
            System.arraycopy(args, 0, modifiedArgs, 0, args.length);
            modifiedArgs[args.length] = DEFAULT_SPRING_CONFIG_PARAM;
            return modifiedArgs;
        }
        return args;
    }
}

