/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.utils;

import lombok.NonNull;
import org.apache.commons.lang3.math.NumberUtils;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.DoubleDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.service.cf.ctx.state.ArgumentEntry;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldCtx;
import org.thingsboard.server.service.cf.ctx.state.CalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.ScriptCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SimpleCalculatedFieldState;
import org.thingsboard.server.service.cf.ctx.state.SingleValueArgumentEntry;

public class CalculatedFieldArgumentUtils {
    public static ArgumentEntry transformSingleValueArgument(@NonNull KvEntry kvEntry) {
        if (kvEntry == null) {
            throw new NullPointerException("kvEntry is marked non-null but is null");
        }
        return kvEntry.getValue() != null ? ArgumentEntry.createSingleValueArgument(kvEntry) : new SingleValueArgumentEntry();
    }

    public static TsKvEntry createDefaultTsKvEntry(Argument argument, long ts) {
        return new BasicTsKvEntry(ts, CalculatedFieldArgumentUtils.createDefaultKvEntry(argument), SingleValueArgumentEntry.DEFAULT_VERSION);
    }

    public static AttributeKvEntry createDefaultAttributeEntry(Argument argument, long ts) {
        return new BaseAttributeKvEntry(CalculatedFieldArgumentUtils.createDefaultKvEntry(argument), ts, SingleValueArgumentEntry.DEFAULT_VERSION);
    }

    private static KvEntry createDefaultKvEntry(Argument argument) {
        String key = argument.getRefEntityKey().getKey();
        String defaultValue = argument.getDefaultValue();
        if (StringUtils.isBlank((String)defaultValue)) {
            return new StringDataEntry(key, null);
        }
        if (NumberUtils.isParsable((String)defaultValue)) {
            return new DoubleDataEntry(key, Double.valueOf(Double.parseDouble(defaultValue)));
        }
        if ("true".equalsIgnoreCase(defaultValue) || "false".equalsIgnoreCase(defaultValue)) {
            return new BooleanDataEntry(key, Boolean.valueOf(Boolean.parseBoolean(defaultValue)));
        }
        return new StringDataEntry(key, defaultValue);
    }

    public static CalculatedFieldState createStateByType(CalculatedFieldCtx ctx) {
        return switch (ctx.getCfType()) {
            default -> throw new IncompatibleClassChangeError();
            case CalculatedFieldType.SIMPLE -> new SimpleCalculatedFieldState(ctx.getArgNames());
            case CalculatedFieldType.SCRIPT -> new ScriptCalculatedFieldState(ctx.getArgNames());
        };
    }
}

