/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws.telemetry.cmd.v2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.query.AlarmData;
import org.thingsboard.server.service.subscription.SubscriptionErrorCode;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.CmdUpdateType;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.DataUpdate;

public class AlarmDataUpdate
extends DataUpdate<AlarmData> {
    private long allowedEntities;
    private long totalEntities;

    public AlarmDataUpdate(int cmdId, PageData<AlarmData> data, List<AlarmData> update, long allowedEntities, long totalEntities) {
        super(cmdId, data, update, SubscriptionErrorCode.NO_ERROR.getCode(), null);
        this.allowedEntities = allowedEntities;
        this.totalEntities = totalEntities;
    }

    public AlarmDataUpdate(int cmdId, int errorCode, String errorMsg) {
        super(cmdId, null, null, errorCode, errorMsg);
    }

    @Override
    public CmdUpdateType getCmdUpdateType() {
        return CmdUpdateType.ALARM_DATA;
    }

    @JsonCreator
    public AlarmDataUpdate(@JsonProperty(value="cmdId") int cmdId, @JsonProperty(value="data") PageData<AlarmData> data, @JsonProperty(value="update") List<AlarmData> update, @JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="errorMsg") String errorMsg, @JsonProperty(value="allowedEntities") long allowedEntities, @JsonProperty(value="totalEntities") long totalEntities) {
        super(cmdId, data, update, errorCode, errorMsg);
        this.allowedEntities = allowedEntities;
        this.totalEntities = totalEntities;
    }

    @Override
    @Generated
    public String toString() {
        return "AlarmDataUpdate(allowedEntities=" + this.getAllowedEntities() + ", totalEntities=" + this.getTotalEntities() + ")";
    }

    @Generated
    public long getAllowedEntities() {
        return this.allowedEntities;
    }

    @Generated
    public long getTotalEntities() {
        return this.totalEntities;
    }
}

