/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws.notification.sub;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.thingsboard.server.common.data.BaseData;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.notification.Notification;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.subscription.TbSubscriptionType;
import org.thingsboard.server.service.ws.notification.cmd.UnreadNotificationsUpdate;
import org.thingsboard.server.service.ws.notification.sub.AbstractNotificationSubscription;
import org.thingsboard.server.service.ws.notification.sub.NotificationsSubscriptionUpdate;

public class NotificationsSubscription
extends AbstractNotificationSubscription<NotificationsSubscriptionUpdate> {
    private final Map<UUID, Notification> latestUnreadNotifications = new HashMap<UUID, Notification>();
    private final int limit;
    private final Set<NotificationType> notificationTypes;

    public NotificationsSubscription(String serviceId, String sessionId, int subscriptionId, TenantId tenantId, EntityId entityId, BiConsumer<TbSubscription<NotificationsSubscriptionUpdate>, NotificationsSubscriptionUpdate> updateProcessor, int limit, Set<NotificationType> notificationTypes) {
        super(serviceId, sessionId, subscriptionId, tenantId, entityId, TbSubscriptionType.NOTIFICATIONS, updateProcessor);
        this.limit = limit;
        this.notificationTypes = notificationTypes;
    }

    public boolean checkNotificationType(NotificationType type) {
        return CollectionUtils.isEmpty(this.notificationTypes) || this.notificationTypes.contains(type);
    }

    public UnreadNotificationsUpdate createFullUpdate() {
        return UnreadNotificationsUpdate.builder().cmdId(this.getSubscriptionId()).notifications(this.getSortedNotifications()).totalUnreadCount(this.totalUnreadCounter.get()).sequenceNumber(this.sequence.incrementAndGet()).build();
    }

    public List<Notification> getSortedNotifications() {
        return this.latestUnreadNotifications.values().stream().sorted(Comparator.comparing(BaseData::getCreatedTime, Comparator.reverseOrder())).collect(Collectors.toList());
    }

    public UnreadNotificationsUpdate createPartialUpdate(Notification notification) {
        return UnreadNotificationsUpdate.builder().cmdId(this.getSubscriptionId()).update(notification).totalUnreadCount(this.totalUnreadCounter.get()).sequenceNumber(this.sequence.incrementAndGet()).build();
    }

    public UnreadNotificationsUpdate createCountUpdate() {
        return UnreadNotificationsUpdate.builder().cmdId(this.getSubscriptionId()).totalUnreadCount(this.totalUnreadCounter.get()).sequenceNumber(this.sequence.incrementAndGet()).build();
    }

    @Generated
    public static NotificationsSubscriptionBuilder builder() {
        return new NotificationsSubscriptionBuilder();
    }

    @Generated
    public Map<UUID, Notification> getLatestUnreadNotifications() {
        return this.latestUnreadNotifications;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public Set<NotificationType> getNotificationTypes() {
        return this.notificationTypes;
    }

    @Generated
    public static class NotificationsSubscriptionBuilder {
        @Generated
        private String serviceId;
        @Generated
        private String sessionId;
        @Generated
        private int subscriptionId;
        @Generated
        private TenantId tenantId;
        @Generated
        private EntityId entityId;
        @Generated
        private BiConsumer<TbSubscription<NotificationsSubscriptionUpdate>, NotificationsSubscriptionUpdate> updateProcessor;
        @Generated
        private int limit;
        @Generated
        private Set<NotificationType> notificationTypes;

        @Generated
        NotificationsSubscriptionBuilder() {
        }

        @Generated
        public NotificationsSubscriptionBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public NotificationsSubscriptionBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public NotificationsSubscriptionBuilder subscriptionId(int subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        @Generated
        public NotificationsSubscriptionBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public NotificationsSubscriptionBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public NotificationsSubscriptionBuilder updateProcessor(BiConsumer<TbSubscription<NotificationsSubscriptionUpdate>, NotificationsSubscriptionUpdate> updateProcessor) {
            this.updateProcessor = updateProcessor;
            return this;
        }

        @Generated
        public NotificationsSubscriptionBuilder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public NotificationsSubscriptionBuilder notificationTypes(Set<NotificationType> notificationTypes) {
            this.notificationTypes = notificationTypes;
            return this;
        }

        @Generated
        public NotificationsSubscription build() {
            return new NotificationsSubscription(this.serviceId, this.sessionId, this.subscriptionId, this.tenantId, this.entityId, this.updateProcessor, this.limit, this.notificationTypes);
        }

        @Generated
        public String toString() {
            return "NotificationsSubscription.NotificationsSubscriptionBuilder(serviceId=" + this.serviceId + ", sessionId=" + this.sessionId + ", subscriptionId=" + this.subscriptionId + ", tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", updateProcessor=" + String.valueOf(this.updateProcessor) + ", limit=" + this.limit + ", notificationTypes=" + String.valueOf(this.notificationTypes) + ")";
        }
    }
}

