/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws.notification.sub;

import java.util.function.BiConsumer;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.subscription.TbSubscriptionType;
import org.thingsboard.server.service.ws.notification.cmd.UnreadNotificationsCountUpdate;
import org.thingsboard.server.service.ws.notification.sub.AbstractNotificationSubscription;
import org.thingsboard.server.service.ws.notification.sub.NotificationsSubscriptionUpdate;

public class NotificationsCountSubscription
extends AbstractNotificationSubscription<NotificationsSubscriptionUpdate> {
    public NotificationsCountSubscription(String serviceId, String sessionId, int subscriptionId, TenantId tenantId, EntityId entityId, BiConsumer<TbSubscription<NotificationsSubscriptionUpdate>, NotificationsSubscriptionUpdate> updateProcessor) {
        super(serviceId, sessionId, subscriptionId, tenantId, entityId, TbSubscriptionType.NOTIFICATIONS_COUNT, updateProcessor);
    }

    public UnreadNotificationsCountUpdate createUpdate() {
        return UnreadNotificationsCountUpdate.builder().cmdId(this.getSubscriptionId()).totalUnreadCount(this.totalUnreadCounter.get()).sequenceNumber(this.sequence.incrementAndGet()).build();
    }

    @Generated
    public static NotificationsCountSubscriptionBuilder builder() {
        return new NotificationsCountSubscriptionBuilder();
    }

    @Generated
    public static class NotificationsCountSubscriptionBuilder {
        @Generated
        private String serviceId;
        @Generated
        private String sessionId;
        @Generated
        private int subscriptionId;
        @Generated
        private TenantId tenantId;
        @Generated
        private EntityId entityId;
        @Generated
        private BiConsumer<TbSubscription<NotificationsSubscriptionUpdate>, NotificationsSubscriptionUpdate> updateProcessor;

        @Generated
        NotificationsCountSubscriptionBuilder() {
        }

        @Generated
        public NotificationsCountSubscriptionBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public NotificationsCountSubscriptionBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public NotificationsCountSubscriptionBuilder subscriptionId(int subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        @Generated
        public NotificationsCountSubscriptionBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public NotificationsCountSubscriptionBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public NotificationsCountSubscriptionBuilder updateProcessor(BiConsumer<TbSubscription<NotificationsSubscriptionUpdate>, NotificationsSubscriptionUpdate> updateProcessor) {
            this.updateProcessor = updateProcessor;
            return this;
        }

        @Generated
        public NotificationsCountSubscription build() {
            return new NotificationsCountSubscription(this.serviceId, this.sessionId, this.subscriptionId, this.tenantId, this.entityId, this.updateProcessor);
        }

        @Generated
        public String toString() {
            return "NotificationsCountSubscription.NotificationsCountSubscriptionBuilder(serviceId=" + this.serviceId + ", sessionId=" + this.sessionId + ", subscriptionId=" + this.subscriptionId + ", tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", updateProcessor=" + String.valueOf(this.updateProcessor) + ")";
        }
    }
}

