/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws.notification;

import java.beans.ConstructorProperties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.rule.engine.api.NotificationCenter;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.IdBased;
import org.thingsboard.server.common.data.id.NotificationId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.notification.Notification;
import org.thingsboard.server.common.data.notification.NotificationDeliveryMethod;
import org.thingsboard.server.common.data.notification.NotificationStatus;
import org.thingsboard.server.common.data.notification.NotificationType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.dao.notification.NotificationService;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.subscription.TbLocalSubscriptionService;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.ws.WebSocketService;
import org.thingsboard.server.service.ws.WebSocketSessionRef;
import org.thingsboard.server.service.ws.notification.NotificationCommandsHandler;
import org.thingsboard.server.service.ws.notification.cmd.MarkAllNotificationsAsReadCmd;
import org.thingsboard.server.service.ws.notification.cmd.MarkNotificationsAsReadCmd;
import org.thingsboard.server.service.ws.notification.cmd.NotificationsCountSubCmd;
import org.thingsboard.server.service.ws.notification.cmd.NotificationsSubCmd;
import org.thingsboard.server.service.ws.notification.sub.NotificationRequestUpdate;
import org.thingsboard.server.service.ws.notification.sub.NotificationUpdate;
import org.thingsboard.server.service.ws.notification.sub.NotificationsCountSubscription;
import org.thingsboard.server.service.ws.notification.sub.NotificationsSubscription;
import org.thingsboard.server.service.ws.notification.sub.NotificationsSubscriptionUpdate;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.CmdUpdate;
import org.thingsboard.server.service.ws.telemetry.cmd.v2.UnsubscribeCmd;

@Service
@TbCoreComponent
public class DefaultNotificationCommandsHandler
implements NotificationCommandsHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNotificationCommandsHandler.class);
    private final NotificationService notificationService;
    private final TbLocalSubscriptionService localSubscriptionService;
    private final NotificationCenter notificationCenter;
    private final TbServiceInfoProvider serviceInfoProvider;
    @Autowired
    @Lazy
    private WebSocketService wsService;

    @Override
    public void handleUnreadNotificationsSubCmd(WebSocketSessionRef sessionRef, NotificationsSubCmd cmd) {
        log.debug("[{}] Handling unread notifications subscription cmd (cmdId: {})", (Object)sessionRef.getSessionId(), (Object)cmd.getCmdId());
        SecurityUser securityCtx = sessionRef.getSecurityCtx();
        NotificationsSubscription subscription = NotificationsSubscription.builder().serviceId(this.serviceInfoProvider.getServiceId()).sessionId(sessionRef.getSessionId()).subscriptionId(cmd.getCmdId()).tenantId(securityCtx.getTenantId()).entityId((EntityId)securityCtx.getId()).updateProcessor(this::handleNotificationsSubscriptionUpdate).limit(cmd.getLimit()).notificationTypes(cmd.getTypes()).build();
        this.localSubscriptionService.addSubscription(subscription, sessionRef);
        this.fetchUnreadNotifications(subscription);
        this.sendUpdate(sessionRef.getSessionId(), subscription.createFullUpdate());
    }

    @Override
    public void handleUnreadNotificationsCountSubCmd(WebSocketSessionRef sessionRef, NotificationsCountSubCmd cmd) {
        log.debug("[{}] Handling unread notifications count subscription cmd (cmdId: {})", (Object)sessionRef.getSessionId(), (Object)cmd.getCmdId());
        SecurityUser securityCtx = sessionRef.getSecurityCtx();
        NotificationsCountSubscription subscription = NotificationsCountSubscription.builder().serviceId(this.serviceInfoProvider.getServiceId()).sessionId(sessionRef.getSessionId()).subscriptionId(cmd.getCmdId()).tenantId(securityCtx.getTenantId()).entityId((EntityId)securityCtx.getId()).updateProcessor(this::handleNotificationsCountSubscriptionUpdate).build();
        this.localSubscriptionService.addSubscription(subscription, sessionRef);
        this.fetchUnreadNotificationsCount(subscription);
        this.sendUpdate(sessionRef.getSessionId(), subscription.createUpdate());
    }

    private void fetchUnreadNotifications(NotificationsSubscription subscription) {
        log.trace("[{}, subId: {}] Fetching unread notifications from DB", (Object)subscription.getSessionId(), (Object)subscription.getSubscriptionId());
        PageData notifications = this.notificationService.findLatestUnreadNotificationsByRecipientIdAndNotificationTypes(subscription.getTenantId(), NotificationDeliveryMethod.WEB, (UserId)subscription.getEntityId(), subscription.getNotificationTypes(), subscription.getLimit());
        subscription.getLatestUnreadNotifications().clear();
        notifications.getData().forEach(notification -> subscription.getLatestUnreadNotifications().put(notification.getUuidId(), (Notification)notification));
        subscription.getTotalUnreadCounter().set((int)notifications.getTotalElements());
    }

    private void fetchUnreadNotificationsCount(NotificationsCountSubscription subscription) {
        log.trace("[{}, subId: {}] Fetching unread notifications count from DB", (Object)subscription.getSessionId(), (Object)subscription.getSubscriptionId());
        int unreadCount = this.notificationService.countUnreadNotificationsByRecipientId(subscription.getTenantId(), NotificationDeliveryMethod.WEB, (UserId)subscription.getEntityId());
        subscription.getTotalUnreadCounter().set(unreadCount);
    }

    private void handleNotificationsSubscriptionUpdate(TbSubscription<NotificationsSubscriptionUpdate> sub, NotificationsSubscriptionUpdate subscriptionUpdate) {
        NotificationsSubscription subscription = (NotificationsSubscription)sub;
        try {
            if (subscriptionUpdate.getNotificationUpdate() != null) {
                this.handleNotificationUpdate(subscription, subscriptionUpdate.getNotificationUpdate());
            } else if (subscriptionUpdate.getNotificationRequestUpdate() != null) {
                this.handleNotificationRequestUpdate(subscription, subscriptionUpdate.getNotificationRequestUpdate());
            }
        }
        catch (Exception e) {
            log.error("[{}, subId: {}] Failed to handle update for notifications subscription: {}", new Object[]{subscription.getSessionId(), subscription.getSubscriptionId(), subscriptionUpdate, e});
        }
    }

    private void handleNotificationUpdate(NotificationsSubscription subscription, NotificationUpdate update) {
        NotificationType notificationType;
        log.trace("[{}, subId: {}] Handling notification update: {}", new Object[]{subscription.getSessionId(), subscription.getSubscriptionId(), update});
        Notification notification = update.getNotification();
        UUID notificationId = notification != null ? notification.getUuidId() : update.getNotificationId();
        NotificationType notificationType2 = notificationType = notification != null ? notification.getType() : update.getNotificationType();
        if (notificationType != null && !subscription.checkNotificationType(notificationType)) {
            return;
        }
        if (update.isCreated()) {
            subscription.getLatestUnreadNotifications().put(notificationId, notification);
            subscription.getTotalUnreadCounter().incrementAndGet();
            if (subscription.getLatestUnreadNotifications().size() > subscription.getLimit()) {
                Set<UUID> beyondLimit = subscription.getSortedNotifications().stream().skip(subscription.getLimit()).map(IdBased::getUuidId).collect(Collectors.toSet());
                beyondLimit.forEach(id -> subscription.getLatestUnreadNotifications().remove(id));
            }
            this.sendUpdate(subscription.getSessionId(), subscription.createPartialUpdate(notification));
        } else if (update.isUpdated()) {
            if (update.getNewStatus() == NotificationStatus.READ) {
                if (update.isAllNotifications() || subscription.getLatestUnreadNotifications().containsKey(notificationId)) {
                    this.fetchUnreadNotifications(subscription);
                    this.sendUpdate(subscription.getSessionId(), subscription.createFullUpdate());
                } else {
                    subscription.getTotalUnreadCounter().decrementAndGet();
                    this.sendUpdate(subscription.getSessionId(), subscription.createCountUpdate());
                }
            } else if (notification.getStatus() != NotificationStatus.READ && subscription.getLatestUnreadNotifications().containsKey(notificationId)) {
                subscription.getLatestUnreadNotifications().put(notificationId, notification);
                this.sendUpdate(subscription.getSessionId(), subscription.createPartialUpdate(notification));
            }
        } else if (update.isDeleted()) {
            if (subscription.getLatestUnreadNotifications().containsKey(notificationId)) {
                this.fetchUnreadNotifications(subscription);
                this.sendUpdate(subscription.getSessionId(), subscription.createFullUpdate());
            } else if (notification.getStatus() != NotificationStatus.READ) {
                subscription.getTotalUnreadCounter().decrementAndGet();
                this.sendUpdate(subscription.getSessionId(), subscription.createCountUpdate());
            }
        }
    }

    private void handleNotificationRequestUpdate(NotificationsSubscription subscription, NotificationRequestUpdate update) {
        log.trace("[{}, subId: {}] Handling notification request update: {}", new Object[]{subscription.getSessionId(), subscription.getSubscriptionId(), update});
        this.fetchUnreadNotifications(subscription);
        this.sendUpdate(subscription.getSessionId(), subscription.createFullUpdate());
    }

    private void handleNotificationsCountSubscriptionUpdate(TbSubscription<NotificationsSubscriptionUpdate> sub, NotificationsSubscriptionUpdate subscriptionUpdate) {
        NotificationsCountSubscription subscription = (NotificationsCountSubscription)sub;
        try {
            if (subscriptionUpdate.getNotificationUpdate() != null) {
                this.handleNotificationUpdate(subscription, subscriptionUpdate.getNotificationUpdate());
            } else if (subscriptionUpdate.getNotificationRequestUpdate() != null) {
                this.handleNotificationRequestUpdate(subscription, subscriptionUpdate.getNotificationRequestUpdate());
            }
        }
        catch (Exception e) {
            log.error("[{}, subId: {}] Failed to handle update for notifications count subscription: {}", new Object[]{subscription.getSessionId(), subscription.getSubscriptionId(), subscriptionUpdate, e});
        }
    }

    private void handleNotificationUpdate(NotificationsCountSubscription subscription, NotificationUpdate update) {
        log.trace("[{}, subId: {}] Handling notification update for count sub: {}", new Object[]{subscription.getSessionId(), subscription.getSubscriptionId(), update});
        if (update.isCreated()) {
            subscription.getTotalUnreadCounter().incrementAndGet();
            this.sendUpdate(subscription.getSessionId(), subscription.createUpdate());
        } else if (update.isUpdated()) {
            if (update.getNewStatus() == NotificationStatus.READ) {
                if (update.isAllNotifications()) {
                    this.fetchUnreadNotificationsCount(subscription);
                } else {
                    subscription.getTotalUnreadCounter().decrementAndGet();
                }
                this.sendUpdate(subscription.getSessionId(), subscription.createUpdate());
            }
        } else if (update.isDeleted() && update.getNotification().getStatus() != NotificationStatus.READ) {
            subscription.getTotalUnreadCounter().decrementAndGet();
            this.sendUpdate(subscription.getSessionId(), subscription.createUpdate());
        }
    }

    private void handleNotificationRequestUpdate(NotificationsCountSubscription subscription, NotificationRequestUpdate update) {
        log.trace("[{}, subId: {}] Handling notification request update for count sub: {}", new Object[]{subscription.getSessionId(), subscription.getSubscriptionId(), update});
        this.fetchUnreadNotificationsCount(subscription);
        this.sendUpdate(subscription.getSessionId(), subscription.createUpdate());
    }

    @Override
    public void handleMarkAsReadCmd(WebSocketSessionRef sessionRef, MarkNotificationsAsReadCmd cmd) {
        SecurityUser securityCtx = sessionRef.getSecurityCtx();
        cmd.getNotifications().stream().map(NotificationId::new).forEach(notificationId -> this.notificationCenter.markNotificationAsRead(securityCtx.getTenantId(), securityCtx.getId(), notificationId));
    }

    @Override
    public void handleMarkAllAsReadCmd(WebSocketSessionRef sessionRef, MarkAllNotificationsAsReadCmd cmd) {
        SecurityUser securityCtx = sessionRef.getSecurityCtx();
        this.notificationCenter.markAllNotificationsAsRead(securityCtx.getTenantId(), NotificationDeliveryMethod.WEB, securityCtx.getId());
    }

    @Override
    public void handleUnsubCmd(WebSocketSessionRef sessionRef, UnsubscribeCmd cmd) {
        this.localSubscriptionService.cancelSubscription(sessionRef.getTenantId(), sessionRef.getSessionId(), cmd.getCmdId());
    }

    private void sendUpdate(String sessionId, CmdUpdate update) {
        log.trace("[{}, cmdId: {}] Sending WS update: {}", new Object[]{sessionId, update.getCmdId(), update});
        this.wsService.sendUpdate(sessionId, update);
    }

    @ConstructorProperties(value={"notificationService", "localSubscriptionService", "notificationCenter", "serviceInfoProvider"})
    @Generated
    public DefaultNotificationCommandsHandler(NotificationService notificationService, TbLocalSubscriptionService localSubscriptionService, NotificationCenter notificationCenter, TbServiceInfoProvider serviceInfoProvider) {
        this.notificationService = notificationService;
        this.localSubscriptionService = localSubscriptionService;
        this.notificationCenter = notificationCenter;
        this.serviceInfoProvider = serviceInfoProvider;
    }
}

