/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ws;

import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.security.model.SecurityUser;
import org.thingsboard.server.service.ws.WebSocketSessionType;

public class WebSocketSessionRef {
    private static final long serialVersionUID = 1L;
    private final String sessionId;
    private volatile SecurityUser securityCtx;
    private final InetSocketAddress localAddress;
    private final InetSocketAddress remoteAddress;
    private final WebSocketSessionType sessionType;
    private final AtomicInteger sessionSubIdSeq = new AtomicInteger();

    public TenantId getTenantId() {
        return this.securityCtx != null ? this.securityCtx.getTenantId() : TenantId.SYS_TENANT_ID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketSessionRef that = (WebSocketSessionRef)o;
        return Objects.equals(this.sessionId, that.sessionId);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId);
    }

    public String toString() {
        Object info = "";
        if (this.securityCtx != null) {
            info = (String)info + "[" + String.valueOf(this.securityCtx.getTenantId()) + "]";
            info = (String)info + "[" + String.valueOf(this.securityCtx.getId()) + "]";
        }
        info = (String)info + "[" + this.sessionId + "]";
        return info;
    }

    @ConstructorProperties(value={"sessionId", "securityCtx", "localAddress", "remoteAddress", "sessionType"})
    @Generated
    WebSocketSessionRef(String sessionId, SecurityUser securityCtx, InetSocketAddress localAddress, InetSocketAddress remoteAddress, WebSocketSessionType sessionType) {
        this.sessionId = sessionId;
        this.securityCtx = securityCtx;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.sessionType = sessionType;
    }

    @Generated
    public static WebSocketSessionRefBuilder builder() {
        return new WebSocketSessionRefBuilder();
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public SecurityUser getSecurityCtx() {
        return this.securityCtx;
    }

    @Generated
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Generated
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Generated
    public WebSocketSessionType getSessionType() {
        return this.sessionType;
    }

    @Generated
    public AtomicInteger getSessionSubIdSeq() {
        return this.sessionSubIdSeq;
    }

    @Generated
    public void setSecurityCtx(SecurityUser securityCtx) {
        this.securityCtx = securityCtx;
    }

    @Generated
    public static class WebSocketSessionRefBuilder {
        @Generated
        private String sessionId;
        @Generated
        private SecurityUser securityCtx;
        @Generated
        private InetSocketAddress localAddress;
        @Generated
        private InetSocketAddress remoteAddress;
        @Generated
        private WebSocketSessionType sessionType;

        @Generated
        WebSocketSessionRefBuilder() {
        }

        @Generated
        public WebSocketSessionRefBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public WebSocketSessionRefBuilder securityCtx(SecurityUser securityCtx) {
            this.securityCtx = securityCtx;
            return this;
        }

        @Generated
        public WebSocketSessionRefBuilder localAddress(InetSocketAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        @Generated
        public WebSocketSessionRefBuilder remoteAddress(InetSocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        @Generated
        public WebSocketSessionRefBuilder sessionType(WebSocketSessionType sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        @Generated
        public WebSocketSessionRef build() {
            return new WebSocketSessionRef(this.sessionId, this.securityCtx, this.localAddress, this.remoteAddress, this.sessionType);
        }

        @Generated
        public String toString() {
            return "WebSocketSessionRef.WebSocketSessionRefBuilder(sessionId=" + this.sessionId + ", securityCtx=" + String.valueOf((Object)this.securityCtx) + ", localAddress=" + String.valueOf(this.localAddress) + ", remoteAddress=" + String.valueOf(this.remoteAddress) + ", sessionType=" + String.valueOf((Object)this.sessionType) + ")";
        }
    }
}

