/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.notification.NotificationRequestDao;
import org.thingsboard.server.dao.sqlts.insert.sql.SqlPartitioningRepository;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.service.ttl.AbstractCleanUpService;

@Service
@ConditionalOnExpression(value="${sql.ttl.notifications.enabled:true} && ${sql.ttl.notifications.ttl:0} > 0")
public class NotificationsCleanUpService
extends AbstractCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationsCleanUpService.class);
    private final SqlPartitioningRepository partitioningRepository;
    private final NotificationRequestDao notificationRequestDao;
    @Value(value="${sql.ttl.notifications.ttl:2592000}")
    private long ttlInSec;
    @Value(value="${sql.notifications.partition_size:168}")
    private int partitionSizeInHours;

    public NotificationsCleanUpService(PartitionService partitionService, SqlPartitioningRepository partitioningRepository, NotificationRequestDao notificationRequestDao) {
        super(partitionService);
        this.partitioningRepository = partitioningRepository;
        this.notificationRequestDao = notificationRequestDao;
    }

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.notifications.checking_interval_ms:86400000})}", fixedDelayString="${sql.ttl.notifications.checking_interval_ms:86400000}")
    public void cleanUp() {
        long expTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(this.ttlInSec);
        long partitionDurationMs = TimeUnit.HOURS.toMillis(this.partitionSizeInHours);
        if (!this.isSystemTenantPartitionMine()) {
            this.partitioningRepository.cleanupPartitionsCache("notification", expTime, partitionDurationMs);
            return;
        }
        long lastRemovedNotificationTs = this.partitioningRepository.dropPartitionsBefore("notification", expTime, partitionDurationMs);
        if (lastRemovedNotificationTs > 0L) {
            long gap = TimeUnit.MINUTES.toMillis(10L);
            long requestExpTime = lastRemovedNotificationTs - TimeUnit.SECONDS.toMillis(604800L) - gap;
            int removed = this.notificationRequestDao.removeAllByCreatedTimeBefore(requestExpTime);
            log.info("Removed {} outdated notification requests older than {}", (Object)removed, (Object)requestExpTime);
        }
    }
}

