/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.event.EventService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.service.ttl.AbstractCleanUpService;

@Service
public class EventsCleanUpService
extends AbstractCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventsCleanUpService.class);
    public static final String RANDOM_DELAY_INTERVAL_MS_EXPRESSION = "#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.events.execution_interval_ms})}";
    @Value(value="${sql.ttl.events.events_ttl}")
    private long ttlInSec;
    @Value(value="${sql.ttl.events.debug_events_ttl}")
    private long debugTtlInSec;
    @Value(value="${sql.ttl.events.enabled}")
    private boolean ttlTaskExecutionEnabled;
    private final EventService eventService;

    public EventsCleanUpService(PartitionService partitionService, EventService eventService) {
        super(partitionService);
        this.eventService = eventService;
    }

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.events.execution_interval_ms})}", fixedDelayString="${sql.ttl.events.execution_interval_ms}")
    public void cleanUp() {
        if (this.ttlTaskExecutionEnabled) {
            long ts = System.currentTimeMillis();
            long regularEventExpTs = this.ttlInSec > 0L ? ts - TimeUnit.SECONDS.toMillis(this.ttlInSec) : 0L;
            long debugEventExpTs = this.debugTtlInSec > 0L ? ts - TimeUnit.SECONDS.toMillis(this.debugTtlInSec) : 0L;
            this.eventService.cleanupEvents(regularEventExpTs, debugEventExpTs, this.isSystemTenantPartitionMine());
        }
    }
}

