/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.ttl;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.thingsboard.server.dao.edge.EdgeEventService;
import org.thingsboard.server.dao.sqlts.insert.sql.SqlPartitioningRepository;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.ttl.AbstractCleanUpService;

@TbCoreComponent
@Service
@ConditionalOnExpression(value="${edges.enabled:true} && ${sql.ttl.edge_events.edge_events_ttl:0} > 0")
public class EdgeEventsCleanUpService
extends AbstractCleanUpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdgeEventsCleanUpService.class);
    public static final String RANDOM_DELAY_INTERVAL_MS_EXPRESSION = "#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.edge_events.execution_interval_ms})}";
    @Value(value="${sql.ttl.edge_events.edge_events_ttl}")
    private long ttl;
    @Value(value="${sql.edge_events.partition_size:168}")
    private int partitionSizeInHours;
    @Value(value="${sql.ttl.edge_events.enabled:true}")
    private boolean ttlTaskExecutionEnabled;
    private final EdgeEventService edgeEventService;
    private final SqlPartitioningRepository partitioningRepository;

    public EdgeEventsCleanUpService(PartitionService partitionService, EdgeEventService edgeEventService, SqlPartitioningRepository partitioningRepository) {
        super(partitionService);
        this.edgeEventService = edgeEventService;
        this.partitioningRepository = partitioningRepository;
    }

    @Scheduled(initialDelayString="#{T(org.apache.commons.lang3.RandomUtils).nextLong(0, ${sql.ttl.edge_events.execution_interval_ms})}", fixedDelayString="${sql.ttl.edge_events.execution_interval_ms}")
    public void cleanUp() {
        long edgeEventsExpTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(this.ttl);
        if (this.ttlTaskExecutionEnabled && this.isSystemTenantPartitionMine()) {
            this.edgeEventService.cleanupEvents(edgeEventsExpTime);
        } else {
            this.partitioningRepository.cleanupPartitionsCache("edge_event", edgeEventsExpTime, TimeUnit.HOURS.toMillis(this.partitionSizeInHours));
        }
    }
}

