/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.transport;

import com.google.protobuf.GeneratedMessageV3;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.TbQueueCallback;
import org.thingsboard.server.queue.TbQueueMsg;
import org.thingsboard.server.queue.TbQueueMsgMetadata;
import org.thingsboard.server.queue.TbQueueProducer;
import org.thingsboard.server.queue.common.TbProtoQueueMsg;
import org.thingsboard.server.queue.discovery.TopicService;
import org.thingsboard.server.queue.provider.TbQueueProducerProvider;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.transport.TbCoreToTransportService;

@Service
@TbCoreComponent
public class DefaultTbCoreToTransportService
implements TbCoreToTransportService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTbCoreToTransportService.class);
    private final TopicService topicService;
    private final TbQueueProducer<TbProtoQueueMsg<TransportProtos.ToTransportMsg>> tbTransportProducer;

    public DefaultTbCoreToTransportService(TopicService topicService, TbQueueProducerProvider tbQueueProducerProvider) {
        this.topicService = topicService;
        this.tbTransportProducer = tbQueueProducerProvider.getTransportNotificationsMsgProducer();
    }

    @Override
    public void process(String nodeId, TransportProtos.ToTransportMsg msg) {
        this.process(nodeId, msg, null, null);
    }

    @Override
    public void process(String nodeId, TransportProtos.ToTransportMsg msg, Runnable onSuccess, Consumer<Throwable> onFailure) {
        if (nodeId == null || nodeId.isEmpty()) {
            log.trace("process: skipping message without nodeId [{}], (ToTransportMsg) msg [{}]", (Object)nodeId, (Object)msg);
            if (onSuccess != null) {
                onSuccess.run();
            }
            return;
        }
        TopicPartitionInfo tpi = this.topicService.getNotificationsTopic(ServiceType.TB_TRANSPORT, nodeId);
        UUID sessionId = new UUID(msg.getSessionIdMSB(), msg.getSessionIdLSB());
        log.trace("[{}][{}] Pushing session data to topic: {}", new Object[]{tpi.getFullTopicName(), sessionId, msg});
        TbProtoQueueMsg queueMsg = new TbProtoQueueMsg(ModelConstants.NULL_UUID, (GeneratedMessageV3)msg);
        this.tbTransportProducer.send(tpi, (TbQueueMsg)queueMsg, (TbQueueCallback)new QueueCallbackAdaptor(onSuccess, onFailure));
    }

    private static class QueueCallbackAdaptor
    implements TbQueueCallback {
        private final Runnable onSuccess;
        private final Consumer<Throwable> onFailure;

        QueueCallbackAdaptor(Runnable onSuccess, Consumer<Throwable> onFailure) {
            this.onSuccess = onSuccess;
            this.onFailure = onFailure;
        }

        public void onSuccess(TbQueueMsgMetadata metadata) {
            if (this.onSuccess != null) {
                this.onSuccess.run();
            }
        }

        public void onFailure(Throwable t) {
            if (this.onFailure != null) {
                this.onFailure.accept(t);
            }
        }
    }
}

