/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.system;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.protobuf.ProtocolStringList;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.SystemUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.MailService;
import org.thingsboard.rule.engine.api.SmsService;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.ApiUsageState;
import org.thingsboard.server.common.data.FeaturesInfo;
import org.thingsboard.server.common.data.SystemInfo;
import org.thingsboard.server.common.data.SystemInfoData;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.JsonDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.ResourcesShortageTrigger;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.stats.TbApiUsageStateClient;
import org.thingsboard.server.dao.domain.DomainService;
import org.thingsboard.server.dao.settings.AdminSettingsService;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.DiscoveryService;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.discovery.TbApplicationEventListener;
import org.thingsboard.server.queue.discovery.TbServiceInfoProvider;
import org.thingsboard.server.queue.discovery.event.PartitionChangeEvent;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.system.SystemInfoService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

@TbCoreComponent
@Service
public class DefaultSystemInfoService
extends TbApplicationEventListener<PartitionChangeEvent>
implements SystemInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSystemInfoService.class);
    public static final FutureCallback<Void> CALLBACK = new FutureCallback<Void>(){

        public void onSuccess(@Nullable Void result) {
        }

        public void onFailure(Throwable t) {
            log.warn("Failed to persist system info", t);
        }
    };
    private final TbServiceInfoProvider serviceInfoProvider;
    private final PartitionService partitionService;
    private final DiscoveryService discoveryService;
    private final TelemetrySubscriptionService telemetryService;
    private final TbApiUsageStateClient apiUsageStateClient;
    private final AdminSettingsService adminSettingsService;
    private final DomainService domainService;
    private final MailService mailService;
    private final SmsService smsService;
    private final NotificationRuleProcessor notificationRuleProcessor;
    private volatile ScheduledExecutorService scheduler;
    @Value(value="${metrics.system_info.persist_frequency:60}")
    private int systemInfoPersistFrequencySeconds;
    @Value(value="#{${metrics.system_info.ttl:7} * 86400}")
    private int systemInfoTtlSeconds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTbApplicationEvent(PartitionChangeEvent partitionChangeEvent) {
        if (ServiceType.TB_CORE.equals((Object)partitionChangeEvent.getServiceType())) {
            boolean myPartition = this.partitionService.resolve(ServiceType.TB_CORE, TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID).isMyPartition();
            DefaultSystemInfoService defaultSystemInfoService = this;
            synchronized (defaultSystemInfoService) {
                if (myPartition) {
                    if (this.scheduler == null) {
                        this.scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"tb-system-info-scheduler");
                        this.scheduler.scheduleWithFixedDelay(this::saveCurrentSystemInfo, 0L, this.systemInfoPersistFrequencySeconds, TimeUnit.SECONDS);
                    }
                } else {
                    this.destroy();
                }
            }
        }
    }

    @Override
    public SystemInfo getSystemInfo() {
        SystemInfo systemInfo = new SystemInfo();
        if (this.discoveryService.isMonolith()) {
            systemInfo.setMonolith(true);
            systemInfo.setSystemData(Collections.singletonList(this.createSystemInfoData(this.serviceInfoProvider.generateNewServiceInfoWithCurrentSystemInfo())));
        } else {
            systemInfo.setSystemData(this.getSystemData(this.serviceInfoProvider.getServiceInfo()));
        }
        return systemInfo;
    }

    protected void saveCurrentSystemInfo() {
        if (this.discoveryService.isMonolith()) {
            this.saveCurrentMonolithSystemInfo();
        } else {
            this.saveCurrentClusterSystemInfo();
        }
    }

    @Override
    public FeaturesInfo getFeaturesInfo() {
        FeaturesInfo featuresInfo = new FeaturesInfo();
        featuresInfo.setEmailEnabled(this.isEmailEnabled());
        featuresInfo.setSmsEnabled(this.smsService.isConfigured(TenantId.SYS_TENANT_ID));
        featuresInfo.setOauthEnabled(this.domainService.isOauth2Enabled(TenantId.SYS_TENANT_ID));
        featuresInfo.setTwoFaEnabled(this.isTwoFaEnabled());
        featuresInfo.setNotificationEnabled(this.isSlackEnabled());
        return featuresInfo;
    }

    private boolean isEmailEnabled() {
        try {
            this.mailService.testConnection(TenantId.SYS_TENANT_ID);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isTwoFaEnabled() {
        JsonNode providers;
        AdminSettings twoFaSettings = this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, "twoFaSettings");
        if (twoFaSettings != null && (providers = twoFaSettings.getJsonValue().get("providers")) != null) {
            return !providers.isEmpty();
        }
        return false;
    }

    private boolean isSlackEnabled() {
        AdminSettings notifications = this.adminSettingsService.findAdminSettingsByKey(TenantId.SYS_TENANT_ID, "notifications");
        if (notifications != null) {
            return notifications.getJsonValue().get("deliveryMethodsConfigs").has("SLACK");
        }
        return false;
    }

    private void saveCurrentClusterSystemInfo() {
        long ts = System.currentTimeMillis();
        List<SystemInfoData> clusterSystemData = this.getSystemData(this.serviceInfoProvider.getServiceInfo());
        clusterSystemData.forEach(data -> Arrays.stream(ResourcesShortageTrigger.Resource.values()).forEach(resource -> this.notificationRuleProcessor.process((NotificationRuleTrigger)ResourcesShortageTrigger.builder().resource(resource).serviceId(data.getServiceId()).serviceType(data.getServiceType()).usage(this.extractResourceUsage((SystemInfoData)data, (ResourcesShortageTrigger.Resource)resource)).build())));
        BasicTsKvEntry clusterDataKv = new BasicTsKvEntry(ts, (KvEntry)new JsonDataEntry("clusterSystemData", JacksonUtil.toString(clusterSystemData)));
        this.doSave(Arrays.asList(new BasicTsKvEntry(ts, (KvEntry)new BooleanDataEntry("clusterMode", Boolean.valueOf(true))), clusterDataKv));
    }

    private void saveCurrentMonolithSystemInfo() {
        long ts = System.currentTimeMillis();
        ArrayList<TsKvEntry> tsList = new ArrayList<TsKvEntry>();
        tsList.add((TsKvEntry)new BasicTsKvEntry(ts, (KvEntry)new BooleanDataEntry("clusterMode", Boolean.valueOf(false))));
        SystemUtil.getCpuUsage().ifPresent(v -> {
            long value = v.intValue();
            tsList.add((TsKvEntry)new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry("cpuUsage", Long.valueOf(value))));
            this.notificationRuleProcessor.process((NotificationRuleTrigger)ResourcesShortageTrigger.builder().resource(ResourcesShortageTrigger.Resource.CPU).usage(Long.valueOf(value)).serviceId(this.serviceInfoProvider.getServiceId()).serviceType(this.serviceInfoProvider.getServiceType()).build());
        });
        SystemUtil.getMemoryUsage().ifPresent(v -> {
            long value = v.intValue();
            tsList.add((TsKvEntry)new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry("memoryUsage", Long.valueOf(value))));
            this.notificationRuleProcessor.process((NotificationRuleTrigger)ResourcesShortageTrigger.builder().resource(ResourcesShortageTrigger.Resource.RAM).usage(Long.valueOf(value)).serviceId(this.serviceInfoProvider.getServiceId()).serviceType(this.serviceInfoProvider.getServiceType()).build());
        });
        SystemUtil.getDiscSpaceUsage().ifPresent(v -> {
            long value = v.intValue();
            tsList.add((TsKvEntry)new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry("discUsage", Long.valueOf(value))));
            this.notificationRuleProcessor.process((NotificationRuleTrigger)ResourcesShortageTrigger.builder().resource(ResourcesShortageTrigger.Resource.STORAGE).usage(Long.valueOf(value)).serviceId(this.serviceInfoProvider.getServiceId()).serviceType(this.serviceInfoProvider.getServiceType()).build());
        });
        SystemUtil.getCpuCount().ifPresent(v -> tsList.add((TsKvEntry)new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry("cpuCount", Long.valueOf(v.intValue())))));
        SystemUtil.getTotalMemory().ifPresent(v -> tsList.add((TsKvEntry)new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry("totalMemory", v))));
        SystemUtil.getTotalDiscSpace().ifPresent(v -> tsList.add((TsKvEntry)new BasicTsKvEntry(ts, (KvEntry)new LongDataEntry("totalDiscSpace", v))));
        this.doSave(tsList);
    }

    private void doSave(List<TsKvEntry> telemetry) {
        ApiUsageState apiUsageState = this.apiUsageStateClient.getApiUsageState(TenantId.SYS_TENANT_ID);
        this.telemetryService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(TenantId.SYS_TENANT_ID).entityId((EntityId)apiUsageState.getId()).entries(telemetry).ttl((long)this.systemInfoTtlSeconds).callback(CALLBACK).build());
    }

    private List<SystemInfoData> getSystemData(TransportProtos.ServiceInfo serviceInfo) {
        ArrayList<SystemInfoData> clusterSystemData = new ArrayList<SystemInfoData>();
        clusterSystemData.add(this.createSystemInfoData(serviceInfo));
        this.discoveryService.getOtherServers().stream().map(this::createSystemInfoData).forEach(clusterSystemData::add);
        return clusterSystemData;
    }

    private SystemInfoData createSystemInfoData(TransportProtos.ServiceInfo serviceInfo) {
        ProtocolStringList serviceTypes = serviceInfo.getServiceTypesList();
        SystemInfoData infoData = new SystemInfoData();
        infoData.setServiceId(serviceInfo.getServiceId());
        infoData.setServiceType(serviceTypes.size() > 1 ? "MONOLITH" : (String)serviceTypes.get(0));
        infoData.setCpuUsage(Long.valueOf(serviceInfo.getSystemInfo().getCpuUsage()));
        infoData.setMemoryUsage(Long.valueOf(serviceInfo.getSystemInfo().getMemoryUsage()));
        infoData.setDiscUsage(Long.valueOf(serviceInfo.getSystemInfo().getDiskUsage()));
        infoData.setCpuCount(Long.valueOf(serviceInfo.getSystemInfo().getCpuCount()));
        infoData.setTotalMemory(Long.valueOf(serviceInfo.getSystemInfo().getTotalMemory()));
        infoData.setTotalDiscSpace(Long.valueOf(serviceInfo.getSystemInfo().getTotalDiscSpace()));
        return infoData;
    }

    private Long extractResourceUsage(SystemInfoData info, ResourcesShortageTrigger.Resource resource) {
        return switch (resource) {
            default -> throw new IncompatibleClassChangeError();
            case ResourcesShortageTrigger.Resource.CPU -> info.getCpuUsage();
            case ResourcesShortageTrigger.Resource.RAM -> info.getMemoryUsage();
            case ResourcesShortageTrigger.Resource.STORAGE -> info.getDiscUsage();
        };
    }

    @PreDestroy
    private void destroy() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
    }

    @ConstructorProperties(value={"serviceInfoProvider", "partitionService", "discoveryService", "telemetryService", "apiUsageStateClient", "adminSettingsService", "domainService", "mailService", "smsService", "notificationRuleProcessor"})
    @Generated
    public DefaultSystemInfoService(TbServiceInfoProvider serviceInfoProvider, PartitionService partitionService, DiscoveryService discoveryService, TelemetrySubscriptionService telemetryService, TbApiUsageStateClient apiUsageStateClient, AdminSettingsService adminSettingsService, DomainService domainService, MailService mailService, SmsService smsService, NotificationRuleProcessor notificationRuleProcessor) {
        this.serviceInfoProvider = serviceInfoProvider;
        this.partitionService = partitionService;
        this.discoveryService = discoveryService;
        this.telemetryService = telemetryService;
        this.apiUsageStateClient = apiUsageStateClient;
        this.adminSettingsService = adminSettingsService;
        this.domainService = domainService;
        this.mailService = mailService;
        this.smsService = smsService;
        this.notificationRuleProcessor = notificationRuleProcessor;
    }
}

