/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.sync.vc;

import java.io.Serializable;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.cache.TbTransactionalCache;
import org.thingsboard.server.common.data.AdminSettings;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.dao.settings.AdminSettingsService;

public abstract class TbAbstractVersionControlSettingsService<T extends Serializable> {
    private final String settingsKey;
    private final AdminSettingsService adminSettingsService;
    private final TbTransactionalCache<TenantId, T> cache;
    private final Class<T> clazz;

    public TbAbstractVersionControlSettingsService(AdminSettingsService adminSettingsService, TbTransactionalCache<TenantId, T> cache, Class<T> clazz, String settingsKey) {
        this.adminSettingsService = adminSettingsService;
        this.cache = cache;
        this.clazz = clazz;
        this.settingsKey = settingsKey;
    }

    public T get(TenantId tenantId) {
        return (T)this.cache.getAndPutInTransaction((Serializable)tenantId, () -> {
            AdminSettings adminSettings = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, this.settingsKey);
            if (adminSettings != null) {
                try {
                    return (Serializable)JacksonUtil.convertValue((Object)adminSettings.getJsonValue(), this.clazz);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load " + this.settingsKey + " settings!", e);
                }
            }
            return null;
        }, true);
    }

    public T save(TenantId tenantId, T settings) {
        Serializable savedSettings;
        AdminSettings adminSettings = this.adminSettingsService.findAdminSettingsByTenantIdAndKey(tenantId, this.settingsKey);
        if (adminSettings == null) {
            adminSettings = new AdminSettings();
            adminSettings.setKey(this.settingsKey);
            adminSettings.setTenantId(tenantId);
        }
        adminSettings.setJsonValue(JacksonUtil.valueToTree(settings));
        AdminSettings savedAdminSettings = this.adminSettingsService.saveAdminSettings(tenantId, adminSettings);
        try {
            savedSettings = (Serializable)JacksonUtil.convertValue((Object)savedAdminSettings.getJsonValue(), this.clazz);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load auto commit settings!", e);
        }
        this.cache.evict((Serializable)tenantId);
        return (T)savedSettings;
    }

    public boolean delete(TenantId tenantId) {
        boolean result = this.adminSettingsService.deleteAdminSettingsByTenantIdAndKey(tenantId, this.settingsKey);
        this.cache.evict((Serializable)tenantId);
        return result;
    }
}

