/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.util.Map;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.subscription.TbSubscription;
import org.thingsboard.server.service.subscription.TbSubscriptionType;
import org.thingsboard.server.service.ws.telemetry.sub.TelemetrySubscriptionUpdate;

public class TbTimeSeriesSubscription
extends TbSubscription<TelemetrySubscriptionUpdate> {
    private final long queryTs;
    private final boolean allKeys;
    private final Map<String, Long> keyStates;
    private final long startTime;
    private final long endTime;
    private final boolean latestValues;

    public TbTimeSeriesSubscription(String serviceId, String sessionId, int subscriptionId, TenantId tenantId, EntityId entityId, BiConsumer<TbSubscription<TelemetrySubscriptionUpdate>, TelemetrySubscriptionUpdate> updateProcessor, long queryTs, boolean allKeys, Map<String, Long> keyStates, long startTime, long endTime, boolean latestValues) {
        super(serviceId, sessionId, subscriptionId, tenantId, entityId, TbSubscriptionType.TIMESERIES, updateProcessor);
        this.queryTs = queryTs;
        this.allKeys = allKeys;
        this.keyStates = keyStates;
        this.startTime = startTime;
        this.endTime = endTime;
        this.latestValues = latestValues;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Generated
    public static TbTimeSeriesSubscriptionBuilder builder() {
        return new TbTimeSeriesSubscriptionBuilder();
    }

    @Generated
    public long getQueryTs() {
        return this.queryTs;
    }

    @Generated
    public boolean isAllKeys() {
        return this.allKeys;
    }

    @Generated
    public Map<String, Long> getKeyStates() {
        return this.keyStates;
    }

    @Generated
    public long getStartTime() {
        return this.startTime;
    }

    @Generated
    public long getEndTime() {
        return this.endTime;
    }

    @Generated
    public boolean isLatestValues() {
        return this.latestValues;
    }

    @Generated
    public static class TbTimeSeriesSubscriptionBuilder {
        @Generated
        private String serviceId;
        @Generated
        private String sessionId;
        @Generated
        private int subscriptionId;
        @Generated
        private TenantId tenantId;
        @Generated
        private EntityId entityId;
        @Generated
        private BiConsumer<TbSubscription<TelemetrySubscriptionUpdate>, TelemetrySubscriptionUpdate> updateProcessor;
        @Generated
        private long queryTs;
        @Generated
        private boolean allKeys;
        @Generated
        private Map<String, Long> keyStates;
        @Generated
        private long startTime;
        @Generated
        private long endTime;
        @Generated
        private boolean latestValues;

        @Generated
        TbTimeSeriesSubscriptionBuilder() {
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder subscriptionId(int subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder entityId(EntityId entityId) {
            this.entityId = entityId;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder updateProcessor(BiConsumer<TbSubscription<TelemetrySubscriptionUpdate>, TelemetrySubscriptionUpdate> updateProcessor) {
            this.updateProcessor = updateProcessor;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder queryTs(long queryTs) {
            this.queryTs = queryTs;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder allKeys(boolean allKeys) {
            this.allKeys = allKeys;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder keyStates(Map<String, Long> keyStates) {
            this.keyStates = keyStates;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscriptionBuilder latestValues(boolean latestValues) {
            this.latestValues = latestValues;
            return this;
        }

        @Generated
        public TbTimeSeriesSubscription build() {
            return new TbTimeSeriesSubscription(this.serviceId, this.sessionId, this.subscriptionId, this.tenantId, this.entityId, this.updateProcessor, this.queryTs, this.allKeys, this.keyStates, this.startTime, this.endTime, this.latestValues);
        }

        @Generated
        public String toString() {
            return "TbTimeSeriesSubscription.TbTimeSeriesSubscriptionBuilder(serviceId=" + this.serviceId + ", sessionId=" + this.sessionId + ", subscriptionId=" + this.subscriptionId + ", tenantId=" + String.valueOf(this.tenantId) + ", entityId=" + String.valueOf(this.entityId) + ", updateProcessor=" + String.valueOf(this.updateProcessor) + ", queryTs=" + this.queryTs + ", allKeys=" + this.allKeys + ", keyStates=" + String.valueOf(this.keyStates) + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", latestValues=" + this.latestValues + ")";
        }
    }
}

