/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.subscription;

import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.service.subscription.TbEntitySubEvent;
import org.thingsboard.server.service.subscription.TbSubscriptionsInfo;

public class TbEntityRemoteSubsInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TbEntityRemoteSubsInfo.class);
    private final TenantId tenantId;
    private final EntityId entityId;
    private final Map<String, TbSubscriptionsInfo> subs = new ConcurrentHashMap<String, TbSubscriptionsInfo>();

    public boolean updateAndCheckIsEmpty(String serviceId, TbEntitySubEvent event) {
        TbSubscriptionsInfo current = this.subs.get(serviceId);
        if (current != null && current.seqNumber > event.getSeqNumber()) {
            log.warn("[{}][{}] Duplicate subscription event received. Current: {}, Event: {}", new Object[]{this.tenantId, this.entityId, current, event.getInfo()});
            return false;
        }
        switch (event.getType()) {
            case CREATED: {
                this.subs.put(serviceId, event.getInfo());
                break;
            }
            case UPDATED: {
                TbSubscriptionsInfo newSubInfo = event.getInfo();
                if (newSubInfo.isEmpty()) {
                    this.subs.remove(serviceId);
                    return this.isEmpty();
                }
                this.subs.put(serviceId, newSubInfo);
                break;
            }
            case DELETED: {
                this.subs.remove(serviceId);
                return this.isEmpty();
            }
        }
        return false;
    }

    public boolean removeAndCheckIsEmpty(String serviceId) {
        if (this.subs.remove(serviceId) != null) {
            return this.subs.isEmpty();
        }
        return false;
    }

    public boolean isEmpty() {
        return this.subs.isEmpty();
    }

    @ConstructorProperties(value={"tenantId", "entityId"})
    @Generated
    public TbEntityRemoteSubsInfo(TenantId tenantId, EntityId entityId) {
        this.tenantId = tenantId;
        this.entityId = entityId;
    }

    @Generated
    public TenantId getTenantId() {
        return this.tenantId;
    }

    @Generated
    public EntityId getEntityId() {
        return this.entityId;
    }

    @Generated
    public Map<String, TbSubscriptionsInfo> getSubs() {
        return this.subs;
    }
}

