/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.service.state;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.rule.engine.api.AttributesSaveRequest;
import org.thingsboard.rule.engine.api.TimeseriesSaveRequest;
import org.thingsboard.server.cluster.TbClusterService;
import org.thingsboard.server.common.data.ApiUsageRecordKey;
import org.thingsboard.server.common.data.AttributeScope;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceIdInfo;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.exception.TenantNotFoundException;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.kv.AttributeKvEntry;
import org.thingsboard.server.common.data.kv.BaseAttributeKvEntry;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.BooleanDataEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.LongDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.common.data.msg.TbMsgType;
import org.thingsboard.server.common.data.notification.rule.trigger.DeviceActivityTrigger;
import org.thingsboard.server.common.data.notification.rule.trigger.NotificationRuleTrigger;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageDataIterable;
import org.thingsboard.server.common.data.query.EntityData;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.query.EntityFilter;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.EntityListFilter;
import org.thingsboard.server.common.data.query.TsValue;
import org.thingsboard.server.common.msg.TbMsg;
import org.thingsboard.server.common.msg.TbMsgDataType;
import org.thingsboard.server.common.msg.TbMsgMetaData;
import org.thingsboard.server.common.msg.notification.NotificationRuleProcessor;
import org.thingsboard.server.common.msg.queue.ServiceType;
import org.thingsboard.server.common.msg.queue.TbCallback;
import org.thingsboard.server.common.msg.queue.TopicPartitionInfo;
import org.thingsboard.server.common.stats.TbApiUsageReportClient;
import org.thingsboard.server.dao.attributes.AttributesService;
import org.thingsboard.server.dao.device.DeviceService;
import org.thingsboard.server.dao.sql.query.EntityQueryRepository;
import org.thingsboard.server.dao.timeseries.TimeseriesService;
import org.thingsboard.server.dao.util.DbTypeInfoComponent;
import org.thingsboard.server.gen.transport.TransportProtos;
import org.thingsboard.server.queue.discovery.PartitionService;
import org.thingsboard.server.queue.util.TbCoreComponent;
import org.thingsboard.server.service.partition.AbstractPartitionBasedService;
import org.thingsboard.server.service.state.DeviceState;
import org.thingsboard.server.service.state.DeviceStateData;
import org.thingsboard.server.service.state.DeviceStateService;
import org.thingsboard.server.service.telemetry.TelemetrySubscriptionService;

@Service
@TbCoreComponent
public class DefaultDeviceStateService
extends AbstractPartitionBasedService<DeviceId>
implements DeviceStateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDeviceStateService.class);
    public static final String ACTIVITY_STATE = "active";
    public static final String LAST_CONNECT_TIME = "lastConnectTime";
    public static final String LAST_DISCONNECT_TIME = "lastDisconnectTime";
    public static final String LAST_ACTIVITY_TIME = "lastActivityTime";
    public static final String INACTIVITY_ALARM_TIME = "inactivityAlarmTime";
    public static final String INACTIVITY_TIMEOUT = "inactivityTimeout";
    private static final List<EntityKey> PERSISTENT_TELEMETRY_KEYS = Arrays.asList(new EntityKey(EntityKeyType.TIME_SERIES, "lastActivityTime"), new EntityKey(EntityKeyType.TIME_SERIES, "inactivityAlarmTime"), new EntityKey(EntityKeyType.TIME_SERIES, "active"), new EntityKey(EntityKeyType.TIME_SERIES, "lastConnectTime"), new EntityKey(EntityKeyType.TIME_SERIES, "lastDisconnectTime"), new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, "inactivityTimeout"));
    private static final List<EntityKey> PERSISTENT_ATTRIBUTE_KEYS = Arrays.asList(new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, "lastActivityTime"), new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, "inactivityAlarmTime"), new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, "inactivityTimeout"), new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, "active"), new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, "lastConnectTime"), new EntityKey(EntityKeyType.SERVER_ATTRIBUTE, "lastDisconnectTime"));
    public static final Set<String> ACTIVITY_KEYS_WITHOUT_INACTIVITY_TIMEOUT = Set.of("active", "lastConnectTime", "lastDisconnectTime", "lastActivityTime", "inactivityAlarmTime");
    public static final Set<String> ACTIVITY_KEYS_WITH_INACTIVITY_TIMEOUT = Set.of("active", "lastConnectTime", "lastDisconnectTime", "lastActivityTime", "inactivityAlarmTime", "inactivityTimeout");
    private static final List<EntityKey> PERSISTENT_ENTITY_FIELDS = Arrays.asList(new EntityKey(EntityKeyType.ENTITY_FIELD, "name"), new EntityKey(EntityKeyType.ENTITY_FIELD, "type"), new EntityKey(EntityKeyType.ENTITY_FIELD, "label"), new EntityKey(EntityKeyType.ENTITY_FIELD, "createdTime"));
    private final DeviceService deviceService;
    private final AttributesService attributesService;
    private final TimeseriesService tsService;
    private final TbClusterService clusterService;
    private final PartitionService partitionService;
    private final EntityQueryRepository entityQueryRepository;
    private final DbTypeInfoComponent dbTypeInfoComponent;
    private final TbApiUsageReportClient apiUsageReportClient;
    private final NotificationRuleProcessor notificationRuleProcessor;
    @Autowired
    @Lazy
    private TelemetrySubscriptionService tsSubService;
    @Value(value="#{${state.defaultInactivityTimeoutInSec} * 1000}")
    private long defaultInactivityTimeoutMs;
    @Value(value="${state.defaultStateCheckIntervalInSec}")
    private int defaultStateCheckIntervalInSec;
    @Value(value="${usage.stats.devices.report_interval:60}")
    private int defaultActivityStatsIntervalInSec;
    @Value(value="${state.persistToTelemetry:false}")
    private boolean persistToTelemetry;
    @Value(value="${state.initFetchPackSize:50000}")
    private int initFetchPackSize;
    @Value(value="${state.telemetryTtl:0}")
    private int telemetryTtl;
    private ListeningExecutorService deviceStateExecutor;
    private ListeningExecutorService deviceStateCallbackExecutor;
    final ConcurrentMap<DeviceId, DeviceStateData> deviceStates = new ConcurrentHashMap<DeviceId, DeviceStateData>();

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.deviceStateExecutor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (String)"device-state"));
        this.deviceStateCallbackExecutor = MoreExecutors.listeningDecorator((ExecutorService)ThingsBoardExecutors.newWorkStealingPool((int)Math.max(4, Runtime.getRuntime().availableProcessors()), (String)"device-state-callback"));
        this.scheduledExecutor.scheduleWithFixedDelay(this::checkStates, (long)new Random().nextInt(this.defaultStateCheckIntervalInSec), (long)this.defaultStateCheckIntervalInSec, TimeUnit.SECONDS);
        this.scheduledExecutor.scheduleWithFixedDelay(this::reportActivityStats, (long)this.defaultActivityStatsIntervalInSec, (long)this.defaultActivityStatsIntervalInSec, TimeUnit.SECONDS);
    }

    @Override
    @PreDestroy
    public void stop() {
        super.stop();
        if (this.deviceStateExecutor != null) {
            this.deviceStateExecutor.shutdownNow();
        }
        if (this.deviceStateCallbackExecutor != null) {
            this.deviceStateCallbackExecutor.shutdownNow();
        }
    }

    @Override
    protected String getServiceName() {
        return "Device State";
    }

    @Override
    protected String getSchedulerExecutorName() {
        return "device-state-scheduled";
    }

    @Override
    public void onDeviceConnect(TenantId tenantId, DeviceId deviceId, long lastConnectTime) {
        if (this.cleanDeviceStateIfBelongsToExternalPartition(tenantId, deviceId)) {
            return;
        }
        if (lastConnectTime < 0L) {
            log.trace("[{}][{}] On device connect: received negative last connect ts [{}]. Skipping this event.", new Object[]{tenantId.getId(), deviceId.getId(), lastConnectTime});
            return;
        }
        DeviceStateData stateData = this.getOrFetchDeviceStateData(deviceId);
        long currentLastConnectTime = stateData.getState().getLastConnectTime();
        if (lastConnectTime <= currentLastConnectTime) {
            log.trace("[{}][{}] On device connect: received outdated last connect ts [{}]. Skipping this event. Current last connect ts [{}].", new Object[]{tenantId.getId(), deviceId.getId(), lastConnectTime, currentLastConnectTime});
            return;
        }
        log.trace("[{}][{}] On device connect: processing connect event with ts [{}].", new Object[]{tenantId.getId(), deviceId.getId(), lastConnectTime});
        stateData.getState().setLastConnectTime(lastConnectTime);
        this.save(tenantId, deviceId, LAST_CONNECT_TIME, lastConnectTime);
        this.pushRuleEngineMessage(stateData, TbMsgType.CONNECT_EVENT);
        this.checkAndUpdateState(deviceId, stateData);
    }

    @Override
    public void onDeviceActivity(TenantId tenantId, DeviceId deviceId, long lastReportedActivity) {
        if (this.cleanDeviceStateIfBelongsToExternalPartition(tenantId, deviceId)) {
            return;
        }
        log.trace("[{}] on Device Activity [{}], lastReportedActivity [{}]", new Object[]{tenantId.getId(), deviceId.getId(), lastReportedActivity});
        DeviceStateData stateData = this.getOrFetchDeviceStateData(deviceId);
        if (lastReportedActivity > 0L && lastReportedActivity > stateData.getState().getLastActivityTime()) {
            this.updateActivityState(deviceId, stateData, lastReportedActivity);
        }
    }

    void updateActivityState(DeviceId deviceId, DeviceStateData stateData, long lastReportedActivity) {
        log.trace("updateActivityState - fetched state {} for device {}, lastReportedActivity {}", new Object[]{stateData, deviceId, lastReportedActivity});
        if (stateData != null) {
            this.save(stateData.getTenantId(), deviceId, LAST_ACTIVITY_TIME, lastReportedActivity);
            DeviceState state = stateData.getState();
            state.setLastActivityTime(lastReportedActivity);
            if (!state.isActive()) {
                if (lastReportedActivity <= state.getLastInactivityAlarmTime()) {
                    state.setLastInactivityAlarmTime(0L);
                    this.save(stateData.getTenantId(), deviceId, INACTIVITY_ALARM_TIME, 0L);
                }
                this.onDeviceActivityStatusChange(true, stateData);
            }
        } else {
            log.debug("updateActivityState - fetched state IS NULL for device {}, lastReportedActivity {}", (Object)deviceId, (Object)lastReportedActivity);
            this.cleanupEntity(deviceId);
        }
    }

    @Override
    public void onDeviceDisconnect(TenantId tenantId, DeviceId deviceId, long lastDisconnectTime) {
        if (this.cleanDeviceStateIfBelongsToExternalPartition(tenantId, deviceId)) {
            return;
        }
        if (lastDisconnectTime < 0L) {
            log.trace("[{}][{}] On device disconnect: received negative last disconnect ts [{}]. Skipping this event.", new Object[]{tenantId.getId(), deviceId.getId(), lastDisconnectTime});
            return;
        }
        DeviceStateData stateData = this.getOrFetchDeviceStateData(deviceId);
        long currentLastDisconnectTime = stateData.getState().getLastDisconnectTime();
        if (lastDisconnectTime <= currentLastDisconnectTime) {
            log.trace("[{}][{}] On device disconnect: received outdated last disconnect ts [{}]. Skipping this event. Current last disconnect ts [{}].", new Object[]{tenantId.getId(), deviceId.getId(), lastDisconnectTime, currentLastDisconnectTime});
            return;
        }
        log.trace("[{}][{}] On device disconnect: processing disconnect event with ts [{}].", new Object[]{tenantId.getId(), deviceId.getId(), lastDisconnectTime});
        stateData.getState().setLastDisconnectTime(lastDisconnectTime);
        this.save(tenantId, deviceId, LAST_DISCONNECT_TIME, lastDisconnectTime);
        this.pushRuleEngineMessage(stateData, TbMsgType.DISCONNECT_EVENT);
    }

    @Override
    public void onDeviceInactivityTimeoutUpdate(TenantId tenantId, DeviceId deviceId, long inactivityTimeout) {
        if (this.cleanDeviceStateIfBelongsToExternalPartition(tenantId, deviceId)) {
            return;
        }
        if (inactivityTimeout <= 0L) {
            inactivityTimeout = this.defaultInactivityTimeoutMs;
        }
        log.trace("[{}] on Device Activity Timeout Update device id {} inactivityTimeout {}", new Object[]{tenantId.getId(), deviceId.getId(), inactivityTimeout});
        DeviceStateData stateData = this.getOrFetchDeviceStateData(deviceId);
        stateData.getState().setInactivityTimeout(inactivityTimeout);
        this.checkAndUpdateState(deviceId, stateData);
    }

    @Override
    public void onDeviceInactivity(TenantId tenantId, DeviceId deviceId, long lastInactivityTime) {
        if (this.cleanDeviceStateIfBelongsToExternalPartition(tenantId, deviceId)) {
            return;
        }
        if (lastInactivityTime < 0L) {
            log.trace("[{}][{}] On device inactivity: received negative last inactivity ts [{}]. Skipping this event.", new Object[]{tenantId.getId(), deviceId.getId(), lastInactivityTime});
            return;
        }
        DeviceStateData stateData = this.getOrFetchDeviceStateData(deviceId);
        long currentLastInactivityAlarmTime = stateData.getState().getLastInactivityAlarmTime();
        if (lastInactivityTime <= currentLastInactivityAlarmTime) {
            log.trace("[{}][{}] On device inactivity: received last inactivity ts [{}] is less than current last inactivity ts [{}]. Skipping this event.", new Object[]{tenantId.getId(), deviceId.getId(), lastInactivityTime, currentLastInactivityAlarmTime});
            return;
        }
        long currentLastActivityTime = stateData.getState().getLastActivityTime();
        if (lastInactivityTime <= currentLastActivityTime) {
            log.trace("[{}][{}] On device inactivity: received last inactivity ts [{}] is less or equal to current last activity ts [{}]. Skipping this event.", new Object[]{tenantId.getId(), deviceId.getId(), lastInactivityTime, currentLastActivityTime});
            return;
        }
        log.trace("[{}][{}] On device inactivity: processing inactivity event with ts [{}].", new Object[]{tenantId.getId(), deviceId.getId(), lastInactivityTime});
        this.reportInactivity(lastInactivityTime, stateData);
    }

    @Override
    public void onQueueMsg(TransportProtos.DeviceStateServiceMsgProto proto, final TbCallback callback) {
        try {
            final TenantId tenantId = TenantId.fromUUID((UUID)new UUID(proto.getTenantIdMSB(), proto.getTenantIdLSB()));
            final DeviceId deviceId = new DeviceId(new UUID(proto.getDeviceIdMSB(), proto.getDeviceIdLSB()));
            if (proto.getDeleted()) {
                this.onDeviceDeleted(tenantId, deviceId);
                callback.onSuccess();
            } else {
                final Device device = this.deviceService.findDeviceById(TenantId.SYS_TENANT_ID, deviceId);
                if (device != null) {
                    if (proto.getAdded()) {
                        Futures.addCallback(this.fetchDeviceState(device), (FutureCallback)new FutureCallback<DeviceStateData>(){

                            public void onSuccess(DeviceStateData state) {
                                boolean isMyPartition;
                                TopicPartitionInfo tpi = DefaultDeviceStateService.this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)device.getId());
                                Set deviceIds = (Set)DefaultDeviceStateService.this.partitionedEntities.get(tpi);
                                boolean bl = isMyPartition = deviceIds != null;
                                if (isMyPartition) {
                                    deviceIds.add(state.getDeviceId());
                                    DefaultDeviceStateService.this.initializeActivityState(deviceId, state);
                                    callback.onSuccess();
                                } else {
                                    log.debug("[{}][{}] Device belongs to external partition. Probably rebalancing is in progress. Topic: {}", new Object[]{tenantId, deviceId, tpi.getFullTopicName()});
                                    callback.onFailure((Throwable)new RuntimeException("Device belongs to external partition " + tpi.getFullTopicName() + "!"));
                                }
                            }

                            public void onFailure(@NonNull Throwable t) {
                                log.warn("Failed to register device to the state service", t);
                                callback.onFailure(t);
                            }
                        }, (Executor)this.deviceStateCallbackExecutor);
                    } else if (proto.getUpdated()) {
                        DeviceStateData stateData = this.getOrFetchDeviceStateData(device.getId());
                        TbMsgMetaData md = new TbMsgMetaData();
                        md.putValue("deviceName", device.getName());
                        md.putValue("deviceLabel", device.getLabel());
                        md.putValue("deviceType", device.getType());
                        stateData.setMetaData(md);
                        callback.onSuccess();
                    }
                } else {
                    callback.onSuccess();
                }
            }
        }
        catch (Exception e) {
            log.trace("Failed to process queue msg: [{}]", (Object)proto, (Object)e);
            callback.onFailure((Throwable)e);
        }
    }

    private void onDeviceDeleted(TenantId tenantId, DeviceId deviceId) {
        this.cleanupEntity(deviceId);
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)deviceId);
        Set deviceIdSet = (Set)this.partitionedEntities.get(tpi);
        if (deviceIdSet != null) {
            deviceIdSet.remove(deviceId);
        }
    }

    private void initializeActivityState(DeviceId deviceId, DeviceStateData fetchedState) {
        DeviceStateData cachedState = this.deviceStates.putIfAbsent(fetchedState.getDeviceId(), fetchedState);
        boolean activityState = Objects.requireNonNullElse(cachedState, fetchedState).getState().isActive();
        this.save(fetchedState.getTenantId(), deviceId, ACTIVITY_STATE, activityState);
    }

    @Override
    protected Map<TopicPartitionInfo, List<ListenableFuture<?>>> onAddedPartitions(Set<TopicPartitionInfo> addedPartitions) {
        HashMap result = new HashMap();
        PageDataIterable deviceIdInfos = new PageDataIterable(arg_0 -> ((DeviceService)this.deviceService).findDeviceIdInfos(arg_0), this.initFetchPackSize);
        HashMap<TopicPartitionInfo, List> tpiDeviceMap = new HashMap<TopicPartitionInfo, List>();
        for (DeviceIdInfo idInfo : deviceIdInfos) {
            TopicPartitionInfo tpi;
            try {
                tpi = this.partitionService.resolve(ServiceType.TB_CORE, idInfo.getTenantId(), (EntityId)idInfo.getDeviceId());
            }
            catch (Exception e) {
                log.warn("Failed to resolve partition for device with id [{}], tenant id [{}], customer id [{}]. Reason: {}", new Object[]{idInfo.getDeviceId(), idInfo.getTenantId(), idInfo.getCustomerId(), e.getMessage()});
                continue;
            }
            if (!addedPartitions.contains(tpi) || this.deviceStates.containsKey(idInfo.getDeviceId())) continue;
            tpiDeviceMap.computeIfAbsent(tpi, tmp -> new ArrayList()).add(idInfo);
        }
        for (Map.Entry entry : tpiDeviceMap.entrySet()) {
            AtomicInteger counter = new AtomicInteger(0);
            for (List partition : Lists.partition((List)((List)entry.getValue()), (int)1000)) {
                ListenableFuture devicePackFuture;
                log.info("[{}] Submit task for device states: {}", entry.getKey(), (Object)partition.size());
                DevicePackFutureHolder devicePackFutureHolder = new DevicePackFutureHolder();
                devicePackFutureHolder.future = devicePackFuture = this.deviceStateExecutor.submit(() -> {
                    try {
                        List<DeviceStateData> states = this.persistToTelemetry && !this.dbTypeInfoComponent.isLatestTsDaoStoredToSql() ? this.fetchDeviceStateDataUsingSeparateRequests(partition) : this.fetchDeviceStateDataUsingEntityDataQuery(partition);
                        if (devicePackFutureHolder.future == null || !devicePackFutureHolder.future.isCancelled()) {
                            for (DeviceStateData state : states) {
                                boolean isMyPartition;
                                TopicPartitionInfo tpi = (TopicPartitionInfo)entry.getKey();
                                Set deviceIds = (Set)this.partitionedEntities.get(tpi);
                                boolean bl = isMyPartition = deviceIds != null;
                                if (isMyPartition) {
                                    deviceIds.add(state.getDeviceId());
                                    this.deviceStates.putIfAbsent(state.getDeviceId(), state);
                                    this.checkAndUpdateState(state.getDeviceId(), state);
                                    continue;
                                }
                                log.debug("[{}] Device belongs to external partition {}", (Object)state.getDeviceId(), (Object)tpi.getFullTopicName());
                            }
                            log.info("[{}] Initialized {} out of {} device states", new Object[]{((TopicPartitionInfo)entry.getKey()).getPartition().orElse(0), counter.addAndGet(states.size()), ((List)entry.getValue()).size()});
                        }
                    }
                    catch (Throwable t) {
                        log.error("Unexpected exception while device pack fetching", t);
                        throw t;
                    }
                });
                result.computeIfAbsent((TopicPartitionInfo)entry.getKey(), tmp -> new ArrayList()).add(devicePackFuture);
            }
        }
        return result;
    }

    void checkAndUpdateState(@Nonnull DeviceId deviceId, @Nonnull DeviceStateData state) {
        DeviceState deviceState = state.getState();
        if (deviceState.isActive()) {
            this.updateInactivityStateIfExpired(this.getCurrentTimeMillis(), deviceId, state);
        } else if (DefaultDeviceStateService.isActive(this.getCurrentTimeMillis(), deviceState)) {
            this.updateActivityState(deviceId, state, deviceState.getLastActivityTime());
            if (deviceState.getLastInactivityAlarmTime() != 0L && deviceState.getLastInactivityAlarmTime() >= deviceState.getLastActivityTime()) {
                deviceState.setLastInactivityAlarmTime(0L);
                this.save(state.getTenantId(), deviceId, INACTIVITY_ALARM_TIME, 0L);
            }
        }
    }

    void checkStates() {
        try {
            long ts = this.getCurrentTimeMillis();
            this.partitionedEntities.forEach((tpi, deviceIds) -> {
                log.debug("Calculating state updates. tpi {} for {} devices", (Object)tpi.getFullTopicName(), (Object)deviceIds.size());
                HashSet<DeviceId> idsFromRemovedTenant = new HashSet<DeviceId>();
                for (DeviceId deviceId : deviceIds) {
                    DeviceStateData stateData;
                    try {
                        stateData = this.getOrFetchDeviceStateData(deviceId);
                    }
                    catch (Exception e) {
                        log.error("[{}] Failed to get or fetch device state data", (Object)deviceId, (Object)e);
                        continue;
                    }
                    try {
                        this.updateInactivityStateIfExpired(ts, deviceId, stateData);
                    }
                    catch (Exception e) {
                        if (e instanceof TenantNotFoundException) {
                            idsFromRemovedTenant.add(deviceId);
                            continue;
                        }
                        log.warn("[{}] Failed to update inactivity state [{}]", (Object)deviceId, (Object)e.getMessage());
                    }
                }
                deviceIds.removeAll(idsFromRemovedTenant);
            });
        }
        catch (Throwable t) {
            log.warn("Failed to check devices states", t);
        }
    }

    private void reportActivityStats() {
        try {
            HashMap<TenantId, Pair> stats = new HashMap<TenantId, Pair>();
            for (DeviceStateData stateData : this.deviceStates.values()) {
                Pair tenantDevicesActivity2 = stats.computeIfAbsent(stateData.getTenantId(), tenantId -> Pair.of((Object)new AtomicInteger(), (Object)new AtomicInteger()));
                if (stateData.getState().isActive()) {
                    ((AtomicInteger)tenantDevicesActivity2.getLeft()).incrementAndGet();
                    continue;
                }
                ((AtomicInteger)tenantDevicesActivity2.getRight()).incrementAndGet();
            }
            stats.forEach((tenantId, tenantDevicesActivity) -> {
                int active = ((AtomicInteger)tenantDevicesActivity.getLeft()).get();
                int inactive = ((AtomicInteger)tenantDevicesActivity.getRight()).get();
                this.apiUsageReportClient.report(tenantId, null, ApiUsageRecordKey.ACTIVE_DEVICES, (long)active);
                this.apiUsageReportClient.report(tenantId, null, ApiUsageRecordKey.INACTIVE_DEVICES, (long)inactive);
                if (active > 0) {
                    log.debug("[{}] Active devices: {}, inactive devices: {}", new Object[]{tenantId, active, inactive});
                }
            });
        }
        catch (Throwable t) {
            log.warn("Failed to report activity states", t);
        }
    }

    void updateInactivityStateIfExpired(long ts, DeviceId deviceId, DeviceStateData stateData) {
        log.trace("Processing state {} for device {}", (Object)stateData, (Object)deviceId);
        if (stateData != null) {
            DeviceState state = stateData.getState();
            if (!(DefaultDeviceStateService.isActive(ts, state) || state.getLastInactivityAlarmTime() != 0L && state.getLastInactivityAlarmTime() > state.getLastActivityTime() || stateData.getDeviceCreationTime() + state.getInactivityTimeout() > ts)) {
                if (this.partitionService.resolve(ServiceType.TB_CORE, stateData.getTenantId(), (EntityId)deviceId).isMyPartition()) {
                    this.reportInactivity(ts, stateData);
                } else {
                    this.cleanupEntity(deviceId);
                }
            }
        } else {
            log.debug("[{}] Device that belongs to other server is detected and removed.", (Object)deviceId);
            this.cleanupEntity(deviceId);
        }
    }

    private void reportInactivity(final long ts, final DeviceStateData stateData) {
        final TenantId tenantId = stateData.getTenantId();
        final DeviceId deviceId = stateData.getDeviceId();
        Futures.addCallback(this.save(stateData.getTenantId(), deviceId, INACTIVITY_ALARM_TIME, ts), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void success) {
                stateData.getState().setLastInactivityAlarmTime(ts);
                DefaultDeviceStateService.this.onDeviceActivityStatusChange(false, stateData);
            }

            public void onFailure(@NonNull Throwable t) {
                log.error("[{}][{}] Failed to update device last inactivity alarm time to '{}'. Device state data: {}", new Object[]{tenantId, deviceId, ts, stateData, t});
            }
        }, (Executor)this.deviceStateCallbackExecutor);
    }

    private static boolean isActive(long ts, DeviceState state) {
        return ts < state.getLastActivityTime() + state.getInactivityTimeout();
    }

    @Nonnull
    DeviceStateData getOrFetchDeviceStateData(DeviceId deviceId) {
        return this.deviceStates.computeIfAbsent(deviceId, this::fetchDeviceStateDataUsingSeparateRequests);
    }

    DeviceStateData fetchDeviceStateDataUsingSeparateRequests(DeviceId deviceId) {
        Device device = this.deviceService.findDeviceById(TenantId.SYS_TENANT_ID, deviceId);
        if (device == null) {
            log.warn("[{}] Failed to fetch device by Id!", (Object)deviceId);
            throw new RuntimeException("Failed to fetch device by id [" + String.valueOf(deviceId) + "]!");
        }
        try {
            return (DeviceStateData)this.fetchDeviceState(device).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("[{}] Failed to fetch device state!", (Object)deviceId, (Object)e);
            throw new RuntimeException("Failed to fetch device state for device [" + String.valueOf(deviceId) + "]");
        }
    }

    private void onDeviceActivityStatusChange(final boolean active, final DeviceStateData stateData) {
        final TenantId tenantId = stateData.getTenantId();
        final DeviceId deviceId = stateData.getDeviceId();
        Futures.addCallback(this.save(tenantId, deviceId, ACTIVITY_STATE, active), (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void success) {
                stateData.getState().setActive(active);
                DefaultDeviceStateService.this.pushRuleEngineMessage(stateData, active ? TbMsgType.ACTIVITY_EVENT : TbMsgType.INACTIVITY_EVENT);
                TbMsgMetaData metaData = stateData.getMetaData();
                DefaultDeviceStateService.this.notificationRuleProcessor.process((NotificationRuleTrigger)DeviceActivityTrigger.builder().tenantId(tenantId).customerId(stateData.getCustomerId()).deviceId(deviceId).active(active).deviceName(metaData.getValue("deviceName")).deviceType(metaData.getValue("deviceType")).deviceLabel(metaData.getValue("deviceLabel")).build());
            }

            public void onFailure(@NonNull Throwable t) {
                log.error("[{}][{}] Failed to change device activity status to '{}'. Device state data: {}", new Object[]{tenantId, deviceId, active, stateData, t});
            }
        }, (Executor)this.deviceStateCallbackExecutor);
    }

    boolean cleanDeviceStateIfBelongsToExternalPartition(TenantId tenantId, DeviceId deviceId) {
        boolean cleanup;
        TopicPartitionInfo tpi = this.partitionService.resolve(ServiceType.TB_CORE, tenantId, (EntityId)deviceId);
        boolean bl = cleanup = !this.partitionedEntities.containsKey(tpi);
        if (cleanup) {
            this.cleanupEntity(deviceId);
            log.debug("[{}][{}] device belongs to external partition. Probably rebalancing is in progress. Topic: {}", new Object[]{tenantId, deviceId, tpi.getFullTopicName()});
        }
        return cleanup;
    }

    @Override
    protected void cleanupEntityOnPartitionRemoval(DeviceId deviceId) {
        this.cleanupEntity(deviceId);
    }

    private void cleanupEntity(DeviceId deviceId) {
        this.deviceStates.remove(deviceId);
    }

    private ListenableFuture<DeviceStateData> fetchDeviceState(Device device) {
        ListenableFuture future;
        if (this.persistToTelemetry) {
            ListenableFuture timeseriesActivityDataFuture = this.tsService.findLatest(TenantId.SYS_TENANT_ID, (EntityId)device.getId(), ACTIVITY_KEYS_WITHOUT_INACTIVITY_TIMEOUT);
            ListenableFuture inactivityTimeoutAttributeFuture = this.attributesService.find(TenantId.SYS_TENANT_ID, (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, INACTIVITY_TIMEOUT);
            ListenableFuture fullActivityDataFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{timeseriesActivityDataFuture, inactivityTimeoutAttributeFuture}).call(() -> {
                List activityTimeseries = (List)Futures.getDone((Future)timeseriesActivityDataFuture);
                Optional inactivityTimeoutAttribute = (Optional)Futures.getDone((Future)inactivityTimeoutAttributeFuture);
                if (inactivityTimeoutAttribute.isPresent()) {
                    ArrayList<KvEntry> result = new ArrayList<KvEntry>(activityTimeseries.size() + 1);
                    result.addAll(activityTimeseries);
                    result.add((KvEntry)inactivityTimeoutAttribute.get());
                    return result;
                }
                return activityTimeseries;
            }, (Executor)this.deviceStateCallbackExecutor);
            future = Futures.transform((ListenableFuture)fullActivityDataFuture, this.extractDeviceStateData(device), (Executor)MoreExecutors.directExecutor());
        } else {
            ListenableFuture attributesActivityDataFuture = this.attributesService.find(TenantId.SYS_TENANT_ID, (EntityId)device.getId(), AttributeScope.SERVER_SCOPE, ACTIVITY_KEYS_WITH_INACTIVITY_TIMEOUT);
            future = Futures.transform((ListenableFuture)attributesActivityDataFuture, this.extractDeviceStateData(device), (Executor)MoreExecutors.directExecutor());
        }
        return future;
    }

    private Function<List<? extends KvEntry>, DeviceStateData> extractDeviceStateData(final Device device) {
        return new Function<List<? extends KvEntry>, DeviceStateData>(){

            @Nonnull
            public DeviceStateData apply(@Nullable List<? extends KvEntry> data) {
                try {
                    long lastActivityTime = DefaultDeviceStateService.this.getEntryValue(data, DefaultDeviceStateService.LAST_ACTIVITY_TIME, 0L);
                    long inactivityAlarmTime = DefaultDeviceStateService.this.getEntryValue(data, DefaultDeviceStateService.INACTIVITY_ALARM_TIME, 0L);
                    long inactivityTimeout = DefaultDeviceStateService.this.getEntryValue(data, DefaultDeviceStateService.INACTIVITY_TIMEOUT, DefaultDeviceStateService.this.defaultInactivityTimeoutMs);
                    boolean active = DefaultDeviceStateService.this.getEntryValue(data, DefaultDeviceStateService.ACTIVITY_STATE, false);
                    DeviceState deviceState = DeviceState.builder().active(active).lastConnectTime(DefaultDeviceStateService.this.getEntryValue(data, DefaultDeviceStateService.LAST_CONNECT_TIME, 0L)).lastDisconnectTime(DefaultDeviceStateService.this.getEntryValue(data, DefaultDeviceStateService.LAST_DISCONNECT_TIME, 0L)).lastActivityTime(lastActivityTime).lastInactivityAlarmTime(inactivityAlarmTime).inactivityTimeout(inactivityTimeout > 0L ? inactivityTimeout : DefaultDeviceStateService.this.defaultInactivityTimeoutMs).build();
                    TbMsgMetaData md = new TbMsgMetaData();
                    md.putValue("deviceName", device.getName());
                    md.putValue("deviceLabel", device.getLabel());
                    md.putValue("deviceType", device.getType());
                    DeviceStateData deviceStateData = DeviceStateData.builder().customerId(device.getCustomerId()).tenantId(device.getTenantId()).deviceId(device.getId()).deviceCreationTime(device.getCreatedTime()).metaData(md).state(deviceState).build();
                    log.debug("[{}] Fetched device state from the DB {}", (Object)device.getId(), (Object)deviceStateData);
                    return deviceStateData;
                }
                catch (Exception e) {
                    log.warn("[{}] Failed to fetch device state data", (Object)device.getId(), (Object)e);
                    throw new RuntimeException("Failed to fetch device state data for device [" + String.valueOf(device.getId()) + "]", e);
                }
            }
        };
    }

    private List<DeviceStateData> fetchDeviceStateDataUsingSeparateRequests(List<DeviceIdInfo> deviceIds) {
        List devices = this.deviceService.findDevicesByIds(deviceIds.stream().map(DeviceIdInfo::getDeviceId).collect(Collectors.toList()));
        ArrayList<ListenableFuture<DeviceStateData>> deviceStateFutures = new ArrayList<ListenableFuture<DeviceStateData>>();
        for (Device device : devices) {
            deviceStateFutures.add(this.fetchDeviceState(device));
        }
        try {
            List result = (List)Futures.successfulAsList(deviceStateFutures).get(5L, TimeUnit.MINUTES);
            boolean success = true;
            for (int i = 0; i < result.size(); ++i) {
                success = false;
                if (result.get(i) != null) continue;
                DeviceIdInfo deviceIdInfo = deviceIds.get(i);
                log.warn("[{}][{}] Failed to initialized device state due to:", (Object)deviceIdInfo.getTenantId(), (Object)deviceIdInfo.getDeviceId());
            }
            return success ? result : result.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            String deviceIdsStr = deviceIds.stream().map(DeviceIdInfo::getDeviceId).map(UUIDBased::getId).map(UUID::toString).collect(Collectors.joining(", "));
            log.warn("Failed to initialized device state futures for ids [{}] due to:", (Object)deviceIdsStr, (Object)e);
            throw new RuntimeException("Failed to initialized device state futures for ids [" + deviceIdsStr + "]!", e);
        }
    }

    private List<DeviceStateData> fetchDeviceStateDataUsingEntityDataQuery(List<DeviceIdInfo> deviceIds) {
        EntityListFilter ef = new EntityListFilter();
        ef.setEntityType(EntityType.DEVICE);
        ef.setEntityList(deviceIds.stream().map(DeviceIdInfo::getDeviceId).map(UUIDBased::getId).map(UUID::toString).collect(Collectors.toList()));
        EntityDataQuery query = new EntityDataQuery((EntityFilter)ef, new EntityDataPageLink(deviceIds.size(), 0, null, null), PERSISTENT_ENTITY_FIELDS, this.persistToTelemetry ? PERSISTENT_TELEMETRY_KEYS : PERSISTENT_ATTRIBUTE_KEYS, Collections.emptyList());
        PageData queryResult = this.entityQueryRepository.findEntityDataByQueryInternal(query);
        Map deviceIdInfos = deviceIds.stream().collect(Collectors.toMap(DeviceIdInfo::getDeviceId, java.util.function.Function.identity()));
        return queryResult.getData().stream().map(ed -> this.toDeviceStateData((EntityData)ed, (DeviceIdInfo)deviceIdInfos.get(ed.getEntityId()))).collect(Collectors.toList());
    }

    private DeviceStateData toDeviceStateData(EntityData ed, DeviceIdInfo deviceIdInfo) {
        long lastActivityTime = this.getEntryValue(ed, this.getKeyType(), LAST_ACTIVITY_TIME, 0L);
        long inactivityAlarmTime = this.getEntryValue(ed, this.getKeyType(), INACTIVITY_ALARM_TIME, 0L);
        long inactivityTimeout = this.getEntryValue(ed, EntityKeyType.SERVER_ATTRIBUTE, INACTIVITY_TIMEOUT, this.defaultInactivityTimeoutMs);
        boolean active = this.getEntryValue(ed, this.getKeyType(), ACTIVITY_STATE, false);
        DeviceState deviceState = DeviceState.builder().active(active).lastConnectTime(this.getEntryValue(ed, this.getKeyType(), LAST_CONNECT_TIME, 0L)).lastDisconnectTime(this.getEntryValue(ed, this.getKeyType(), LAST_DISCONNECT_TIME, 0L)).lastActivityTime(lastActivityTime).lastInactivityAlarmTime(inactivityAlarmTime).inactivityTimeout(inactivityTimeout).build();
        TbMsgMetaData md = new TbMsgMetaData();
        md.putValue("deviceName", this.getEntryValue(ed, EntityKeyType.ENTITY_FIELD, "name", ""));
        md.putValue("deviceLabel", this.getEntryValue(ed, EntityKeyType.ENTITY_FIELD, "label", ""));
        md.putValue("deviceType", this.getEntryValue(ed, EntityKeyType.ENTITY_FIELD, "type", ""));
        return DeviceStateData.builder().customerId(deviceIdInfo.getCustomerId()).tenantId(deviceIdInfo.getTenantId()).deviceId(deviceIdInfo.getDeviceId()).deviceCreationTime(this.getEntryValue(ed, EntityKeyType.ENTITY_FIELD, "createdTime", 0L)).metaData(md).state(deviceState).build();
    }

    private EntityKeyType getKeyType() {
        return this.persistToTelemetry ? EntityKeyType.TIME_SERIES : EntityKeyType.SERVER_ATTRIBUTE;
    }

    private String getEntryValue(EntityData ed, EntityKeyType keyType, String keyName, String defaultValue) {
        return this.getEntryValue(ed, keyType, keyName, s -> s, defaultValue);
    }

    private long getEntryValue(EntityData ed, EntityKeyType keyType, String keyName, long defaultValue) {
        return this.getEntryValue(ed, keyType, keyName, Long::parseLong, defaultValue);
    }

    private boolean getEntryValue(EntityData ed, EntityKeyType keyType, String keyName, boolean defaultValue) {
        return this.getEntryValue(ed, keyType, keyName, Boolean::parseBoolean, defaultValue);
    }

    private <T> T getEntryValue(EntityData ed, EntityKeyType entityKeyType, String attributeName, Function<String, T> converter, T defaultValue) {
        TsValue value;
        Map map;
        if (ed != null && ed.getLatest() != null && (map = (Map)ed.getLatest().get(entityKeyType)) != null && (value = (TsValue)map.get(attributeName)) != null && !StringUtils.isEmpty((String)value.getValue())) {
            try {
                return (T)converter.apply((Object)value.getValue());
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private long getEntryValue(List<? extends KvEntry> kvEntries, String attributeName, long defaultValue) {
        if (kvEntries != null) {
            for (KvEntry kvEntry : kvEntries) {
                if (kvEntry == null || StringUtils.isEmpty((String)kvEntry.getKey()) || !kvEntry.getKey().equals(attributeName)) continue;
                return kvEntry.getLongValue().orElse(defaultValue);
            }
        }
        return defaultValue;
    }

    private boolean getEntryValue(List<? extends KvEntry> kvEntries, String attributeName, boolean defaultValue) {
        if (kvEntries != null) {
            for (KvEntry kvEntry : kvEntries) {
                if (kvEntry == null || StringUtils.isEmpty((String)kvEntry.getKey()) || !kvEntry.getKey().equals(attributeName)) continue;
                return kvEntry.getBooleanValue().orElse(defaultValue);
            }
        }
        return defaultValue;
    }

    private void pushRuleEngineMessage(DeviceStateData stateData, TbMsgType msgType) {
        TenantId tenantId = stateData.getTenantId();
        DeviceId deviceId = stateData.getDeviceId();
        DeviceState state = stateData.getState();
        try {
            String data;
            if (msgType.equals((Object)TbMsgType.CONNECT_EVENT)) {
                ObjectNode stateNode = (ObjectNode)JacksonUtil.convertValue((Object)state, ObjectNode.class);
                stateNode.remove(ACTIVITY_STATE);
                data = JacksonUtil.toString((Object)stateNode);
            } else {
                data = JacksonUtil.toString((Object)state);
            }
            TbMsgMetaData md = stateData.getMetaData().copy();
            if (!this.persistToTelemetry) {
                md.putValue("scope", "SERVER_SCOPE");
            }
            TbMsg tbMsg = TbMsg.newMsg().type(msgType).originator((EntityId)deviceId).customerId(stateData.getCustomerId()).copyMetaData(md).dataType(TbMsgDataType.JSON).data(data).build();
            this.clusterService.pushMsgToRuleEngine(stateData.getTenantId(), (EntityId)stateData.getDeviceId(), tbMsg, null);
        }
        catch (Exception e) {
            log.warn("[{}][{}] Failed to push '{}' message to the rule engine due to {}. Device state: {}", new Object[]{tenantId, deviceId, msgType, e.getMessage(), state});
        }
    }

    private ListenableFuture<Void> save(TenantId tenantId, DeviceId deviceId, String key, long value) {
        return this.save(tenantId, deviceId, (KvEntry)new LongDataEntry(key, Long.valueOf(value)), this.getCurrentTimeMillis());
    }

    private ListenableFuture<Void> save(TenantId tenantId, DeviceId deviceId, String key, boolean value) {
        return this.save(tenantId, deviceId, (KvEntry)new BooleanDataEntry(key, Boolean.valueOf(value)), this.getCurrentTimeMillis());
    }

    private ListenableFuture<Void> save(TenantId tenantId, DeviceId deviceId, KvEntry kvEntry, long ts) {
        Object future = this.persistToTelemetry ? this.tsSubService.saveTimeseriesInternal(TimeseriesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).entry((TsKvEntry)new BasicTsKvEntry(ts, kvEntry)).ttl((long)this.telemetryTtl).callback(new TelemetrySaveCallback(deviceId, kvEntry)).build()) : this.tsSubService.saveAttributesInternal(AttributesSaveRequest.builder().tenantId(tenantId).entityId((EntityId)deviceId).scope(AttributeScope.SERVER_SCOPE).entry((AttributeKvEntry)new BaseAttributeKvEntry(ts, kvEntry)).callback(new TelemetrySaveCallback(deviceId, kvEntry)).build());
        return Futures.transform(future, __ -> null, (Executor)MoreExecutors.directExecutor());
    }

    long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    @ConstructorProperties(value={"deviceService", "attributesService", "tsService", "clusterService", "partitionService", "entityQueryRepository", "dbTypeInfoComponent", "apiUsageReportClient", "notificationRuleProcessor"})
    @Generated
    public DefaultDeviceStateService(DeviceService deviceService, AttributesService attributesService, TimeseriesService tsService, TbClusterService clusterService, PartitionService partitionService, EntityQueryRepository entityQueryRepository, DbTypeInfoComponent dbTypeInfoComponent, TbApiUsageReportClient apiUsageReportClient, NotificationRuleProcessor notificationRuleProcessor) {
        this.deviceService = deviceService;
        this.attributesService = attributesService;
        this.tsService = tsService;
        this.clusterService = clusterService;
        this.partitionService = partitionService;
        this.entityQueryRepository = entityQueryRepository;
        this.dbTypeInfoComponent = dbTypeInfoComponent;
        this.apiUsageReportClient = apiUsageReportClient;
        this.notificationRuleProcessor = notificationRuleProcessor;
    }

    private static class DevicePackFutureHolder {
        private volatile ListenableFuture<?> future;

        private DevicePackFutureHolder() {
        }
    }

    private record TelemetrySaveCallback<T>(DeviceId deviceId, KvEntry kvEntry) implements FutureCallback<T>
    {
        public void onSuccess(@Nullable T result) {
            log.trace("[{}] Successfully updated entry {}", (Object)this.deviceId, (Object)this.kvEntry);
        }

        public void onFailure(@NonNull Throwable t) {
            log.warn("[{}] Failed to update entry {}", new Object[]{this.deviceId, this.kvEntry, t});
        }
    }
}

